/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import junit.framework.TestCase;

public class TestTempDirectory
extends TestCase {
    private TempDirectory temp;

    private void assertFileExists(TempDirectory tempDirectory) {
        TestTempDirectory.assertTrue((boolean)new File(tempDirectory.getPath()).exists());
    }

    private void assertFileDoesNotExist(TempDirectory tempDirectory) {
        TestTempDirectory.assertFalse((boolean)new File(tempDirectory.getPath()).exists());
    }

    public void testGetPath() {
        String tempPath = this.temp.getPath();
        TestTempDirectory.assertEquals((String)this.getTestPath(), (String)tempPath);
    }

    public void testDirectoryNotCreatedInitially() {
        this.assertFileDoesNotExist(this.temp);
    }

    public void testCreate() {
        this.temp.create();
        this.assertFileExists(this.temp);
    }

    public void testRemove() {
        this.temp.create();
        this.temp.remove();
        this.assertFileDoesNotExist(this.temp);
    }

    public void testRemoveChildrenFiles() {
        this.temp.create();
        new FileUtil(this.temp.getPath() + File.separator + "file1.txt").write("test data");
        this.temp.remove();
        this.assertFileDoesNotExist(this.temp);
    }

    public void testRemoveChildrenDirectories() {
        this.temp.create();
        new File(this.temp.getPath() + File.separator + "subDirectory").mkdir();
        new FileUtil(this.temp.getPath() + File.separator + "subDirectory" + File.separator + "file1.txt").write("test data");
        this.temp.remove();
        this.assertFileDoesNotExist(this.temp);
    }

    public void testStaticTempDirectory() {
        TempDirectory newTmp = TempDirectory.getTempDirectory((String)UnitTestUtil.getTestDataPath());
        this.assertFileExists(newTmp);
        newTmp.remove();
        this.assertFileDoesNotExist(newTmp);
    }

    public void testStaticTempDirectoryWithSubDirs() {
        TempDirectory newTmp = TempDirectory.getTempDirectory((String)(UnitTestUtil.getTestScratchPath() + "/fred/joe/mary"));
        this.assertFileExists(newTmp);
        newTmp.remove();
        this.assertFileDoesNotExist(newTmp);
    }

    public void testStaticTempDirectoryWithSubDirsExists() {
        TempDirectory newTmp = TempDirectory.getTempDirectory((String)(UnitTestUtil.getTestScratchPath() + "/fred/joe/mary"));
        this.assertFileExists(newTmp);
        TempDirectory newTmp2 = TempDirectory.getTempDirectory((String)(UnitTestUtil.getTestScratchPath() + "/fred/joe/mary"));
        newTmp.remove();
        newTmp2.remove();
    }

    public void testStaticTempDirectoryDefaultLocation() {
        TempDirectory newTmp = TempDirectory.getTempDirectory(null);
        this.assertFileExists(newTmp);
        newTmp.remove();
        this.assertFileDoesNotExist(newTmp);
    }

    private String getTestPath() {
        return StringUtilities.buildPath((String)System.getProperty("java.io.tmpdir"), (String)"100_99");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.temp = new TempDirectory(100L, 99L);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        new File(this.getTestPath()).delete();
    }
}

