/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml;

import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.internal.core.xml.XPathHelper;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import net.sf.saxon.trans.XPathException;
import org.jdom.Attribute;
import org.jdom.Element;

public class TestXPathHelper
extends TestCase {
    public TestXPathHelper(String name) {
        super(name);
    }

    public String getContentOfTestFile(String testFilePath) {
        File file = UnitTestUtil.getTestDataFile((String)testFilePath);
        TestXPathHelper.assertNotNull((Object)file);
        TestXPathHelper.assertEquals((boolean)true, (boolean)file.exists());
        FileUtil util = new FileUtil(file.getAbsolutePath());
        TestXPathHelper.assertNotNull((Object)util);
        return util.read();
    }

    public String helpTestXpathValue(String xmlFilePath, String xpath, String expected) throws XPathException, IOException {
        String actual = this.helpGetNode(xmlFilePath, xpath);
        TestXPathHelper.assertEquals((String)expected, (String)actual);
        return actual;
    }

    public String helpGetNode(String xmlFilePath, String xpath) throws XPathException, IOException {
        String xmlContent = this.getContentOfTestFile(xmlFilePath);
        StringReader docReader = new StringReader(xmlContent);
        return XPathHelper.getSingleMatchAsString((Reader)docReader, (String)xpath);
    }

    public void helpCheckElement(Object jdomNode, String name, String prefix, String namespaceUri, String textContent) {
        TestXPathHelper.assertTrue((String)"Supplied JDOM node is not an Element", (boolean)(jdomNode instanceof Element));
        Element element = (Element)jdomNode;
        TestXPathHelper.assertEquals((String)name, (String)element.getName());
        TestXPathHelper.assertEquals((String)prefix, (String)element.getNamespacePrefix());
        TestXPathHelper.assertEquals((String)namespaceUri, (String)element.getNamespaceURI());
        String actualTextContent = element.getText();
        if (textContent == null) {
            TestXPathHelper.assertEquals((int)0, (int)actualTextContent.length());
        } else {
            TestXPathHelper.assertEquals((String)textContent, (String)actualTextContent);
        }
    }

    public void helpCheckElement(Object jdomNode, String name, String prefix, String namespaceUri) {
        TestXPathHelper.assertTrue((String)"Supplied JDOM node is not an Element", (boolean)(jdomNode instanceof Element));
        Element element = (Element)jdomNode;
        TestXPathHelper.assertEquals((String)name, (String)element.getName());
        TestXPathHelper.assertEquals((String)prefix, (String)element.getNamespacePrefix());
        TestXPathHelper.assertEquals((String)namespaceUri, (String)element.getNamespaceURI());
    }

    public void helpCheckAttribute(Object jdomNode, String name, String prefix, String namespaceUri, String value) {
        TestXPathHelper.assertTrue((String)"Supplied JDOM node is not an Attribute", (boolean)(jdomNode instanceof Attribute));
        Attribute attribute = (Attribute)jdomNode;
        TestXPathHelper.assertEquals((String)name, (String)attribute.getName());
        TestXPathHelper.assertEquals((String)prefix, (String)attribute.getNamespacePrefix());
        TestXPathHelper.assertEquals((String)namespaceUri, (String)attribute.getNamespaceURI());
        String actualTextContent = attribute.getValue();
        TestXPathHelper.assertEquals((String)value, (String)actualTextContent);
    }

    public void testValidateXpath_Defect15088() {
        String xpath = "//*[local-name()='bookName\"]";
        try {
            XPathHelper.validateXpath((String)"//*[local-name()='bookName\"]");
            TestXPathHelper.fail((String)"Expected validation error but got none");
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public void testValidateXpath_null() throws Exception {
        XPathHelper.validateXpath(null);
    }

    public void testValidateXpath_valid() throws Exception {
        XPathHelper.validateXpath((String)"//shipTo/@country");
    }

    public void testGetSingleMatch_01_001() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//shipTo/@country";
        String expectedValue = "US";
        this.helpTestXpathValue("testdoc.xml", "//shipTo/@country", "US");
    }

    public void testGetSingleMatch_01_002() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//@partNum";
        String expectedValue = "872-AA";
        this.helpTestXpathValue("testdoc.xml", "//@partNum", "872-AA");
    }

    public void testGetSingleMatch_01_003() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//productName";
        String expectedValue = "Lawnmower";
        this.helpTestXpathValue("testdoc.xml", "//productName", "Lawnmower");
    }

    public void testGetSingleMatch_01_004() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "/*:Envelope/billTo/zip";
        String expectedValue = "95819";
        this.helpTestXpathValue("testdoc.xml", "/*:Envelope/billTo/zip", "95819");
    }

    public void testGetSingleMatch_02_001() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "/*:Envelope/*:HEADER/*:RequestID";
        this.helpTestXpathValue("testdoc.xml", "/*:Envelope/*:HEADER/*:RequestID", null);
    }

    public void testGetSingleMatch_03() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//*[local-name()=\"ReadOnly\"]";
        this.helpTestXpathValue("testdoc.xml", "//*[local-name()=\"ReadOnly\"]", "false");
    }

    public void testGetSingleMatch_04() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//*:ReadOnly";
        this.helpTestXpathValue("testdoc.xml", "//*:ReadOnly", "false");
    }
}

