/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.vdb;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import com.metamatrix.internal.core.xml.vdb.VdbHeaderReader;
import com.metamatrix.internal.core.xml.vdb.VdbModelInfo;
import com.metamatrix.internal.core.xml.vdb.VdbNonModelInfo;
import java.io.File;
import junit.framework.TestCase;

public class TestVdbHeaderReader
extends TestCase {
    public TestVdbHeaderReader(String name) {
        super(name);
    }

    private VdbHeader helpReadHeader(VdbHeaderReader reader, File f, boolean expectSuccess) {
        VdbHeader header;
        block3: {
            TestVdbHeaderReader.assertNotNull((Object)reader);
            TestVdbHeaderReader.assertNotNull((Object)f);
            header = null;
            try {
                header = reader.read(f);
            }
            catch (Throwable e) {
                if (!expectSuccess) break block3;
                throw new RuntimeException(e);
            }
        }
        if (!expectSuccess && header != null) {
            TestVdbHeaderReader.fail((String)("Expected failure but instead found header " + header));
        }
        return header;
    }

    public void testCreate() {
        new VdbHeaderReader();
    }

    public void testReadNonEmptyModel() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"nonEmptyModel.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertNull((Object)header.getUUID());
    }

    public void testReadEmptyModel() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"emptyModel.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertNull((Object)header.getUUID());
    }

    public void testReadNonModelFile() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"nonModelFile.txt");
        header = this.helpReadHeader(reader, testFile, false);
        TestVdbHeaderReader.assertNull((Object)header);
    }

    public void testReadSampleMSWordDoc() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"sampleMSWord.doc");
        header = this.helpReadHeader(reader, testFile, false);
        TestVdbHeaderReader.assertNull((Object)header);
    }

    public void testReadManifest() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertEquals((int)2, (int)header.getModelInfos().length);
        TestVdbHeaderReader.assertEquals((int)0, (int)header.getNonModelInfos().length);
        TestVdbHeaderReader.assertEquals((String)"mmuuid:738adb40-21b2-1edb-bb0f-84717d38b299", (String)header.getUUID());
        TestVdbHeaderReader.assertEquals((String)"ERROR", (String)header.getSeverity());
        TestVdbHeaderReader.assertEquals((int)3, (int)header.getSeverityCode());
    }

    public void testReadManifest2() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel2.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertEquals((int)5, (int)header.getModelInfos().length);
        TestVdbHeaderReader.assertEquals((int)0, (int)header.getNonModelInfos().length);
        TestVdbHeaderReader.assertEquals((String)"mmuuid:2f21ec00-138c-1f2d-a72f-ff6ac3dbb7c0", (String)header.getUUID());
        TestVdbHeaderReader.assertTrue((boolean)header.getDescription().startsWith("More than a million people along Florida's east"));
        TestVdbHeaderReader.assertEquals((String)"OK", (String)header.getSeverity());
        TestVdbHeaderReader.assertEquals((int)0, (int)header.getSeverityCode());
        TestVdbHeaderReader.assertEquals((String)"MetaMatrix", (String)header.getProducerName());
        TestVdbHeaderReader.assertEquals((String)"4.2.0", (String)header.getProducerVersion());
        TestVdbHeaderReader.assertEquals((String)"2004-09-02T13:24:29.872-06:00", (String)header.getTimeLastChanged());
        TestVdbHeaderReader.assertEquals((String)"2004-09-02T13:24:29.872-06:00", (String)header.getTimeLastProduced());
        VdbModelInfo info = header.getModelInfos()[0];
        TestVdbHeaderReader.assertEquals((String)"PartsSupplierOracle.xmi", (String)info.getName());
        TestVdbHeaderReader.assertEquals((String)"/MaterializedViewTesting/PartsSupplierOracle.xmi", (String)info.getPath());
        TestVdbHeaderReader.assertEquals((String)"mmuuid:a2527680-1360-1f2d-a72f-ff6ac3dbb7c0", (String)info.getUUID());
        TestVdbHeaderReader.assertEquals((String)"PHYSICAL", (String)info.getModelType());
        TestVdbHeaderReader.assertEquals((String)"http://www.metamatrix.com/metamodels/Relational", (String)info.getPrimaryMetamodelURI());
        TestVdbHeaderReader.assertEquals((long)0L, (long)info.getCheckSum());
    }

    public void testReadManifest3() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel3.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertEquals((int)9, (int)header.getModelInfos().length);
        TestVdbHeaderReader.assertEquals((int)0, (int)header.getNonModelInfos().length);
        TestVdbHeaderReader.assertEquals((String)"mmuuid:d4ee4e00-cffe-1ef2-9d34-e6f134eadf81", (String)header.getUUID());
        TestVdbHeaderReader.assertEquals((String)"MetaMatrix", (String)header.getProducerName());
        TestVdbHeaderReader.assertEquals((String)"Apollo", (String)header.getProducerVersion());
        TestVdbHeaderReader.assertEquals((String)"WARNING", (String)header.getSeverity());
        TestVdbHeaderReader.assertEquals((int)2, (int)header.getSeverityCode());
    }

    public void testReadManifest4() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel4.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertEquals((int)0, (int)header.getModelInfos().length);
        TestVdbHeaderReader.assertEquals((int)1, (int)header.getNonModelInfos().length);
        TestVdbHeaderReader.assertEquals((String)"mmuuid:698cda02-5479-1f93-8b1e-9e2dfc4e3733", (String)header.getUUID());
        VdbNonModelInfo info2 = header.getNonModelInfos()[0];
        TestVdbHeaderReader.assertEquals((String)"SampleRelational.xmi", (String)info2.getName());
        TestVdbHeaderReader.assertEquals((String)"/ProjectForSimpleVdb/SampleRelational.xmi", (String)info2.getPath());
        TestVdbHeaderReader.assertEquals((long)2645090403L, (long)info2.getCheckSum());
    }

    public void testReadManifest5() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel5.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertEquals((int)7, (int)header.getModelInfos().length);
        TestVdbHeaderReader.assertEquals((int)0, (int)header.getNonModelInfos().length);
        TestVdbHeaderReader.assertEquals((String)"mmuuid:6d179c02-f639-1f59-a112-e0eac778cc3c", (String)header.getUUID());
        TestVdbHeaderReader.assertTrue((boolean)header.getDescription().startsWith("This virtual database (VDB) definition file contains the models"));
        TestVdbHeaderReader.assertEquals((String)"WARNING", (String)header.getSeverity());
        TestVdbHeaderReader.assertEquals((int)2, (int)header.getSeverityCode());
        TestVdbHeaderReader.assertEquals((String)"MetaMatrix", (String)header.getProducerName());
        TestVdbHeaderReader.assertEquals((String)"4.2.0", (String)header.getProducerVersion());
        TestVdbHeaderReader.assertEquals((String)"2005-08-02T11:32:38.375-06:00", (String)header.getTimeLastChanged());
        TestVdbHeaderReader.assertEquals((String)"2005-08-02T11:32:38.375-06:00", (String)header.getTimeLastProduced());
        VdbModelInfo info = header.getModelInfos()[3];
        TestVdbHeaderReader.assertEquals((String)"BooksXML.xmi", (String)info.getName());
        TestVdbHeaderReader.assertEquals((String)"/Books Project/BooksXML.xmi", (String)info.getPath());
        TestVdbHeaderReader.assertEquals((String)"mmuuid:f96d8dc0-0dc9-1eec-8518-c32201e76066", (String)info.getUUID());
        TestVdbHeaderReader.assertEquals((String)"VIRTUAL", (String)info.getModelType());
        TestVdbHeaderReader.assertEquals((String)"http://www.metamatrix.com/metamodels/XmlDocument", (String)info.getPrimaryMetamodelURI());
        TestVdbHeaderReader.assertEquals((long)4222954943L, (long)info.getCheckSum());
        info = header.getModelInfos()[1];
        TestVdbHeaderReader.assertEquals((String)"Books.xsd", (String)info.getName());
        TestVdbHeaderReader.assertEquals((String)"/Books Project/Books.xsd", (String)info.getPath());
        TestVdbHeaderReader.assertNull((Object)info.getUUID());
        TestVdbHeaderReader.assertEquals((String)"TYPE", (String)info.getModelType());
        TestVdbHeaderReader.assertEquals((String)"http://www.eclipse.org/xsd/2002/XSD", (String)info.getPrimaryMetamodelURI());
        TestVdbHeaderReader.assertEquals((long)2392354248L, (long)info.getCheckSum());
    }

    public void testReadManifest6() {
        VdbHeaderReader reader = new VdbHeaderReader();
        File testFile = null;
        VdbHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel6.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestVdbHeaderReader.assertEquals((int)4, (int)header.getModelInfos().length);
        TestVdbHeaderReader.assertEquals((int)1, (int)header.getNonModelInfos().length);
        TestVdbHeaderReader.assertEquals((String)"System", (String)header.getName());
        TestVdbHeaderReader.assertEquals((String)"mmuuid:7abbce82-5efe-1f59-bb2d-ec2ea3ba5f60", (String)header.getUUID());
        TestVdbHeaderReader.assertEquals((String)"WARNING", (String)header.getSeverity());
        TestVdbHeaderReader.assertEquals((int)2, (int)header.getSeverityCode());
        TestVdbHeaderReader.assertEquals((String)"MetaMatrix", (String)header.getProducerName());
        TestVdbHeaderReader.assertEquals((String)"4.3.0", (String)header.getProducerVersion());
        TestVdbHeaderReader.assertEquals((String)"2005-08-09T15:25:51.462-06:00", (String)header.getTimeLastChanged());
        TestVdbHeaderReader.assertEquals((String)"2005-08-09T15:25:51.462-06:00", (String)header.getTimeLastProduced());
        VdbModelInfo info = header.getModelInfos()[0];
        TestVdbHeaderReader.assertEquals((String)"SystemSchema.xsd", (String)info.getName());
        TestVdbHeaderReader.assertEquals((String)"/System/SystemSchema.xsd", (String)info.getPath());
        TestVdbHeaderReader.assertNull((Object)info.getUUID());
        TestVdbHeaderReader.assertEquals((String)"TYPE", (String)info.getModelType());
        TestVdbHeaderReader.assertEquals((String)"http://www.eclipse.org/xsd/2002/XSD", (String)info.getPrimaryMetamodelURI());
        TestVdbHeaderReader.assertEquals((long)3565284344L, (long)info.getCheckSum());
        info = header.getModelInfos()[1];
        TestVdbHeaderReader.assertEquals((String)"SystemDocument.xmi", (String)info.getName());
        TestVdbHeaderReader.assertEquals((String)"/System/SystemDocument.xmi", (String)info.getPath());
        TestVdbHeaderReader.assertEquals((String)"mmuuid:b77b1cc0-dd8d-1ee9-a82c-9f4fb5468132", (String)info.getUUID());
        TestVdbHeaderReader.assertEquals((String)"VIRTUAL", (String)info.getModelType());
        TestVdbHeaderReader.assertEquals((String)"http://www.metamatrix.com/metamodels/XmlDocument", (String)info.getPrimaryMetamodelURI());
        TestVdbHeaderReader.assertEquals((long)2957602990L, (long)info.getCheckSum());
        info = header.getModelInfos()[3];
        TestVdbHeaderReader.assertEquals((String)"System.xmi", (String)info.getName());
        TestVdbHeaderReader.assertEquals((String)"/System/System.xmi", (String)info.getPath());
        TestVdbHeaderReader.assertEquals((String)"mmuuid:70ffc880-29d8-1de6-8a38-9d76e1f90f2e", (String)info.getUUID());
        TestVdbHeaderReader.assertEquals((String)"VIRTUAL", (String)info.getModelType());
        TestVdbHeaderReader.assertEquals((String)"http://www.metamatrix.com/metamodels/Relational", (String)info.getPrimaryMetamodelURI());
        TestVdbHeaderReader.assertEquals((long)1316247188L, (long)info.getCheckSum());
        VdbNonModelInfo info2 = header.getNonModelInfos()[0];
        TestVdbHeaderReader.assertEquals((String)"System.DEF", (String)info2.getName());
        TestVdbHeaderReader.assertEquals((String)"System.DEF", (String)info2.getPath());
        TestVdbHeaderReader.assertEquals((long)1667846304L, (long)info2.getCheckSum());
    }
}

