/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xmi;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.internal.core.xml.xmi.ModelImportInfo;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import java.io.File;
import junit.framework.TestCase;

public class TestXMIHeaderReader
extends TestCase {
    public TestXMIHeaderReader(String name) {
        super(name);
    }

    private XMIHeader helpReadHeader(XMIHeaderReader reader, File f, boolean expectSuccess) {
        XMIHeader header;
        block3: {
            TestXMIHeaderReader.assertNotNull((Object)reader);
            TestXMIHeaderReader.assertNotNull((Object)f);
            header = null;
            try {
                header = reader.read(f);
            }
            catch (Throwable e) {
                if (!expectSuccess) break block3;
                throw new RuntimeException(e);
            }
        }
        if (!expectSuccess && header != null) {
            TestXMIHeaderReader.fail((String)("Expected failure but instead found header " + header));
        }
        return header;
    }

    public void testRead() {
        XMIHeaderReader reader = new XMIHeaderReader();
        File testFile = null;
        XMIHeader header = null;
        testFile = UnitTestUtil.getTestDataFile((String)"nonEmptyModel.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)5, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:6613f180-10ab-1ecc-b71a-a65bb31ca97b", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"emptyModel.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)3, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:7fd3f8c0-0ff4-1ecc-bb21-bf6f5277bd68", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"nonModelFile.txt");
        header = this.helpReadHeader(reader, testFile, false);
        TestXMIHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"sampleMSWord.doc");
        header = this.helpReadHeader(reader, testFile, false);
        TestXMIHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"BooksSQLServer.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)6, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:3ba8ad00-1272-1ed1-b625-afaffdadee3e", (String)header.getUUID());
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        testFile = UnitTestUtil.getTestDataFile((String)"BooksCatalogDoc.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        TestXMIHeaderReader.assertEquals((int)7, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)4, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:cf338c40-fa5e-1f0e-8827-b258024845e3", (String)header.getUUID());
        ModelImportInfo info = header.getModelImportInfos()[1];
        TestXMIHeaderReader.assertEquals((String)"BooksOracle", (String)info.getName());
        TestXMIHeaderReader.assertEquals((String)"/TestProject0520/BooksOracle.xmi", (String)info.getPath());
        TestXMIHeaderReader.assertEquals((String)"mmuuid:ffa4c2c0-f961-1f0e-8827-b258024845e3", (String)info.getUUID());
        TestXMIHeaderReader.assertEquals((String)"PHYSICAL", (String)info.getModelType());
        TestXMIHeaderReader.assertEquals((String)"http://www.metamatrix.com/metamodels/Relational", (String)info.getPrimaryMetamodelURI());
        testFile = UnitTestUtil.getTestDataFile((String)"virtualModelWithImports.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        TestXMIHeaderReader.assertEquals((int)7, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:e30f25c0-13d6-1ed4-852d-b1622e809d4f", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"Books.xsd");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)3, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:738adb40-21b2-1edb-bb0f-84717d38b299", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel2.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)3, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)5, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:2f21ec00-138c-1f2d-a72f-ff6ac3dbb7c0", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel3.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)3, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)9, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:d4ee4e00-cffe-1ef2-9d34-e6f134eadf81", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel4.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:698cda02-5479-1f93-8b1e-9e2dfc4e3733", (String)header.getUUID());
        testFile = UnitTestUtil.getTestDataFile((String)"SingleRootEmpty.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:e103e100-47a7-1f04-9a10-e53b219c8f76", (String)header.getUUID());
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        testFile = UnitTestUtil.getTestDataFile((String)"partsSupplierOracle_v0200.xml");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"1.1", (String)header.getXmiVersion());
        TestXMIHeaderReader.assertNull((Object)header.getUUID());
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        testFile = UnitTestUtil.getTestDataFile((String)"VirtualNorthwind.xml");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"1.1", (String)header.getXmiVersion());
        TestXMIHeaderReader.assertNull((Object)header.getUUID());
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        testFile = UnitTestUtil.getTestDataFile((String)"TestUml4.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getNamespaceURIs().length);
        TestXMIHeaderReader.assertEquals((int)0, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:98783900-c3e0-1f07-9a25-c5dc8f8cd8d9", (String)header.getUUID());
        TestXMIHeaderReader.assertNull((Object)header.getProducerName());
        TestXMIHeaderReader.assertNull((Object)header.getProducerVersion());
        testFile = UnitTestUtil.getTestDataFile((String)"BQT_SQLServer.xmi");
        header = this.helpReadHeader(reader, testFile, true);
        TestXMIHeaderReader.assertEquals((int)2, (int)header.getModelImportInfos().length);
        TestXMIHeaderReader.assertEquals((String)"mmuuid:99a9be00-e527-1ff0-b108-85ef0ae7b7f4", (String)header.getUUID());
        TestXMIHeaderReader.assertEquals((String)"MetaMatrix", (String)header.getProducerName());
        TestXMIHeaderReader.assertEquals((String)"5.5", (String)header.getProducerVersion());
    }
}

