/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xsd;

import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.internal.core.xml.xsd.TerminatingXsdHeaderContentHandler;
import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import com.metamatrix.internal.core.xml.xsd.XsdHeaderReader;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXsdHeaderReader
extends TestCase {
    public TestXsdHeaderReader(String name) {
        super(name);
    }

    private XsdHeader helpReadHeader(XsdHeaderReader reader, File f, boolean expectSuccess) {
        XsdHeader header;
        block4: {
            TestXsdHeaderReader.assertNotNull((Object)reader);
            TestXsdHeaderReader.assertNotNull((Object)f);
            header = null;
            try {
                header = reader.read(f);
            }
            catch (Throwable e) {
                if (!expectSuccess) break block4;
                throw new RuntimeException(e);
            }
        }
        if (expectSuccess && header == null) {
            TestXsdHeaderReader.fail((String)"Expected success but the header was null");
        }
        if (!expectSuccess && header != null) {
            TestXsdHeaderReader.fail((String)("Expected failure but instead found header " + header));
        }
        return header;
    }

    public void testRead() {
        XsdHeaderReader reader = new XsdHeaderReader();
        File testFile = UnitTestUtil.getTestDataFile((String)"nonEmptyModel.xmi");
        XsdHeader header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"emptyModel.xmi");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"nonModelFile.txt");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"sampleMSWord.doc");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"BooksSQLServer.xmi");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"virtualModelWithImports.xmi");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"Books.xsd");
        header = this.helpReadHeader(reader, testFile, true);
        TestXsdHeaderReader.assertNotNull((Object)header);
        TestXsdHeaderReader.assertEquals((String)"http://www.metamatrix.com/XMLSchema/DataSets/Books", (String)header.getTargetNamespaceURI());
        TestXsdHeaderReader.assertEquals((int)3, (int)header.getNamespaceURIs().length);
        TestXsdHeaderReader.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)header.getNamespaceURIs()[0]);
        TestXsdHeaderReader.assertEquals((String)"http://www.metamatrix.com/XMLSchema/DataSets/Books/BookDatatypes", (String)header.getNamespaceURIs()[1]);
        TestXsdHeaderReader.assertEquals((String)"http://www.metamatrix.com/XMLSchema/DataSets/Books", (String)header.getNamespaceURIs()[2]);
        TestXsdHeaderReader.assertEquals((int)1, (int)header.getImportNamespaces().length);
        TestXsdHeaderReader.assertEquals((String)"http://www.metamatrix.com/XMLSchema/DataSets/Books/BookDatatypes", (String)header.getImportNamespaces()[0]);
        TestXsdHeaderReader.assertEquals((int)1, (int)header.getImportSchemaLocations().length);
        TestXsdHeaderReader.assertEquals((String)"BookDatatypes.xsd", (String)header.getImportSchemaLocations()[0]);
        TestXsdHeaderReader.assertEquals((int)0, (int)header.getIncludeSchemaLocations().length);
        testFile = UnitTestUtil.getTestDataFile((String)"nonExistentFile.xsd");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"MetaMatrix-VdbManifestModel.xmi");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"SingleRootEmpty.xmi");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"partsSupplierOracle_v0200.xml");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"VirtualNorthwind.xml");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
        testFile = UnitTestUtil.getTestDataFile((String)"TestUml4.xmi");
        header = this.helpReadHeader(reader, testFile, false);
        TestXsdHeaderReader.assertNull((Object)header);
    }

    public void testReadException() throws Exception {
        FileInputStream istream = new FileInputStream(UnitTestUtil.getTestDataFile((String)"Books.xsd"));
        try {
            TerminatingXsdHeaderContentHandler handler = new TerminatingXsdHeaderContentHandler();
            Thread.currentThread().setContextClassLoader(XsdHeaderReader.class.getClassLoader());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(istream), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            return;
        }
        TestXsdHeaderReader.fail((String)"Did not get expected exception");
    }
}

