/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.materialization;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.vdb.materialization.DatabaseDialect;
import com.metamatrix.vdb.materialization.template.ExpandedTemplate;
import com.metamatrix.vdb.materialization.template.MaterializedViewData;
import com.metamatrix.vdb.materialization.template.TemplateData;
import com.metamatrix.vdb.materialization.template.TemplateExpander;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;

public class TestGenerateScripts
extends TestCase {
    private void helpTestTemplate(String command, DatabaseDialect database, TemplateExpander expander) {
        ExpandedTemplate template = expander.expand("aVDBName", this.getTemplateReaders(command, database), command);
        String actual = template.contents.trim();
        this.checkScript(actual, database, command);
    }

    public void test() {
        TestGenerateScripts.assertEquals((String)"viewName=view1", (String)new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.SQL_SERVER).expandText("viewName=$viewName$"));
    }

    public void testTruncateDB2Template() {
        this.helpTestTemplate("truncate", DatabaseDialect.DB2, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.DB2));
    }

    public void testTruncateOracleTemplate() {
        this.helpTestTemplate("truncate", DatabaseDialect.ORACLE, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.ORACLE));
    }

    public void testTruncateSQLServerTemplate() {
        this.helpTestTemplate("truncate", DatabaseDialect.SQL_SERVER, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.SQL_SERVER));
    }

    public void testLoadMetaMatrixTemplate() {
        this.helpTestTemplate("load", DatabaseDialect.METAMATRIX, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.METAMATRIX));
    }

    public void testSwapDB2Template() {
        this.helpTestTemplate("swap", DatabaseDialect.DB2, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.DB2));
    }

    public void testSwapOracleTemplate() {
        this.helpTestTemplate("swap", DatabaseDialect.ORACLE, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.ORACLE));
    }

    public void testSwapSQLServerTemplate() {
        this.helpTestTemplate("swap", DatabaseDialect.SQL_SERVER, new TemplateExpander((TemplateData)this.getData(), DatabaseDialect.SQL_SERVER));
    }

    private Reader[] getTemplateReaders(String command, DatabaseDialect database) {
        return new Reader[]{TestGenerateScripts.getReader("scriptMaterializedView"), TestGenerateScripts.getReader("loadMaterializedView_" + database)};
    }

    private static InputStreamReader getReader(String fileName) {
        String templateName = "com/metamatrix/vdb/materialization/template/" + fileName + ".stg";
        InputStream inputStream = TestGenerateScripts.class.getClassLoader().getResourceAsStream(templateName);
        if (inputStream == null) {
            throw new MetaMatrixRuntimeException("Unable to find resource: " + templateName);
        }
        return new InputStreamReader(inputStream);
    }

    private MaterializedViewData getData() {
        MaterializedViewData data = new MaterializedViewData("view1", new String[]{"column1", "column2", "column3"}, "virtualGroupName", "materializationTableNameInSrc", "materializationTable", "materializationStageTableNameInSrc", "materializationStageTableName");
        return data;
    }

    private void checkScript(String actual, DatabaseDialect database, String command) {
        String expected = new FileUtil(UnitTestUtil.getTestDataPath() + "/materializedView/expected/" + database + "_" + command + ".txt").read().trim();
        TestGenerateScripts.assertEquals((String)StringUtilities.removeChars((String)expected, (char[])new char[]{'\r'}), (String)actual.trim());
    }
}

