/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.materialization;

import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.vdb.materialization.DatabaseDialect;
import com.metamatrix.vdb.materialization.MaterializedViewScriptGeneratorImpl;
import com.metamatrix.vdb.materialization.ScriptType;
import com.metamatrix.vdb.materialization.template.MaterializedViewConnectionData;
import com.metamatrix.vdb.materialization.template.MaterializedViewData;
import com.metamatrix.vdb.materialization.template.TemplateData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class TestMaterializedViewScriptGenerator
extends TestCase {
    private static final String VDB_NAME = "MatviewTheFirst";
    private static final String VDB_SSL_NAME = "MatviewSSLTheFirst";
    private static final String VDB_VERSION_1 = "1";
    private static final String VDB_VERSION_2 = "2";

    public void testGenerateLoadScript() throws Exception {
        TemplateData loadTemplateData = this.helpCreateMatViewTemplateData(VDB_NAME);
        MaterializedViewScriptGeneratorImpl loadScriptGen = new MaterializedViewScriptGeneratorImpl(loadTemplateData);
        String scriptFileName = ScriptType.loadScriptFileName((String)VDB_NAME, (String)VDB_VERSION_1);
        try {
            FileOutputStream oStream = new FileOutputStream(UnitTestUtil.getTestScratchFile((String)scriptFileName));
            loadScriptGen.generateMaterializationLoadScript((OutputStream)oStream);
        }
        catch (IOException err) {
            TestMaterializedViewScriptGenerator.fail((String)("Error generating the load script: " + err.getMessage()));
        }
        this.checkScript(scriptFileName, scriptFileName);
    }

    public void testGenerateConnOraPropFile() throws Exception {
        TemplateData connectionTemplateData = this.helpCreateOraConnPropsTemplateData(VDB_NAME);
        MaterializedViewScriptGeneratorImpl swapScriptGen = new MaterializedViewScriptGeneratorImpl(connectionTemplateData);
        String propertyFileName = ScriptType.connectionPropertyFileName((String)VDB_NAME, (String)VDB_VERSION_2);
        FileOutputStream oStream = new FileOutputStream(UnitTestUtil.getTestScratchFile((String)propertyFileName));
        swapScriptGen.generateMaterializationConnectionPropFile((OutputStream)oStream);
        this.checkProperties(propertyFileName, propertyFileName);
    }

    public void testGenerateConnSQLServerPropFile() throws Exception {
        TemplateData connectionTemplateData = this.helpCreateSQLServerConnPropsTemplateData(VDB_NAME);
        MaterializedViewScriptGeneratorImpl swapScriptGen = new MaterializedViewScriptGeneratorImpl(connectionTemplateData);
        String propertyFileName = ScriptType.connectionPropertyFileName((String)VDB_NAME, (String)VDB_VERSION_1);
        FileOutputStream oStream = new FileOutputStream(UnitTestUtil.getTestScratchFile((String)propertyFileName));
        swapScriptGen.generateMaterializationConnectionPropFile((OutputStream)oStream);
        this.checkProperties(propertyFileName, propertyFileName);
    }

    public void testGenerateConnSQLServerPropFileUsingSSL() throws Exception {
        TemplateData connectionTemplateData = this.helpCreateSQLServerConnPropsTemplateDataUsingSSL(VDB_SSL_NAME);
        MaterializedViewScriptGeneratorImpl swapScriptGen = new MaterializedViewScriptGeneratorImpl(connectionTemplateData);
        String propertyFileName = ScriptType.connectionPropertyFileName((String)VDB_SSL_NAME, (String)VDB_VERSION_1);
        FileOutputStream oStream = new FileOutputStream(UnitTestUtil.getTestScratchFile((String)propertyFileName));
        swapScriptGen.generateMaterializationConnectionPropFile((OutputStream)oStream);
        this.checkProperties(propertyFileName, propertyFileName);
    }

    public void testGenerateScriptsByDBMSType() throws Exception {
        Collection templateData = this.helpCreateMatViewTemplateDataCollection();
        for (DatabaseDialect aDialect : DatabaseDialect.getAllDialects()) {
            this.helpTestScriptForMaterializedTable(templateData, aDialect);
        }
    }

    private void helpTestScriptForMaterializedTable(Collection templateData, DatabaseDialect aDialect) throws Exception {
        String truncFileName = ScriptType.truncateScriptFileName((DatabaseDialect)aDialect, (String)VDB_NAME);
        FileOutputStream truncStream = new FileOutputStream(UnitTestUtil.getTestScratchFile((String)truncFileName));
        String swapFileName = ScriptType.swapScriptFileName((DatabaseDialect)aDialect, (String)VDB_NAME);
        FileOutputStream swapStream = new FileOutputStream(UnitTestUtil.getTestScratchFile((String)swapFileName));
        Iterator materializationDataItr = templateData.iterator();
        while (materializationDataItr.hasNext()) {
            MaterializedViewScriptGeneratorImpl scriptGen = new MaterializedViewScriptGeneratorImpl((TemplateData)materializationDataItr.next());
            scriptGen.generateMaterializationTruncateScript((OutputStream)truncStream, aDialect);
            scriptGen.generateMaterializationSwapScript((OutputStream)swapStream, aDialect);
        }
        ((OutputStream)truncStream).close();
        ((OutputStream)swapStream).close();
        this.checkScript(truncFileName, truncFileName);
        this.checkScript(swapFileName, swapFileName);
    }

    private Collection helpCreateMatViewTemplateDataCollection() {
        ArrayList<TemplateData> data = new ArrayList<TemplateData>();
        data.add(this.helpCreateMatViewTemplateData("View_1"));
        data.add(this.helpCreateMatViewTemplateData("View_2"));
        data.add(this.helpCreateMatViewTemplateData("View_3"));
        return data;
    }

    private TemplateData helpCreateMatViewTemplateData(String vdbName) {
        return new MaterializedViewData(vdbName, new String[]{"col_1", "col_2", "col_3", "col_4", "col_5"}, "A_virtual_table", "A_physical_table_in_src", "A_physical_table", "A_physical_staging_table_in_src", "A_physical_staging_table");
    }

    private TemplateData helpCreateOraConnPropsTemplateData(String vdbName) {
        return new MaterializedViewConnectionData(vdbName, "vers_1", "host1", "123432", "com.metamatrix.jdbc.MMDriver", "aMMPwd", "aMMUser", "mm", "jdbc:mmx:oracle://host:1521;SID=sid", "com.metamatrix.jdbc.oracle.OracleDriver", "matPwd", "matUser", "truncScript.DDL", "loadScript.DDL", "swapScript.DDL", "scrips.log");
    }

    private TemplateData helpCreateSQLServerConnPropsTemplateData(String vdbName) {
        return new MaterializedViewConnectionData(vdbName, "vers_1", "host1", "123432", "com.metamatrix.jdbc.MMDriver", "aMMPwd", "aMMUser", "mm", "jdbc:mmx:sqlserver://host:1521;Database=somebogus\\database", "com.metamatrix.jdbc.sqlserver.SQLServerDriver", "matPwd", "matUser", "truncScript.DDL", "loadScript.DDL", "swapScript.DDL", "scrips.log");
    }

    private TemplateData helpCreateSQLServerConnPropsTemplateDataUsingSSL(String vdbName) {
        return new MaterializedViewConnectionData(vdbName, "vers_1", "host1", "123432", "com.metamatrix.jdbc.MMDriver", "aMMPwd", "aMMUser", "mms", "jdbc:mmx:sqlserver://host:1521;Database=somebogus\\database", "com.metamatrix.jdbc.sqlserver.SQLServerDriver", "matPwd", "matUser", "truncScript.DDL", "loadScript.DDL", "swapScript.DDL", "scrips.log");
    }

    private void checkScript(String actualFileName, String expectedFileName) throws FileNotFoundException {
        File actualFile = UnitTestUtil.getTestScratchFile((String)actualFileName);
        String actual = FileUtil.read((Reader)new FileReader(actualFile)).trim();
        String expected = FileUtil.read((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)("/materializedView/expected/" + expectedFileName)))).trim();
        TestMaterializedViewScriptGenerator.assertEquals((String)StringUtilities.removeChars((String)expected, (char[])new char[]{'\r'}), (String)actual);
        actualFile.delete();
    }

    private void checkProperties(String actualPropertyFileName, String expectedPropertyFileName) throws IOException {
        Properties actualProps = new Properties();
        File actualFile = UnitTestUtil.getTestScratchFile((String)actualPropertyFileName);
        actualProps.load(new FileInputStream(actualFile));
        Properties expectedProps = new Properties();
        expectedProps.load(new FileInputStream(UnitTestUtil.getTestDataPath() + "/materializedView/expected/" + expectedPropertyFileName));
        Set<Object> actualReadPropKeys = actualProps.keySet();
        Set<Object> expectedReadPropKeys = expectedProps.keySet();
        TestMaterializedViewScriptGenerator.assertEquals((String)"Number of properties differ in prop files: ", (int)expectedReadPropKeys.size(), (int)actualReadPropKeys.size());
        TestMaterializedViewScriptGenerator.assertTrue((String)"Expected props is missing some actual prop keys: ", (boolean)expectedReadPropKeys.containsAll(actualReadPropKeys));
        TestMaterializedViewScriptGenerator.assertTrue((String)"Actual props is missing some expecte prop keys: ", (boolean)actualReadPropKeys.containsAll(expectedReadPropKeys));
        for (String string : expectedReadPropKeys) {
            String expectedPropValue = expectedProps.getProperty(string);
            String actualPropValue = actualProps.getProperty(string);
            TestMaterializedViewScriptGenerator.assertEquals((String)("Wrong value for key " + string), (String)expectedPropValue, (String)actualPropValue);
        }
        actualFile.delete();
    }

    protected String createValidFileName(String fileName) {
        StringBuffer sb = new StringBuffer(100);
        StringCharacterIterator charIter = new StringCharacterIterator(fileName);
        char c = charIter.first();
        while (c != '\uffff') {
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            } else {
                sb.append('_');
            }
            c = charIter.next();
        }
        return sb.toString();
    }
}

