/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.input.attribute;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jdmf.data.input.attribute.AttributeType;
import net.sf.jdmf.data.input.attribute.AttributeTypeFactory;

public class Attribute {
    private static AttributeTypeFactory attributeTypeFactory = new AttributeTypeFactory();
    private String name;
    private AttributeType type;
    private List<Comparable> values = new ArrayList<Comparable>();

    public Attribute() {
        this.type = AttributeType.EMPTY;
    }

    public Attribute(String name) {
        this();
        this.name = name;
    }

    public Attribute(String name, List<Comparable> values) {
        this(name);
        this.values = values;
        if (!values.isEmpty()) {
            this.type = attributeTypeFactory.getAttributeType(values.get(0).getClass());
        }
    }

    public void addValue(Comparable value) {
        this.values.add(value);
    }

    public Comparable[] getValuesAsArray() {
        Comparable[] allValues = new Comparable[this.values.size()];
        return this.values.toArray(allValues);
    }

    public List<Comparable> getDistinctValues() {
        ArrayList<Comparable> distinctValues = new ArrayList<Comparable>();
        for (Comparable value : this.values) {
            if (distinctValues.contains(value)) continue;
            distinctValues.add(value);
        }
        return distinctValues;
    }

    public Map<Comparable, Integer> getValuesCount() {
        LinkedHashMap<Comparable, Integer> valuesCount = new LinkedHashMap<Comparable, Integer>();
        for (Comparable value : this.values) {
            if (!valuesCount.containsKey(value)) {
                valuesCount.put(value, 1);
                continue;
            }
            Integer currentCount = (Integer)valuesCount.get(value);
            valuesCount.put(value, currentCount + 1);
        }
        return valuesCount;
    }

    public Integer getAsInteger(int valueIndex) {
        return (Integer)this.values.get(valueIndex);
    }

    public Double getAsDouble(int valueIndex) {
        return (Double)this.values.get(valueIndex);
    }

    public String getAsString(int valueIndex) {
        return (String)((Object)this.values.get(valueIndex));
    }

    public Boolean getAsBoolean(int valueIndex) {
        return (Boolean)this.values.get(valueIndex);
    }

    public Date getAsDate(int valueIndex) {
        return (Date)this.values.get(valueIndex);
    }

    public AttributeType getType() {
        return this.type;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public List<Comparable> getValues() {
        return this.values;
    }

    public void setValues(List<Comparable> values) {
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

