/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.operators;

public enum EqualityOperator {
    EQUAL{

        @Override
        public boolean evaluate(Comparable leftArgument, Comparable rightArgument) {
            return leftArgument.equals(rightArgument);
        }

        public String toString() {
            return "=";
        }
    }
    ,
    NOT_EQUAL{

        @Override
        public boolean evaluate(Comparable leftArgument, Comparable rightArgument) {
            return !leftArgument.equals(rightArgument);
        }

        public String toString() {
            return "!=";
        }
    }
    ,
    GREATER_THAN{

        @Override
        public boolean evaluate(Comparable leftArgument, Comparable rightArgument) {
            return leftArgument.compareTo(rightArgument) > 0;
        }

        public String toString() {
            return ">";
        }
    }
    ,
    GREATER_THAN_OR_EQUAL{

        @Override
        public boolean evaluate(Comparable leftArgument, Comparable rightArgument) {
            return leftArgument.compareTo(rightArgument) >= 0;
        }

        public String toString() {
            return ">=";
        }
    }
    ,
    LOWER_THAN{

        @Override
        public boolean evaluate(Comparable leftArgument, Comparable rightArgument) {
            return leftArgument.compareTo(rightArgument) < 0;
        }

        public String toString() {
            return "<";
        }
    }
    ,
    LOWER_THAN_OR_EQUAL{

        @Override
        public boolean evaluate(Comparable leftArgument, Comparable rightArgument) {
            return leftArgument.compareTo(rightArgument) <= 0;
        }

        public String toString() {
            return "<=";
        }
    };


    public abstract boolean evaluate(Comparable var1, Comparable var2);
}

