/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.util.HashMap;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;

public class RTMDiffUtil {
    private ReportTableModel leftRTM = null;
    private ReportTableModel rightRTM = null;
    private boolean allColMatch = false;
    private Vector<Integer> leftIndex = null;
    private Vector<Integer> rightIndex = null;
    private ReportTableModel matchRTM = null;
    private ReportTableModel leftNoMatchRTM = null;
    private ReportTableModel rightNoMatchRTM = null;
    private HashMap<Integer, Integer> matchedIndex;

    public RTMDiffUtil() {
    }

    public RTMDiffUtil(ReportTableModel left, ReportTableModel right) {
        this.leftRTM = left;
        this.rightRTM = right;
        this.allColMatch = true;
    }

    public RTMDiffUtil(ReportTableModel left, Vector<Integer> leftI, ReportTableModel right, Vector<Integer> rightI) {
        this.leftRTM = left;
        this.rightRTM = right;
        this.allColMatch = false;
        this.leftIndex = leftI;
        this.rightIndex = rightI;
    }

    private void createTableHeader() {
        int i;
        int rightColC;
        if (this.leftRTM == null || this.rightRTM == null) {
            return;
        }
        int leftColC = this.leftRTM.getModel().getColumnCount();
        int rightC = leftColC >= (rightColC = this.rightRTM.getModel().getColumnCount()) ? rightColC : leftColC;
        String[] matchedH = new String[rightC + 2];
        matchedH[0] = "Left Index";
        matchedH[1] = "Right Index";
        String[] leftNoMatchH = new String[leftColC + 1];
        leftNoMatchH[0] = "Index";
        String[] rightNoMatchH = new String[rightColC + 1];
        rightNoMatchH[0] = "index";
        for (i = 0; i < leftColC; ++i) {
            leftNoMatchH[i + 1] = this.leftRTM.getModel().getColumnName(i);
        }
        for (i = 0; i < rightColC; ++i) {
            rightNoMatchH[i + 1] = this.rightRTM.getModel().getColumnName(i);
        }
        for (i = 0; i < rightC; ++i) {
            matchedH[i + 2] = this.leftRTM.getModel().getColumnName(i);
        }
        this.matchRTM = new ReportTableModel(matchedH, true, true);
        this.leftNoMatchRTM = new ReportTableModel(leftNoMatchH, true, true);
        this.rightNoMatchRTM = new ReportTableModel(rightNoMatchH, true, true);
    }

    public boolean compare(boolean asString, boolean showCelldiff) {
        if (this.leftRTM == null || this.rightRTM == null) {
            System.out.println("Can not Compare Null Table(s)");
            return false;
        }
        if (this.leftIndex != null && this.rightIndex == null || this.leftIndex == null && this.rightIndex != null) {
            this.allColMatch = true;
        }
        if (this.leftIndex != null && this.rightIndex != null && this.leftIndex.size() != this.rightIndex.size()) {
            System.out.println("Left and Right Columns are not Mapped");
            return false;
        }
        this.createTableHeader();
        this.matchedIndex = new HashMap();
        int leftRowC = this.leftRTM.getModel().getRowCount();
        int rightRowC = this.rightRTM.getModel().getRowCount();
        block0: for (int i = 0; i < leftRowC; ++i) {
            Object[] leftRow = this.leftRTM.getRow(i);
            if (leftRow == null) continue;
            boolean ismatch = false;
            for (int j = 0; j < rightRowC; ++j) {
                Object[] rightRow = this.rightRTM.getRow(j);
                if (rightRow == null || !(ismatch = this.allColMatch ? RTMDiffUtil.matchAllColumn(leftRow, rightRow, asString) : RTMDiffUtil.matchIndexColumn(leftRow, this.leftIndex, rightRow, this.rightIndex, asString)) || this.matchedIndex.containsKey(j)) continue;
                int leftColC = leftRow.length;
                Object[] newRow = new Object[leftColC + 2];
                newRow[0] = i;
                newRow[1] = j;
                for (int lc = 0; lc < leftColC; ++lc) {
                    newRow[lc + 2] = leftRow[lc];
                }
                this.matchRTM.addFillRow(newRow);
                this.matchedIndex.put(j, i);
                continue block0;
            }
        }
        this.fillNoMatchedRow();
        return true;
    }

    private void fillNoMatchedRow() {
        int lc;
        Object[] newRow;
        int i;
        int leftRowC = this.leftRTM.getModel().getRowCount();
        int rightRowC = this.rightRTM.getModel().getRowCount();
        for (i = 0; i < leftRowC; ++i) {
            if (this.matchedIndex.containsValue(i)) continue;
            int leftColC = this.leftRTM.getModel().getColumnCount();
            Object[] leftRow = this.leftRTM.getRow(i);
            newRow = new Object[leftColC + 1];
            newRow[0] = i;
            for (lc = 0; lc < leftColC; ++lc) {
                newRow[lc + 1] = leftRow[lc];
            }
            this.leftNoMatchRTM.addFillRow(newRow);
        }
        for (i = 0; i < rightRowC; ++i) {
            if (this.matchedIndex.containsKey(i)) continue;
            int rightColC = this.rightRTM.getModel().getColumnCount();
            Object[] rightRow = this.rightRTM.getRow(i);
            newRow = new Object[rightColC + 1];
            newRow[0] = i;
            for (lc = 0; lc < rightColC; ++lc) {
                newRow[lc + 1] = rightRow[lc];
            }
            this.rightNoMatchRTM.addFillRow(newRow);
        }
    }

    public ReportTableModel getMatchedRTM() {
        return this.matchRTM;
    }

    public ReportTableModel leftNoMatchRTM() {
        return this.leftNoMatchRTM;
    }

    public ReportTableModel rightNoMatchRTM() {
        return this.rightNoMatchRTM;
    }

    public static boolean matchAllColumn(Object[] leftRow, Object[] rightRow, boolean asString) {
        int leftColC = leftRow.length;
        int rightColC = rightRow.length;
        int rightC = leftColC >= rightColC ? rightColC : leftColC;
        for (int i = 0; i < rightC; ++i) {
            if (!asString && !leftRow[i].equals(rightRow[i])) {
                return false;
            }
            if (leftRow[i] == null && rightRow[i] == null) continue;
            if (leftRow[i] == null && rightRow[i] != null) {
                return false;
            }
            if (leftRow[i] != null && rightRow[i] == null) {
                return false;
            }
            if (!asString || leftRow[i].toString().equalsIgnoreCase(rightRow[i].toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean matchIndexColumn(Object[] leftRow, Vector<Integer> leftIndex, Object[] rightRow, Vector<Integer> rightIndex, boolean asString) {
        int rightC = leftIndex.size();
        for (int i = 0; i < rightC; ++i) {
            if (!asString && !leftRow[leftIndex.get(i)].equals(rightRow[rightIndex.get(i)])) {
                return false;
            }
            if (leftRow[leftIndex.get(i)] == null && rightRow[rightIndex.get(i)] == null) continue;
            if (leftRow[leftIndex.get(i)] == null && rightRow[rightIndex.get(i)] != null) {
                return false;
            }
            if (leftRow[leftIndex.get(i)] != null && rightRow[rightIndex.get(i)] == null) {
                return false;
            }
            if (!asString || leftRow[leftIndex.get(i)].toString().equalsIgnoreCase(rightRow[rightIndex.get(i)].toString())) continue;
            return false;
        }
        return true;
    }

    public static Vector<Integer> diffAllColumn(Object[] leftRow, Object[] rightRow, boolean asString) {
        int leftColC = leftRow.length;
        int rightColC = rightRow.length;
        Vector<Integer> vc = new Vector<Integer>();
        boolean markedfail = false;
        int rightC = leftColC >= rightColC ? rightColC : leftColC;
        for (int i = 0; i < rightC; ++i) {
            if (!asString && !leftRow[i].equals(rightRow[i])) {
                markedfail = true;
                vc.add(i);
                continue;
            }
            if (leftRow[i] == null && rightRow[i] == null) continue;
            if (leftRow[i] == null && rightRow[i] != null) {
                markedfail = true;
                vc.add(i);
                continue;
            }
            if (leftRow[i] != null && rightRow[i] == null) {
                markedfail = true;
                vc.add(i);
                continue;
            }
            if (!asString || leftRow[i].toString().equalsIgnoreCase(rightRow[i].toString())) continue;
            markedfail = true;
            vc.add(i);
        }
        if (markedfail) {
            return vc;
        }
        return vc;
    }

    public static Vector<Integer> diffIndexColumn(Object[] leftRow, Vector<Integer> leftIndex, Object[] rightRow, Vector<Integer> rightIndex, boolean asString) {
        Vector<Integer> vc = new Vector<Integer>();
        boolean markedfail = false;
        int rightC = leftIndex.size();
        for (int i = 0; i < rightC; ++i) {
            if (!asString && !leftRow[leftIndex.get(i)].equals(rightRow[rightIndex.get(i)])) {
                markedfail = true;
                vc.add(leftIndex.get(i));
                continue;
            }
            if (leftRow[leftIndex.get(i)] == null && rightRow[rightIndex.get(i)] == null) continue;
            if (leftRow[leftIndex.get(i)] == null && rightRow[rightIndex.get(i)] != null) {
                markedfail = true;
                vc.add(leftIndex.get(i));
                continue;
            }
            if (leftRow[leftIndex.get(i)] != null && rightRow[rightIndex.get(i)] == null) {
                markedfail = true;
                vc.add(leftIndex.get(i));
                continue;
            }
            if (!asString || leftRow[leftIndex.get(i)].toString().equalsIgnoreCase(rightRow[rightIndex.get(i)].toString())) continue;
            markedfail = true;
            vc.add(leftIndex.get(i));
        }
        if (markedfail) {
            return vc;
        }
        return vc;
    }

    public HashMap<Integer, Vector<Integer>> compareDiff(boolean asString) {
        HashMap<Integer, Vector<Integer>> diffIndex = new HashMap<Integer, Vector<Integer>>();
        if (this.leftRTM == null || this.rightRTM == null) {
            System.out.println("Can not Compare Null Table(s)");
            return diffIndex;
        }
        if (this.leftIndex != null && this.rightIndex == null || this.leftIndex == null && this.rightIndex != null) {
            this.allColMatch = true;
        }
        if (this.leftIndex != null && this.rightIndex != null && this.leftIndex.size() != this.rightIndex.size()) {
            System.out.println("Left and Right Columns are not Mapped");
            return diffIndex;
        }
        int leftRowC = this.leftRTM.getModel().getRowCount();
        int rightRowC = this.rightRTM.getModel().getRowCount();
        for (int i = 0; i < leftRowC; ++i) {
            Object[] leftRow = this.leftRTM.getRow(i);
            if (leftRow == null) continue;
            Vector prev_vc = new Vector();
            for (int j = 0; j < rightRowC; ++j) {
                Object[] rightRow = this.rightRTM.getRow(j);
                if (rightRow == null) continue;
                Vector<Object> vc = new Vector();
                vc = this.allColMatch ? RTMDiffUtil.diffAllColumn(leftRow, rightRow, asString) : RTMDiffUtil.diffIndexColumn(leftRow, this.leftIndex, rightRow, this.rightIndex, asString);
                if (vc == null || vc.size() <= 0 || prev_vc.size() != 0 && prev_vc.size() <= vc.size()) continue;
                prev_vc = vc;
                diffIndex.put(i, prev_vc);
            }
        }
        return diffIndex;
    }
}

