/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.datagen;

import java.util.ArrayList;
import java.util.Collections;
import org.arrah.framework.ndtable.ReportTableModel;

public class ShuffleRTM {
    public static String shuffleString(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        ArrayList<Character> charList = new ArrayList<Character>();
        for (int i = 0; i < str.length(); ++i) {
            charList.add(Character.valueOf(str.charAt(i)));
        }
        Collections.shuffle(charList);
        String newVal = new String();
        for (int i = 0; i < charList.size(); ++i) {
            newVal = newVal.concat(((Character)charList.get(i)).toString());
        }
        return newVal;
    }

    public static ArrayList<Integer> shuffleIntegerList(ArrayList<Integer> rowNumber) {
        if (rowNumber == null || rowNumber.size() == 0) {
            return rowNumber;
        }
        Collections.shuffle(rowNumber);
        return rowNumber;
    }

    public static ReportTableModel shuffleRecord(ReportTableModel rtm, int colIndex, int beginRow, int endRow) {
        if (rtm == null || rtm.getModel().getRowCount() == 0) {
            return rtm;
        }
        for (int i = beginRow; i < endRow; ++i) {
            String colVal = rtm.getModel().getValueAt(i, colIndex).toString();
            String newColVal = ShuffleRTM.shuffleString(colVal);
            rtm.setValueAt(newColVal, i, colIndex);
        }
        return rtm;
    }

    public static ReportTableModel shuffleColumns(ReportTableModel rtm, int[] colIndex, int beginRow, int endRow) {
        int i;
        if (rtm == null || rtm.getModel().getRowCount() == 0) {
            return rtm;
        }
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        for (i = beginRow; i < endRow; ++i) {
            rowList.add(i);
        }
        rowList = ShuffleRTM.shuffleIntegerList(rowList);
        for (i = beginRow; i < endRow; ++i) {
            for (int j = 0; j < colIndex.length; ++j) {
                Object colVal = rtm.getModel().getValueAt(i, colIndex[j]);
                Object newcolVal = rtm.getModel().getValueAt(rowList.get(i), colIndex[j]);
                rtm.setValueAt(colVal, (int)rowList.get(i), colIndex[j]);
                rtm.setValueAt(newcolVal, i, colIndex[j]);
            }
        }
        return rtm;
    }

    public static ReportTableModel maskColumn(ReportTableModel rtm, int colIndex, int beginRow, int endRow, String maskChar, int maskPosition) {
        if (rtm == null || rtm.getModel().getRowCount() == 0) {
            return rtm;
        }
        for (int i = beginRow; i < endRow; ++i) {
            String colVal = rtm.getModel().getValueAt(i, colIndex).toString();
            String newcolVal = null;
            if (maskChar.length() > colVal.length()) {
                newcolVal = maskChar;
            } else {
                switch (maskPosition) {
                    case 0: {
                        newcolVal = maskChar + colVal.substring(maskChar.length());
                        break;
                    }
                    case -1: {
                        newcolVal = colVal.substring(0, colVal.length() - maskChar.length()) + maskChar;
                        break;
                    }
                    default: {
                        newcolVal = colVal.substring(0, maskPosition) + maskChar;
                    }
                }
            }
            rtm.setValueAt(newcolVal, i, colIndex);
        }
        return rtm;
    }
}

