/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import org.simmetrics.StringMetric;

public class Jaro
implements StringMetric {
    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        int halfLength = Math.max(0, (int)Math.floor(-1.0 + 0.5 * (double)Math.max(a.length(), b.length())));
        String commonA = Jaro.getCommonCharacters(a, b, halfLength);
        String commonB = Jaro.getCommonCharacters(b, a, halfLength);
        if (commonA.isEmpty() || commonB.isEmpty()) {
            return 0.0f;
        }
        float transpositions = 0.0f;
        for (int i = 0; i < commonA.length(); ++i) {
            if (commonA.charAt(i) == commonB.charAt(i)) continue;
            transpositions += 1.0f;
        }
        float aCommonRatio = (float)commonA.length() / (float)a.length();
        float bCommonRatio = (float)commonB.length() / (float)b.length();
        float transpositionRatio = ((float)commonA.length() - (transpositions /= 2.0f)) / (float)commonA.length();
        return (aCommonRatio + bCommonRatio + transpositionRatio) / 3.0f;
    }

    private static String getCommonCharacters(String a, String b, int separation) {
        StringBuilder common = new StringBuilder(a.length() + b.length());
        StringBuilder copyOfB = new StringBuilder(b);
        for (int i = 0; i < a.length(); ++i) {
            char character = a.charAt(i);
            int index = Jaro.indexOf(character, copyOfB, i - separation, i + separation + 1);
            if (index <= -1) continue;
            common.append(character);
            copyOfB.setCharAt(index, '\u0000');
        }
        return common.toString();
    }

    private static int indexOf(char character, StringBuilder buffer, int fromIndex, int toIndex) {
        for (int j = Math.max(0, fromIndex); j < Math.min(toIndex, buffer.length()); ++j) {
            if (buffer.charAt(j) != character) continue;
            return j;
        }
        return -1;
    }

    public String toString() {
        return "Jaro";
    }
}

