/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;

public class TabularReport {
    public static ReportTableModel showReport(ReportTableModel _rt, Vector<Integer> _reportColV, Vector<Integer> _reportFieldV) {
        int newColC = _reportColV.size();
        String[] newColN = new String[newColC];
        int[] newColT = new int[newColC];
        for (int i = 0; i < newColC; ++i) {
            newColN[i] = _rt.getModel().getColumnName(_reportColV.get(i));
            newColT[i] = _reportFieldV.get(i);
        }
        Vector<Integer> dimV = new Vector<Integer>();
        Vector<Integer> measureV = new Vector<Integer>();
        for (int i = 0; i < newColC; ++i) {
            int fieldVal = _reportFieldV.get(i);
            if (fieldVal == 0) {
                dimV.add(_reportColV.get(i));
                continue;
            }
            measureV.add(_reportColV.get(i));
        }
        ReportTableModel newRT = new ReportTableModel(newColN, false, true);
        int dimSize = dimV.size();
        Object[] dimObj = new Object[dimSize];
        int measureSize = measureV.size();
        Object[] measureObj = new Object[measureSize];
        Hashtable<String, Integer> rptContent = new Hashtable<String, Integer>();
        int newRowIndex = 0;
        Hashtable<String, Integer> dimCount = new Hashtable<String, Integer>();
        Integer existingCount = null;
        int _rowC = _rt.getModel().getRowCount();
        for (int i = 0; i < _rowC; ++i) {
            int j;
            boolean newrecord = true;
            Object[] row = new Object[newColC];
            String dimensionId = "";
            for (int j2 = 0; j2 < dimSize; ++j2) {
                dimObj[j2] = _rt.getModel().getValueAt(i, (Integer)dimV.get(j2));
                dimensionId = dimObj[j2] == null ? dimensionId + "Undefined" : dimensionId + dimObj[j2].toString();
            }
            Integer existingrowid = (Integer)rptContent.get(dimensionId);
            existingCount = (Integer)dimCount.get(dimensionId);
            if (existingrowid == null) {
                rptContent.put(dimensionId, newRowIndex++);
                existingCount = 1;
                dimCount.put(dimensionId, existingCount);
            } else {
                newrecord = false;
                existingCount = existingCount + 1;
                dimCount.put(dimensionId, existingCount);
            }
            for (j = 0; j < measureSize; ++j) {
                measureObj[j] = _rt.getModel().getValueAt(i, (Integer)measureV.get(j));
            }
            for (j = 0; j < newColC; ++j) {
                int fieldVal = newColT[j];
                if (fieldVal == 2) {
                    try {
                        row[j] = Math.abs((Double)_rt.getModel().getValueAt(i, _reportColV.get(j)));
                    }
                    catch (Exception e) {
                        System.out.println("\n Can not cast table value as Number");
                    }
                    continue;
                }
                row[j] = fieldVal == 3 ? Double.valueOf(existingCount.doubleValue()) : _rt.getModel().getValueAt(i, _reportColV.get(j));
            }
            if (newrecord) {
                newRT.addFillRow(row);
                continue;
            }
            Object[] existMeasureObj = new Object[measureSize];
            int k = 0;
            for (int j3 = 0; j3 < newColC; ++j3) {
                int fieldVal = newColT[j3];
                if (fieldVal != 1 && fieldVal != 2 && fieldVal != 3 && fieldVal != 4) continue;
                existMeasureObj[k] = newRT.getModel().getValueAt(existingrowid, j3);
                Double newVal = 0.0;
                if (newRT.getModel().getColumnClass(j3).getName().toString().toUpperCase().contains("DOUBLE")) {
                    if (fieldVal == 1) {
                        newVal = (Double)existMeasureObj[k] + (Double)measureObj[k];
                    } else if (fieldVal == 2) {
                        newVal = Math.abs((Double)existMeasureObj[k]) + Math.abs((Double)measureObj[k]);
                    } else if (fieldVal == 3) {
                        newVal = existingCount.doubleValue();
                    } else if (fieldVal == 4) {
                        newVal = ((Double)existMeasureObj[k] * (double)(existingCount - 1) + (Double)measureObj[k]) / (double)existingCount.intValue();
                    }
                    newRT.getModel().setValueAt(newVal, existingrowid, j3);
                    ++k;
                    continue;
                }
                System.out.println("\n Value is not Number");
            }
        }
        return newRT;
    }

    public static ReportTableModel tabToCrossTab(ReportTableModel _rtm, Vector<Integer> _reportColV, Vector<Integer> _reportFieldV) {
        int i;
        ArrayList<Integer> rowdimI = new ArrayList<Integer>();
        ArrayList<Integer> coldimI = new ArrayList<Integer>();
        class KeyVal {
            int _key;
            int _val;

            public KeyVal(int key, int val) {
                this._key = key;
                this._val = val;
            }
        }
        ArrayList<KeyVal> merticI = new ArrayList<KeyVal>();
        for (int i2 = 0; i2 < _reportFieldV.size(); ++i2) {
            if (_reportFieldV.get(i2) == 0) {
                rowdimI.add(i2);
                continue;
            }
            if (_reportFieldV.get(i2) == 1) {
                coldimI.add(i2);
                continue;
            }
            merticI.add(new KeyVal(i2, _reportFieldV.get(i2)));
        }
        List[] coldimN = new List[coldimI.size()];
        for (int i3 = 0; i3 < coldimI.size(); ++i3) {
            coldimN[i3] = new ArrayList();
        }
        ArrayList<Object[]> lineRowItem = new ArrayList<Object[]>();
        for (i = 0; i < _rtm.getModel().getRowCount(); ++i) {
            for (int j = 0; j < coldimI.size(); ++j) {
                Object obj = _rtm.getModel().getValueAt(i, (Integer)coldimI.get(j));
                if (obj == null) {
                    obj = "";
                }
                if (coldimN[j].contains(obj.toString())) continue;
                coldimN[j].add(obj.toString());
            }
        }
        for (i = 0; i < coldimN.length; ++i) {
            Arrays.sort(coldimN[i].toArray());
        }
        ArrayList<Object[][][]> listlineMetricItem = new ArrayList<Object[][][]>();
        Object[][][] lineMetricItem = new Object[merticI.size()][coldimI.size()][];
        for (int meti = 0; meti < merticI.size(); ++meti) {
            for (int j = 0; j < coldimI.size(); ++j) {
                lineMetricItem[meti][j] = new Object[coldimN[j].size()];
            }
        }
        int rowCount = _rtm.getModel().getRowCount();
        Object[] prevRow = new Object[rowdimI.size()];
        for (int j = 0; j < rowdimI.size(); ++j) {
            prevRow[j] = _rtm.getModel().getValueAt(0, (Integer)rowdimI.get(j));
        }
        boolean isNewRow = false;
        for (int i4 = 0; i4 < rowCount; ++i4) {
            int j;
            Object[] newRow = new Object[rowdimI.size()];
            isNewRow = false;
            for (j = 0; j < rowdimI.size(); ++j) {
                newRow[j] = _rtm.getModel().getValueAt(i4, (Integer)rowdimI.get(j));
                if (newRow[j].toString().compareToIgnoreCase(prevRow[j].toString()) == 0) continue;
                isNewRow = true;
            }
            if (isNewRow) {
                lineRowItem.add(prevRow);
                prevRow = new Object[rowdimI.size()];
                for (j = 0; j < rowdimI.size(); ++j) {
                    prevRow[j] = newRow[j];
                }
                listlineMetricItem.add(lineMetricItem);
                lineMetricItem = new Object[merticI.size()][coldimI.size()][];
                for (int meti = 0; meti < merticI.size(); ++meti) {
                    for (int j2 = 0; j2 < coldimI.size(); ++j2) {
                        lineMetricItem[meti][j2] = new Object[coldimN[j2].size()];
                    }
                }
            }
            for (j = 0; j < coldimI.size(); ++j) {
                Object colobj = _rtm.getModel().getValueAt(i4, (Integer)coldimI.get(j));
                int index = coldimN[j].indexOf(colobj.toString());
                for (int metV = 0; metV < merticI.size(); ++metV) {
                    Object metobj = _rtm.getModel().getValueAt(i4, ((KeyVal)merticI.get((int)metV))._key);
                    int aggrT = ((KeyVal)merticI.get((int)metV))._val;
                    if (lineMetricItem[metV][j][index] != null) {
                        if (aggrT == 5) {
                            lineMetricItem[metV][j][index] = ((Double)lineMetricItem[metV][j][index] + (Double)metobj) / 2.0;
                            continue;
                        }
                        lineMetricItem[metV][j][index] = (Double)lineMetricItem[metV][j][index] + (Double)metobj;
                        continue;
                    }
                    lineMetricItem[metV][j][index] = (Double)metobj;
                }
            }
            if (i4 != rowCount - 1) continue;
            lineRowItem.add(newRow);
            listlineMetricItem.add(lineMetricItem);
        }
        int size = 0;
        for (int i5 = 0; i5 < coldimN.length; ++i5) {
            size += coldimN[i5].size();
        }
        String[] colName = new String[rowdimI.size() + (size + coldimN.length) * merticI.size()];
        for (int i6 = 0; i6 < rowdimI.size(); ++i6) {
            colName[i6] = _rtm.getModel().getColumnName((Integer)rowdimI.get(i6));
        }
        int inc = 0;
        for (int metricC = 0; metricC < merticI.size(); ++metricC) {
            for (int i7 = 0; i7 < coldimN.length; ++i7) {
                for (int j = 0; j < coldimN[i7].size(); ++j) {
                    colName[rowdimI.size() + inc++] = (String)coldimN[i7].get(j);
                }
                int metVal = ((KeyVal)merticI.get((int)metricC))._val;
                String appned = "";
                switch (metVal) {
                    case 2: {
                        appned = "(Sum)";
                        break;
                    }
                    case 3: {
                        appned = "(Abs. Sum)";
                        break;
                    }
                    case 4: {
                        appned = "(Count)";
                        break;
                    }
                    case 5: {
                        appned = "(Avg)";
                        break;
                    }
                }
                colName[rowdimI.size() + inc++] = _rtm.getModel().getColumnName((Integer)coldimI.get(i7)) + appned;
            }
        }
        ReportTableModel rtm = new ReportTableModel(colName);
        int rowC = lineRowItem.size();
        for (int i8 = 0; i8 < rowC; ++i8) {
            Object[] crossRow = new Object[colName.length];
            int rowdimS = ((Object[])lineRowItem.get(i8)).length;
            for (int j = 0; j < rowdimS; ++j) {
                crossRow[j] = ((Object[])lineRowItem.get(i8))[j];
            }
            Object[][][] metrticV = (Object[][][])listlineMetricItem.get(i8);
            for (int metricC = 0; metricC < merticI.size(); ++metricC) {
                for (int coldimName = 0; coldimName < coldimN.length; ++coldimName) {
                    double aggr = 0.0;
                    for (int index = 0; index < coldimN[coldimName].size(); ++index) {
                        int aggrT;
                        if (null == metrticV[metricC][coldimName][index]) {
                            metrticV[metricC][coldimName][index] = 0.0;
                        }
                        aggr = (aggrT = ((KeyVal)merticI.get((int)metricC))._val) == 5 ? (aggr + (Double)metrticV[metricC][coldimName][index]) / 2.0 : (aggr += ((Double)metrticV[metricC][coldimName][index]).doubleValue());
                        crossRow[rowdimS++] = metrticV[metricC][coldimName][index];
                    }
                    crossRow[rowdimS++] = aggr;
                }
            }
            rtm.addFillRow(crossRow);
        }
        return rtm;
    }

    public static ArrayList<Number[]> createBitMap(ReportTableModel _rt, Vector<Integer> _reportColV, Vector<Integer> _reportFieldV, ArrayList<Object>[] cardinal) {
        int arrSize = _reportFieldV.size();
        cardinal = new ArrayList[arrSize];
        ArrayList<Number[]> bitArray = new ArrayList<Number[]>();
        for (int i = 0; i < arrSize; ++i) {
            cardinal[i] = new ArrayList();
        }
        int rowCount = _rt.getModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Number[] newRow = new Number[arrSize];
            for (int j = 0; j < arrSize; ++j) {
                Object col = _rt.getModel().getValueAt(i, _reportColV.get(j));
                int fieldVal = _reportFieldV.get(i);
                if (fieldVal == 0 || fieldVal == 1) {
                    int index = cardinal[j].indexOf(col);
                    if (index < 0) {
                        cardinal[j].add(col);
                        continue;
                    }
                    newRow[j] = cardinal[j].indexOf(col);
                    continue;
                }
                newRow[j] = Double.parseDouble(col.toString());
            }
            bitArray.add(i, newRow);
        }
        return bitArray;
    }
}

