/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.dataquality;

import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import org.arrah.framework.ndtable.ReportTableModel;

public class ExpressionBuilder {
    private static final String START_TOKEN = "#{";
    private static final String END_TOKEN = "}";

    public static String preparseJeval(String expression, ReportTableModel rpt, int selIndex) {
        String jevalString = null;
        int startI = 0;
        int endI = 0;
        Hashtable<String, Integer> colTable = new Hashtable<String, Integer>();
        boolean isNumber = false;
        Evaluator eva = new Evaluator('\"', true, true, true, true);
        while ((startI = expression.indexOf(START_TOKEN, endI)) != -1 && (endI = expression.indexOf(END_TOKEN, startI)) != -1) {
            String colName = expression.substring(startI + START_TOKEN.length(), endI);
            int i = ExpressionBuilder.getColumnIndex(rpt, colName);
            if (i < 0) {
                System.out.println("\n ERROR:Column Name Not Found in Table:" + colName);
                return null;
            }
            colTable.put(colName, i);
            Object obj = rpt.getModel().getValueAt(0, i);
            if (obj == null) {
                eva.putVariable(colName, "");
                continue;
            }
            eva.putVariable(colName, obj.toString());
        }
        try {
            eva.parse(expression);
            if (selIndex < 0) {
                jevalString = eva.evaluate(false, false);
                return jevalString;
            }
        }
        catch (EvaluationException ee) {
            System.out.println("\n WARNING: Parsing Falied " + ee.getMessage());
            return jevalString;
        }
        if (rpt.getModel().getColumnClass(selIndex).getName().toUpperCase().contains("DOUBLE")) {
            isNumber = true;
        }
        int row_c = rpt.getModel().getRowCount();
        Hashtable<String, String> varT = new Hashtable<String, String>();
        for (int i = 0; i < row_c; ++i) {
            Enumeration table_enum = colTable.keys();
            while (table_enum.hasMoreElements()) {
                String colKey = (String)table_enum.nextElement();
                Object obj = rpt.getModel().getValueAt(i, (Integer)colTable.get(colKey));
                if (obj == null) {
                    if (obj instanceof Number) {
                        varT.put(colKey, "0");
                        continue;
                    }
                    varT.put(colKey, "");
                    continue;
                }
                varT.put(colKey, obj.toString());
            }
            eva.setVariables(varT);
            try {
                jevalString = eva.evaluate(false, false);
            }
            catch (EvaluationException ee) {
                System.out.println("\n Parse WARNING:  Row id: " + (i + 1) + " :" + ee.getMessage());
                rpt.getModel().setValueAt(null, i, selIndex);
                continue;
            }
            if (isNumber) {
                try {
                    rpt.getModel().setValueAt(Double.parseDouble(jevalString), i, selIndex);
                }
                catch (NumberFormatException exp) {
                    System.out.println("\n Format WARNING:  Row id: " + (i + 1) + " :" + exp.getMessage());
                    rpt.getModel().setValueAt(null, i, selIndex);
                }
                continue;
            }
            rpt.getModel().setValueAt(jevalString, i, selIndex);
        }
        return jevalString;
    }

    public static int getColumnIndex(ReportTableModel rpt, String colName) {
        int row_c = rpt.getModel().getColumnCount();
        for (int i = 0; i < row_c; ++i) {
            if (!colName.equals(rpt.getModel().getColumnName(i))) continue;
            return i;
        }
        return -1;
    }
}

