/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.profile;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import org.arrah.framework.dataquality.FillCheck;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.ndtable.ResultsetToRTM;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;

public class TableFirstInformation {
    private Vector<Double> patV;

    public double getTableCount(String tableName) throws SQLException {
        double tabCount = 0.0;
        String countS = "0";
        QueryBuilder querybuilder = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), tableName, Rdbms_conn.getHValue("Database_Type"));
        Rdbms_conn.openConn();
        String s2 = querybuilder.get_tableCount_query();
        ResultSet resultset1 = Rdbms_conn.runQuery(s2);
        while (resultset1.next()) {
            countS = resultset1.getString("row_count");
        }
        tabCount = Double.parseDouble(countS);
        Rdbms_conn.closeConn();
        return tabCount;
    }

    public double getPatternCount(String tableName) throws Exception {
        double patCount = 0.0;
        this.patV = new Vector();
        QueryBuilder querybuilder = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), tableName, Rdbms_conn.getHValue("Database_Type"));
        try {
            Vector<?>[] avector = Rdbms_conn.populateColumn(tableName, null);
            Rdbms_conn.openConn();
            String s2 = querybuilder.get_table_duprow_query(avector[0], "");
            ResultSet resultset1 = Rdbms_conn.runQuery(s2);
            if (resultset1 == null) {
                return patCount;
            }
            while (resultset1.next()) {
                String patC = resultset1.getString(1);
                double patternC = Double.parseDouble(patC);
                this.patV.add(patternC);
                patCount += 1.0;
            }
            Rdbms_conn.closeConn();
        }
        catch (Exception e) {
            throw new Exception("Table Pattern Sql Error :", e);
        }
        return patCount;
    }

    public Vector<Double> getPatternValue() {
        return this.patV;
    }

    public HashMap<String, Double> getTableProfile(String tableName) throws Exception {
        double dupcount = 0.0;
        HashMap<String, Double> hm = new HashMap<String, Double>();
        double tabCount = this.getTableCount(tableName);
        hm.put("Total Count", tabCount);
        if (tabCount == 0.0) {
            return hm;
        }
        double patCount = this.getPatternCount(tableName);
        hm.put("Duplicate Pattern", patCount);
        int i = 0;
        while ((double)i < patCount) {
            dupcount += this.patV.get(i).doubleValue();
            ++i;
        }
        hm.put("Duplicate Count", dupcount);
        hm.put("Duplicate %", dupcount / tabCount * 100.0);
        hm.put("Unique Pattern", tabCount - dupcount);
        hm.put("Unique %", (tabCount - dupcount) / tabCount * 100.0);
        return hm;
    }

    public int[] getTableFill(String tableName) throws SQLException {
        int[] emptyCount = null;
        QueryBuilder querybuilder = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), tableName, Rdbms_conn.getHValue("Database_Type"));
        Rdbms_conn.openConn();
        String s2 = querybuilder.get_tableAll_query();
        ResultSet resultset1 = Rdbms_conn.runQuery(s2);
        ReportTableModel rtm = ResultsetToRTM.getSQLValue(resultset1, true);
        emptyCount = FillCheck.getEmptyCount(rtm);
        Rdbms_conn.closeConn();
        return emptyCount;
    }
}

