/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.simmetrics.ListMetric;
import org.simmetrics.Metric;
import org.simmetrics.SetMetric;
import org.simmetrics.StringMetric;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.tokenizers.Tokenizer;
import org.simmetrics.utils.CachingSimplifier;
import org.simmetrics.utils.CachingTokenizer;
import org.simmetrics.utils.CompositeListMetric;
import org.simmetrics.utils.CompositeSetMetric;
import org.simmetrics.utils.CompositeSimplifier;
import org.simmetrics.utils.CompositeStringMetric;
import org.simmetrics.utils.CompositeTokenizer;
import org.simmetrics.utils.FilteringTokenizer;
import org.simmetrics.utils.PassThroughSimplifier;
import org.simmetrics.utils.SimplifyingSimplifier;
import org.simmetrics.utils.TokenizingTokenizer;

public class StringMetricBuilder {
    public static CompositeStringMetricBuilder with(StringMetric metric) {
        return new CompositeStringMetricBuilder(metric);
    }

    public static CompositeListMetricBuilder with(ListMetric<String> metric) {
        return new CompositeListMetricBuilder((Metric<List<String>>)metric);
    }

    public static CompositeSetMetricBuilder with(SetMetric<String> metric) {
        return new CompositeSetMetricBuilder((Metric<Set<String>>)metric);
    }

    public static final class CompositeSetMetricBuilder
    extends CompositeCollectionMetricBuilder<Set<String>> {
        CompositeSetMetricBuilder(Metric<Set<String>> metric) {
            super(metric);
        }

        @Override
        StringMetric build(Metric<Set<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            return new CompositeSetMetric(metric, simplifier, tokenizer);
        }
    }

    public static final class CompositeListMetricBuilder
    extends CompositeCollectionMetricBuilder<List<String>> {
        CompositeListMetricBuilder(Metric<List<String>> metric) {
            super(metric);
        }

        @Override
        StringMetric build(Metric<List<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            return new CompositeListMetric(metric, simplifier, tokenizer);
        }
    }

    public static abstract class CompositeCollectionMetricBuilder<T extends Collection<String>>
    implements BuildStep,
    CollectionMetricStep,
    CollectionMetricSimplifierStep,
    CollectionMetricTokenizerStep,
    CollectionMetricTokenizerCacheStep {
        private final Metric<T> metric;
        private static final int CACHE_SIZE = 2;
        private final List<Simplifier> simplifiers = new ArrayList<Simplifier>();
        private final List<Tokenizer> tokenizers = new ArrayList<Tokenizer>();
        private SimplifyingSimplifier stringCache;
        private TokenizingTokenizer tokenCache;

        CompositeCollectionMetricBuilder(Metric<T> metric) {
            Preconditions.checkNotNull(metric);
            this.metric = metric;
        }

        @Override
        public StringMetric build() {
            Simplifier simplifier = this.simplifiers.isEmpty() ? new PassThroughSimplifier() : (this.simplifiers.size() == 1 ? this.simplifiers.get(0) : new CompositeSimplifier(this.simplifiers));
            if (this.stringCache != null) {
                this.stringCache.setSimplifier(simplifier);
                simplifier = this.stringCache;
            }
            Tokenizer tokenizer = this.tokenizers.size() == 1 ? this.tokenizers.get(0) : new CompositeTokenizer(this.tokenizers);
            if (this.tokenCache != null) {
                this.tokenCache.setTokenizer(tokenizer);
                tokenizer = this.tokenCache;
            }
            return this.build(this.metric, simplifier, tokenizer);
        }

        abstract StringMetric build(Metric<T> var1, Simplifier var2, Tokenizer var3);

        @Override
        public BuildStep setTokenizerCache(TokenizingTokenizer cache) {
            Preconditions.checkNotNull((Object)cache);
            this.tokenCache = cache;
            return this;
        }

        @Override
        public BuildStep setTokenizerCache(int initialCapacity, int maximumSize) {
            return this.setTokenizerCache(new CachingTokenizer(initialCapacity, maximumSize));
        }

        @Override
        public BuildStep setTokenizerCache() {
            return this.setTokenizerCache(2, 2);
        }

        @Override
        public CollectionMetricTokenizerStep setSimplifierCache(SimplifyingSimplifier cache) {
            Preconditions.checkNotNull((Object)cache);
            this.stringCache = cache;
            return this;
        }

        @Override
        public CollectionMetricTokenizerStep setSimplifierCache(int initialCapacity, int maximumSize) {
            return this.setSimplifierCache(new CachingSimplifier(initialCapacity, maximumSize));
        }

        @Override
        public CollectionMetricTokenizerStep setSimplifierCache() {
            return this.setSimplifierCache(2, 2);
        }

        @Override
        public CollectionMetricSimplifierStep simplify(Simplifier simplifier) {
            Preconditions.checkNotNull((Object)simplifier);
            this.simplifiers.add(simplifier);
            return this;
        }

        @Override
        public CollectionMetricTokenizerCacheStep tokenize(Tokenizer tokenizer) {
            Preconditions.checkNotNull((Object)tokenizer);
            this.tokenizers.add(tokenizer);
            return this;
        }

        @Override
        public CollectionMetricTokenizerCacheStep filter(Predicate<String> predicate) {
            Preconditions.checkNotNull(predicate);
            Tokenizer tokenizer = this.tokenizers.size() == 1 ? this.tokenizers.get(0) : new CompositeTokenizer(new ArrayList<Tokenizer>(this.tokenizers));
            this.tokenizers.clear();
            FilteringTokenizer filter = new FilteringTokenizer(tokenizer, predicate);
            this.tokenizers.add(filter);
            return this;
        }
    }

    public static final class CompositeStringMetricBuilder
    implements StringMetricSimplifierStep,
    StringMetricSimplifierCacheStep,
    BuildStep {
        private final StringMetric metric;
        private static final int CACHE_SIZE = 2;
        private final List<Simplifier> simplifiers = new ArrayList<Simplifier>();
        private SimplifyingSimplifier cache;

        CompositeStringMetricBuilder(StringMetric metric) {
            Preconditions.checkNotNull((Object)metric);
            this.metric = metric;
        }

        @Override
        public StringMetric build() {
            if (this.simplifiers.isEmpty()) {
                return this.metric;
            }
            Simplifier simplifier = this.simplifiers.size() == 1 ? this.simplifiers.get(0) : new CompositeSimplifier(this.simplifiers);
            if (this.cache != null) {
                this.cache.setSimplifier(simplifier);
                return new CompositeStringMetric(this.metric, this.cache);
            }
            return new CompositeStringMetric(this.metric, simplifier);
        }

        @Override
        public BuildStep setSimplifierCache(SimplifyingSimplifier cache) {
            Preconditions.checkNotNull((Object)cache);
            this.cache = cache;
            return this;
        }

        @Override
        public BuildStep setSimplifierCache(int initialCapacity, int maximumSize) {
            return this.setSimplifierCache(new CachingSimplifier(initialCapacity, maximumSize));
        }

        @Override
        public BuildStep setSimplifierCache() {
            return this.setSimplifierCache(2, 2);
        }

        @Override
        public StringMetricSimplifierCacheStep simplify(Simplifier simplifier) {
            Preconditions.checkNotNull((Object)simplifier);
            this.simplifiers.add(simplifier);
            return this;
        }
    }

    public static interface CollectionMetricTokenizerCacheStep {
        public CollectionMetricTokenizerCacheStep tokenize(Tokenizer var1);

        public CollectionMetricTokenizerCacheStep filter(Predicate<String> var1);

        public BuildStep setTokenizerCache(TokenizingTokenizer var1);

        public BuildStep setTokenizerCache(int var1, int var2);

        public BuildStep setTokenizerCache();

        public StringMetric build();
    }

    public static interface CollectionMetricTokenizerStep {
        public CollectionMetricTokenizerCacheStep tokenize(Tokenizer var1);
    }

    public static interface CollectionMetricSimplifierStep {
        public CollectionMetricSimplifierStep simplify(Simplifier var1);

        public CollectionMetricTokenizerStep setSimplifierCache(SimplifyingSimplifier var1);

        public CollectionMetricTokenizerStep setSimplifierCache(int var1, int var2);

        public CollectionMetricTokenizerStep setSimplifierCache();

        public CollectionMetricTokenizerCacheStep tokenize(Tokenizer var1);
    }

    public static interface CollectionMetricStep {
        public CollectionMetricSimplifierStep simplify(Simplifier var1);

        public CollectionMetricTokenizerCacheStep tokenize(Tokenizer var1);
    }

    public static interface StringMetricSimplifierCacheStep {
        public StringMetricSimplifierCacheStep simplify(Simplifier var1);

        public BuildStep setSimplifierCache(SimplifyingSimplifier var1);

        public BuildStep setSimplifierCache(int var1, int var2);

        public BuildStep setSimplifierCache();

        public StringMetric build();
    }

    public static interface StringMetricSimplifierStep {
        public StringMetricSimplifierCacheStep simplify(Simplifier var1);

        public StringMetric build();
    }

    public static interface BuildStep {
        public StringMetric build();
    }
}

