/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sf.jdmf.algorithms.AbstractDataMiningAlgorithm;
import net.sf.jdmf.algorithms.clustering.centroid.InitialCentroidChoiceStrategy;
import net.sf.jdmf.algorithms.clustering.centroid.impl.FirstRandomOthersDistantChoiceStrategy;
import net.sf.jdmf.data.input.InputData;
import net.sf.jdmf.data.input.attribute.Attribute;
import net.sf.jdmf.data.input.clustering.ClusteringInputData;
import net.sf.jdmf.data.output.DataMiningModel;
import net.sf.jdmf.data.output.clustering.Cluster;
import net.sf.jdmf.data.output.clustering.ClusteringDataMiningModel;
import net.sf.jdmf.util.MathCalculator;

public class KMeansAlgorithm
extends AbstractDataMiningAlgorithm {
    private InitialCentroidChoiceStrategy initialCentroidChoiceStrategy = new FirstRandomOthersDistantChoiceStrategy();
    private MathCalculator mathCalculator = new MathCalculator();
    private Double minimumDistanceSumBetweenOldAndNewClusterCentroids = 1.0E-4;

    @Override
    public DataMiningModel analyze(InputData inputData) {
        ClusteringInputData clusteringInputData = (ClusteringInputData)inputData;
        List<Attribute> attributes = clusteringInputData.getAttributes();
        List<Vector<Double>> points = this.attributeConverter.convertToPoints(attributes);
        List<Cluster> clusters = this.findClusters(points, clusteringInputData.getNumberOfClusters());
        ClusteringDataMiningModel dataMiningModel = new ClusteringDataMiningModel();
        dataMiningModel.setClusters(clusters);
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        dataMiningModel.setAttributeNameOrder(attributeNames);
        return dataMiningModel;
    }

    protected List<Cluster> findClusters(List<Vector<Double>> points, Integer numberOfClusters) {
        List<Vector<Double>> clusterCentroids = this.initialCentroidChoiceStrategy.chooseInitialCentroids(points, numberOfClusters);
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (int i = 0; i < clusterCentroids.size(); ++i) {
            Cluster cluster = new Cluster();
            cluster.setName(Integer.toString(i + 1));
            clusters.add(cluster);
        }
        Double distanceSumBetweenOldAndNewClusterCentroids = null;
        do {
            this.setNewClusterCentroids(clusterCentroids, clusters);
            this.putPointsInClusters(points, clusterCentroids, clusters);
            distanceSumBetweenOldAndNewClusterCentroids = 0.0;
        } while ((distanceSumBetweenOldAndNewClusterCentroids = this.calculateDistanceSumBetweenOldAndNewClusterCentroids(points, clusterCentroids, clusters)) >= this.minimumDistanceSumBetweenOldAndNewClusterCentroids);
        return clusters;
    }

    protected Double calculateDistanceSumBetweenOldAndNewClusterCentroids(List<Vector<Double>> points, List<Vector<Double>> clusterCentroids, List<Cluster> clusters) {
        Double distanceSumBetweenOldAndNewClusterCentroids = 0.0;
        clusterCentroids.clear();
        for (Cluster cluster : clusters) {
            Vector<Double> newClusterCentroid = this.findNewClusterCentroid(cluster);
            Double distanceBetweenOldAndNewClusterCentroid = this.mathCalculator.calculateDistance(cluster.getCentroid(), newClusterCentroid);
            distanceSumBetweenOldAndNewClusterCentroids = distanceSumBetweenOldAndNewClusterCentroids + distanceBetweenOldAndNewClusterCentroid;
            clusterCentroids.add(newClusterCentroid);
            cluster.setPointPercentage((double)cluster.getPoints().size() / (double)points.size() * 100.0);
        }
        return distanceSumBetweenOldAndNewClusterCentroids;
    }

    protected Vector<Double> findNewClusterCentroid(Cluster cluster) {
        Vector<Double> newClusterCentroid = null;
        newClusterCentroid = cluster.getPoints().size() > 0 ? this.mathCalculator.calculateCentroid(cluster.getPoints()) : cluster.getCentroid();
        return newClusterCentroid;
    }

    protected void setNewClusterCentroids(List<Vector<Double>> clusterCentroids, List<Cluster> clusters) {
        for (int i = 0; i < clusters.size(); ++i) {
            Cluster cluster = clusters.get(i);
            cluster.setCentroid(clusterCentroids.get(i));
            cluster.getPoints().clear();
        }
    }

    protected void putPointsInClusters(List<Vector<Double>> points, List<Vector<Double>> clusterCentroids, List<Cluster> clusters) {
        for (Vector<Double> point : points) {
            Integer nearestClusterIndex = null;
            Double minimalDistanceFromClusterCentroid = null;
            for (int i = 0; i < clusterCentroids.size(); ++i) {
                Double distanceFromClusterCentroid = this.mathCalculator.calculateDistance(point, clusterCentroids.get(i));
                if (minimalDistanceFromClusterCentroid != null && !(distanceFromClusterCentroid < minimalDistanceFromClusterCentroid)) continue;
                minimalDistanceFromClusterCentroid = distanceFromClusterCentroid;
                nearestClusterIndex = i;
            }
            clusters.get(nearestClusterIndex).addPoint(point);
        }
    }

    @Override
    protected String getName() {
        return "k-Means Algorithm";
    }

    public InitialCentroidChoiceStrategy getInitialCentroidChoiceStrategy() {
        return this.initialCentroidChoiceStrategy;
    }

    public void setInitialCentroidChoiceStrategy(InitialCentroidChoiceStrategy initialCentroidChoiceStrategy) {
        this.initialCentroidChoiceStrategy = initialCentroidChoiceStrategy;
    }

    public Double getMinimumDistanceSumBetweenOldAndNewClusterCentroids() {
        return this.minimumDistanceSumBetweenOldAndNewClusterCentroids;
    }

    public void setMinimumDistanceSumBetweenOldAndNewClusterCentroids(Double minimumDistanceSumBetweenOldAndNewClusterCentroids) {
        this.minimumDistanceSumBetweenOldAndNewClusterCentroids = minimumDistanceSumBetweenOldAndNewClusterCentroids;
    }
}

