/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.datagen;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class TimeUtil {
    private static Calendar cal = Calendar.getInstance();
    private static String OTHER = "UNDEFINED";
    private static Vector<Integer> monthV = new Vector();

    public static String timeKey(Date date, int timeH) {
        if (date == null || !(date instanceof Date)) {
            return null;
        }
        cal.setTime(date);
        cal.setLenient(true);
        int yr = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(7);
        switch (timeH) {
            case 0: {
                return Integer.toString(yr);
            }
            case 1: {
                return Integer.toString(yr) + TimeUtil.getQuarter(month);
            }
            case 2: {
                return TimeUtil.getQuarter(month);
            }
            case 3: {
                return Integer.toString(yr) + TimeUtil.getMonthCode(month);
            }
            case 4: {
                return TimeUtil.getMonthCode(month);
            }
            case 5: {
                return Integer.toString(day);
            }
        }
        return date.toString();
    }

    public static String timeValue(Date date, int timeH, int anchorTime) {
        if (date == null || !(date instanceof Date)) {
            return null;
        }
        cal.setTime(date);
        cal.setLenient(true);
        int yr = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(7);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        switch (timeH) {
            case 0: {
                return Integer.toString(yr);
            }
            case 1: {
                return Integer.toString(yr) + " - " + TimeUtil.getQuarter(month, anchorTime);
            }
            case 2: {
                return TimeUtil.getQuarter(month, anchorTime);
            }
            case 3: {
                return Integer.toString(yr) + " - " + TimeUtil.getMonthName(TimeUtil.getMonthCode(month));
            }
            case 4: {
                return TimeUtil.getMonthName(TimeUtil.getMonthCode(month));
            }
            case 5: {
                return TimeUtil.getDayName(Integer.toString(day));
            }
            case 6: {
                if (min > 0) {
                    ++hour;
                }
                return TimeUtil.ampmDateForm(hour, min, false, anchorTime);
            }
            case 7: {
                if (min > 30) {
                    min = 0;
                    ++hour;
                } else {
                    min = 30;
                }
                return TimeUtil.ampmDateForm(hour, min, true, anchorTime);
            }
            case 8: {
                int i15 = min % 15;
                min = 15 * ++i15;
                if (min >= 60) {
                    min = 0;
                    ++hour;
                }
                return TimeUtil.ampmDateForm(hour, min, true, anchorTime);
            }
            case 9: {
                int i10 = min % 10;
                min = 10 * ++i10;
                if (min >= 60) {
                    min = 0;
                    ++hour;
                }
                return TimeUtil.ampmDateForm(hour, min, true, anchorTime);
            }
            case 10: {
                int i5 = min % 5;
                min = 5 * ++i5;
                if (min >= 60) {
                    min = 0;
                    ++hour;
                }
                return TimeUtil.ampmDateForm(hour, min, true, anchorTime);
            }
            case 11: {
                if (sec > 0) {
                    ++min;
                }
                if (min >= 60) {
                    min = 0;
                    ++hour;
                }
                return TimeUtil.ampmDateForm(hour, min, true, anchorTime);
            }
            case 12: {
                cal.setFirstDayOfWeek(anchorTime);
                int weekY = cal.get(3);
                return Integer.toString(weekY);
            }
            case 13: {
                return TimeUtil.getWeekend(Integer.toString(day));
            }
        }
        return date.toString();
    }

    public static String getMonthCode(int month) {
        switch (month) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "G";
            }
            case 7: {
                return "H";
            }
            case 8: {
                return "I";
            }
            case 9: {
                return "J";
            }
            case 10: {
                return "K";
            }
            case 11: {
                return "L";
            }
        }
        return OTHER;
    }

    public static String getMonthName(String code) {
        if (code.equals("A")) {
            return "Jan";
        }
        if (code.equals("B")) {
            return "Feb";
        }
        if (code.equals("C")) {
            return "Mar";
        }
        if (code.equals("D")) {
            return "Apr";
        }
        if (code.equals("E")) {
            return "May";
        }
        if (code.equals("F")) {
            return "Jun";
        }
        if (code.equals("G")) {
            return "Jul";
        }
        if (code.equals("H")) {
            return "Aug";
        }
        if (code.equals("I")) {
            return "Sep";
        }
        if (code.equals("J")) {
            return "Oct";
        }
        if (code.equals("K")) {
            return "Nov";
        }
        if (code.equals("L")) {
            return "Dec";
        }
        return OTHER;
    }

    public static String getDayName(String code) {
        int day = Integer.parseInt(code);
        switch (day) {
            case 1: {
                return "Sun";
            }
            case 2: {
                return "Mon";
            }
            case 3: {
                return "Tue";
            }
            case 4: {
                return "Wed";
            }
            case 5: {
                return "Thu";
            }
            case 6: {
                return "Fri";
            }
            case 7: {
                return "Sat";
            }
        }
        return OTHER;
    }

    public static String getWeekend(String code) {
        int day = Integer.parseInt(code);
        switch (day) {
            case 1: 
            case 7: {
                return "Weekend";
            }
        }
        return "Weekday";
    }

    public static String getQuarter(int month) {
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return "Q1";
            }
            case 3: 
            case 4: 
            case 5: {
                return "Q2";
            }
            case 6: 
            case 7: 
            case 8: {
                return "Q3";
            }
            case 9: 
            case 10: 
            case 11: {
                return "Q4";
            }
        }
        return OTHER;
    }

    public static String getQuarter(int month, int startmonth) {
        TimeUtil.fillMonthVec();
        int smonthI = monthV.indexOf(startmonth);
        if (smonthI < 0 || smonthI > 11) {
            return OTHER;
        }
        int monthI = monthV.indexOf(month);
        if (monthI < 0 || monthI > 11) {
            return OTHER;
        }
        int diff = TimeUtil.circularDiff(monthI, smonthI, 12);
        switch (diff) {
            case 0: 
            case 1: 
            case 2: {
                return "Q1";
            }
            case 3: 
            case 4: 
            case 5: {
                return "Q2";
            }
            case 6: 
            case 7: 
            case 8: {
                return "Q3";
            }
            case 9: 
            case 10: 
            case 11: {
                return "Q4";
            }
        }
        return OTHER;
    }

    private static void fillMonthVec() {
        if (monthV.size() < 12) {
            monthV.add(0, 0);
            monthV.add(1, 1);
            monthV.add(2, 2);
            monthV.add(3, 3);
            monthV.add(4, 4);
            monthV.add(5, 5);
            monthV.add(6, 6);
            monthV.add(7, 7);
            monthV.add(8, 8);
            monthV.add(9, 9);
            monthV.add(10, 10);
            monthV.add(11, 11);
        }
    }

    public static int circularDiff(int index, int anchor, int diagonalLen) {
        int diff = index - anchor;
        if (diff >= 0 && diff <= diagonalLen) {
            return diff;
        }
        return diagonalLen + diff;
    }

    public static String ampmDateForm(int hour, int min, boolean useMin, int ampmformat) {
        if (hour > 24) {
            hour = 0;
        }
        if (!useMin) {
            if (ampmformat < 1) {
                if (hour < 12) {
                    return Integer.toString(hour) + " AM";
                }
                if (hour == 12 && hour < 24) {
                    return Integer.toString(hour) + " PM";
                }
                if (hour < 24) {
                    return Integer.toString(hour - 12) + " PM";
                }
                if (hour == 24) {
                    return Integer.toString(hour - 12) + " AM";
                }
                return Integer.toString(hour);
            }
            return Integer.toString(hour);
        }
        if (ampmformat < 1) {
            if (hour < 12) {
                return Integer.toString(hour) + ":" + Integer.toString(min) + " AM";
            }
            if (hour == 12 && hour < 24) {
                return Integer.toString(hour) + ":" + Integer.toString(min) + " PM";
            }
            if (hour < 24) {
                return Integer.toString(hour - 12) + ":" + Integer.toString(min) + " PM";
            }
            if (hour == 24) {
                return Integer.toString(hour - 12) + ":" + Integer.toString(min) + " AM";
            }
            return Integer.toString(hour) + ":" + Integer.toString(min);
        }
        return Integer.toString(hour) + ":" + Integer.toString(min);
    }

    public static int monthCalValue(String monthName) {
        if (monthName.compareToIgnoreCase("Jan") == 0 || monthName.compareToIgnoreCase("January") == 0) {
            return 0;
        }
        if (monthName.compareToIgnoreCase("Feb") == 0 || monthName.compareToIgnoreCase("February") == 0) {
            return 1;
        }
        if (monthName.compareToIgnoreCase("Mar") == 0 || monthName.compareToIgnoreCase("March") == 0) {
            return 2;
        }
        if (monthName.compareToIgnoreCase("Apr") == 0 || monthName.compareToIgnoreCase("April") == 0) {
            return 3;
        }
        if (monthName.compareToIgnoreCase("May") == 0 || monthName.compareToIgnoreCase("May") == 0) {
            return 4;
        }
        if (monthName.compareToIgnoreCase("Jun") == 0 || monthName.compareToIgnoreCase("June") == 0) {
            return 5;
        }
        if (monthName.compareToIgnoreCase("Jul") == 0 || monthName.compareToIgnoreCase("July") == 0) {
            return 6;
        }
        if (monthName.compareToIgnoreCase("Aug") == 0 || monthName.compareToIgnoreCase("August") == 0) {
            return 7;
        }
        if (monthName.compareToIgnoreCase("Sep") == 0 || monthName.compareToIgnoreCase("September") == 0) {
            return 8;
        }
        if (monthName.compareToIgnoreCase("Oct") == 0 || monthName.compareToIgnoreCase("October") == 0) {
            return 9;
        }
        if (monthName.compareToIgnoreCase("Nov") == 0 || monthName.compareToIgnoreCase("November") == 0) {
            return 10;
        }
        if (monthName.compareToIgnoreCase("Dec") == 0 || monthName.compareToIgnoreCase("December") == 0) {
            return 11;
        }
        return 12;
    }

    public static int weekCalValue(String weekName) {
        if (weekName.compareToIgnoreCase("Sun") == 0 || weekName.compareToIgnoreCase("Sunday") == 0) {
            return 1;
        }
        if (weekName.compareToIgnoreCase("Mon") == 0 || weekName.compareToIgnoreCase("Monday") == 0) {
            return 2;
        }
        if (weekName.compareToIgnoreCase("Tue") == 0 || weekName.compareToIgnoreCase("Tuesday") == 0) {
            return 3;
        }
        if (weekName.compareToIgnoreCase("Wed") == 0 || weekName.compareToIgnoreCase("Wednesday") == 0) {
            return 4;
        }
        if (weekName.compareToIgnoreCase("Thu") == 0 || weekName.compareToIgnoreCase("Thursday") == 0) {
            return 5;
        }
        if (weekName.compareToIgnoreCase("Fri") == 0 || weekName.compareToIgnoreCase("Friday") == 0) {
            return 6;
        }
        if (weekName.compareToIgnoreCase("Sat") == 0 || weekName.compareToIgnoreCase("Saturday") == 0) {
            return 7;
        }
        return -1;
    }

    public static TimeSeries getForecastData(TimeSeries observationData, int forcastperc) {
        TimeSeries fcdataset = new TimeSeries((Comparable)((Object)"Time Series Forecast"));
        if (observationData.isEmpty()) {
            return fcdataset;
        }
        int size = observationData.getItemCount();
        long fcsize = (long)size + Math.round((double)size * ((double)forcastperc / 100.0));
        try {
            fcdataset = observationData.createCopy(0, size - 1);
            int i = size;
            while ((long)i < fcsize) {
                RegularTimePeriod nexttp = fcdataset.getNextTimePeriod();
                fcdataset.add(nexttp, 0.0);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception:" + e.getLocalizedMessage());
            System.out.println("Could not create forecasted data sample");
            return fcdataset;
        }
        return fcdataset;
    }

    public static long dateIntoSecond(Date date) {
        if (date == null) {
            return 0L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setLenient(true);
        cal.setTime(date);
        return cal.getTimeInMillis();
    }

    public static long diffIntoSecond(Date date, Date date1) {
        if (date == null || date1 == null) {
            return 0L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setLenient(true);
        cal.setTime(date);
        long datet = cal.getTimeInMillis();
        cal.setTime(date1);
        long date1t = cal.getTimeInMillis();
        return datet - date1t;
    }

    public static Date secondIntoDate(long millisec) {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(true);
        cal.setTimeInMillis(millisec);
        return cal.getTime();
    }

    public static Date secondIntoDate(long millisec, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.setLenient(true);
        cal.setTimeInMillis(millisec);
        return cal.getTime();
    }
}

