/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.dataquality;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.JDBCRowset;
import org.arrah.framework.rdbms.Rdbms_conn;

public class SimilarityCheckLucene {
    private ReportTableModel _rt;
    private ReportTableModel outputRT;
    private String[] colName;
    private String[] colType;
    private int rowC;
    private IndexWriter writer;
    private IndexSearcher searcher;
    private RAMDirectory idx;
    private Vector<Integer> skipVC = null;
    private Vector<Integer> mrowI = null;
    private IndexReader reader;
    private Hashtable<Integer, Integer> parentMap;
    boolean isRowSet = false;
    private JDBCRowset _rows;

    public SimilarityCheckLucene(ReportTableModel rt) {
        this._rt = rt;
        this.colName = this.getColName();
        this.rowC = this._rt.getModel().getRowCount();
    }

    public SimilarityCheckLucene(JDBCRowset rowSet) {
        this.isRowSet = true;
        this._rows = rowSet;
        this.colName = this._rows.getColName();
        this.colType = this._rows.getColType();
        this.rowC = this._rows.getRowCount();
    }

    private String[] getColName() {
        int colC = this._rt.getModel().getColumnCount();
        this.colName = new String[colC];
        this.colType = new String[colC];
        for (int i = 0; i < colC; ++i) {
            this.colName[i] = this._rt.getModel().getColumnName(i);
            this.colType[i] = this._rt.getModel().getColumnClass(i).getName();
        }
        return this.colName;
    }

    public Document createDocument(int rowId, Object[] row) {
        Document doc = new Document();
        if (row == null) {
            return doc;
        }
        try {
            FieldType crosscol = new FieldType();
            crosscol.setStored(true);
            crosscol.setTokenized(false);
            doc.add((IndexableField)new StringField("at__rowid__", Integer.toString(rowId), Field.Store.YES));
            FieldType forhive = new FieldType();
            forhive.setStored(true);
            forhive.setTokenized(true);
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null || this.colName[i] == null) continue;
                doc.add((IndexableField)new TextField(this.colName[i], row[i].toString(), Field.Store.YES));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n " + e.getMessage());
            System.out.println("\n Error: Document Creation Error");
        }
        return doc;
    }

    public void makeIndex() {
        if (!this.createIndex()) {
            return;
        }
        this.addDocument();
        this.closeIndex();
    }

    public boolean createIndex() {
        this.idx = new RAMDirectory();
        try {
            IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new StandardAnalyzer());
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            this.writer = new IndexWriter((Directory)this.idx, conf);
        }
        catch (Exception e) {
            System.out.println("\n " + e.getMessage());
            System.out.println("\n ERROR: Index Open Exception");
            return false;
        }
        return true;
    }

    public void closeIndex() {
        try {
            this.writer.commit();
            this.writer.close();
        }
        catch (Exception e) {
            System.out.println("\n " + e.getMessage());
            System.out.println("\n ERROR: Index Close Exception");
        }
    }

    public void addDocument() {
        try {
            if (this.rowC <= 100 || this.isRowSet) {
                for (int i = 0; i < this.rowC; ++i) {
                    if (!this.isRowSet) {
                        this.writer.addDocument((Iterable)this.createDocument(i, this._rt.getRow(i)));
                        continue;
                    }
                    this.writer.addDocument((Iterable)this.createDocument(i + 1, this._rows.getRow(i + 1)));
                }
            } else {
                int i;
                int THREADCOUNT = 10;
                Thread[] tid = new Thread[10];
                final int rowthread = this.rowC / 10;
                for (i = 0; i < 10; ++i) {
                    final int tindex = i;
                    tid[tindex] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (tindex < 9) {
                                for (int j = tindex * rowthread; j < tindex * rowthread + rowthread; ++j) {
                                    try {
                                        SimilarityCheckLucene.this.writer.addDocument((Iterable)SimilarityCheckLucene.this.createDocument(j, SimilarityCheckLucene.this._rt.getRow(j)));
                                        continue;
                                    }
                                    catch (Exception e) {
                                        System.out.println(" Lucene Exeception:" + e.getMessage());
                                    }
                                }
                            } else {
                                for (int j = tindex * rowthread; j < SimilarityCheckLucene.this.rowC; ++j) {
                                    try {
                                        SimilarityCheckLucene.this.writer.addDocument((Iterable)SimilarityCheckLucene.this.createDocument(j, SimilarityCheckLucene.this._rt.getRow(j)));
                                        continue;
                                    }
                                    catch (Exception e) {
                                        System.out.println("Lucene Exeception:" + e.getMessage());
                                    }
                                }
                            }
                        }
                    });
                    tid[i].start();
                }
                for (i = 0; i < 10; ++i) {
                    try {
                        tid[i].join();
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(" Thread Exeception:" + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(" Add Document Exeception:" + e.getMessage());
        }
    }

    public void searchTableIndex(String query) {
        if (!this.openIndex()) {
            return;
        }
        String[] newColN = new String[this.colName.length + 1];
        newColN[0] = "Delete Editable";
        for (int i = 0; i < this.colName.length; ++i) {
            newColN[i + 1] = this.colName[i];
        }
        this.outputRT = new ReportTableModel(newColN, false, true);
        this.skipVC = new Vector();
        this.parentMap = new Hashtable();
        String queryString = query;
        if (queryString == null || queryString.equals("")) {
            return;
        }
        Query qry = this.parseQuery(queryString);
        Hits hit = this.searchIndex(qry);
        if (hit == null || hit.length() <= 1) {
            return;
        }
        for (int j = 0; j < hit.length(); ++j) {
            try {
                Document doc = hit.doc(j);
                String rowid = doc.get("at__rowid__");
                this.parentMap.put(this.outputRT.getModel().getRowCount(), Integer.parseInt(rowid));
                Object[] row = null;
                if (!this.isRowSet) {
                    row = this._rt.getRow(Integer.parseInt(rowid));
                } else if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                    row = this._rows.getRow(Integer.parseInt(rowid));
                } else {
                    row = new Object[this.colName.length];
                    for (int k = 0; k < this.colName.length; ++k) {
                        row[k] = doc.get(this.colName[k]);
                    }
                }
                Object[] newRow = new Object[row.length + 1];
                boolean del = false;
                newRow[0] = del;
                for (int k = 0; k < row.length; ++k) {
                    newRow[k + 1] = row[k];
                }
                this.outputRT.addFillRow(newRow);
                this.skipVC.add(Integer.parseInt(rowid));
                continue;
            }
            catch (Exception e) {
                System.out.println("\n " + e.getMessage());
                System.out.println("\n Error: Can not open Document");
            }
        }
        this.outputRT.addNullRow();
        this.closeSeachIndex();
    }

    public boolean openIndex() {
        try {
            this.reader = DirectoryReader.open((Directory)this.idx);
            this.searcher = new IndexSearcher(this.reader);
        }
        catch (Exception e) {
            System.out.println("\n " + e.getMessage());
            System.out.println("\n Error: Can not open Index Searcher");
            return false;
        }
        return true;
    }

    public Query parseQuery(String query) {
        try {
            QueryParser qp = new QueryParser(this.colName[0], (Analyzer)new StandardAnalyzer());
            qp.setAllowLeadingWildcard(true);
            return qp.parse(query);
        }
        catch (Exception e) {
            System.out.println("\n " + e.getMessage());
            System.out.println("\n Error: Can not Parse Query");
            return null;
        }
    }

    public Hits searchIndex(Query query) {
        if (query == null) {
            return null;
        }
        Hits hit = null;
        try {
            TopDocs topDocs = this.searcher.search(query, Integer.MAX_VALUE);
            hit = new Hits(topDocs);
        }
        catch (Exception e) {
            System.out.println("\n " + e.getMessage());
            System.out.println("\n Error: Can not Search  Index");
            return null;
        }
        return hit;
    }

    public void closeSeachIndex() {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            System.out.println("\n " + e.getMessage());
            System.out.println("\n Error: Can not Close Search  Index");
        }
    }

    public void setRowset(JDBCRowset rowset) {
        this._rows = rowset;
    }

    public String prepareLQuery(String rawquery, String colTitle) {
        rawquery = rawquery.replaceAll(",", " ");
        rawquery = rawquery.trim().replaceAll("_", " ");
        rawquery = rawquery.replaceAll("\\s+", " ");
        String[] token = rawquery.split(" ");
        String newTerm = "";
        for (int i = 0; i < token.length; ++i) {
            if (token[i] == null || "".equals(token[i])) continue;
            if (!newTerm.equals("")) {
                newTerm = newTerm + " AND ";
            }
            newTerm = newTerm + colTitle + ":" + QueryParser.escape((String)token[i]) + "~3 ";
        }
        return newTerm;
    }

    public Object[][] searchTableObject(String fuzzyQ) {
        if (!this.openIndex()) {
            return null;
        }
        if (fuzzyQ == null || fuzzyQ.equals("")) {
            return null;
        }
        Query qry = this.parseQuery(fuzzyQ);
        Hits hit = this.searchIndex(qry);
        if (hit == null) {
            return null;
        }
        int hitc = hit.length();
        Object[][] returnObj = new Object[hitc][];
        this.mrowI = new Vector();
        for (int j = 0; j < hitc; ++j) {
            try {
                Document doc = hit.doc(j);
                String rowid = doc.get("at__rowid__");
                Object[] row = null;
                if (!this.isRowSet) {
                    row = this._rt.getRow(Integer.parseInt(rowid));
                } else if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                    row = this._rows.getRow(Integer.parseInt(rowid));
                } else {
                    row = new Object[this.colName.length];
                    for (int k = 0; k < this.colName.length; ++k) {
                        row[k] = doc.get(this.colName[k]);
                    }
                }
                returnObj[j] = row;
                this.mrowI.add(Integer.parseInt(rowid));
                continue;
            }
            catch (Exception e) {
                System.out.println(" Error: Can not open Document:" + e.getLocalizedMessage());
                return null;
            }
        }
        this.closeSeachIndex();
        return returnObj;
    }

    public Vector<Integer> getMatchedRowIndex() {
        return this.mrowI;
    }

    public class Hits {
        int length = 0;
        ScoreDoc[] dochits = null;

        public Hits(TopDocs td) {
            if (td != null) {
                this.length = td.totalHits;
                this.dochits = td.scoreDocs;
            }
        }

        public int length() {
            return this.length;
        }

        public Document doc(int i) throws IOException {
            if (this.dochits == null || this.length < i) {
                return null;
            }
            int docId = this.dochits[i].doc;
            return SimilarityCheckLucene.this.searcher.doc(docId);
        }
    }
}

