/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.xls;

import java.io.File;
import java.io.IOException;
import jxl.Cell;
import jxl.CellType;
import jxl.JXLException;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.arrah.framework.ndtable.ReportTableModel;

public class XlsReader {
    private ReportTableModel _rt;
    private boolean FIRST_ROW_HEADER = true;

    public ReportTableModel read(File file) {
        if (this.loadXlsFile(file)) {
            return this._rt;
        }
        System.out.println("XLS File can not be loaded");
        return null;
    }

    public void write(ReportTableModel rt, File file) {
        this.saveXlsFile(rt, file);
    }

    private boolean loadXlsFile(File file) {
        try {
            int i;
            int index = 0;
            Workbook workbook = Workbook.getWorkbook((File)file);
            Sheet sheet = workbook.getSheet(0);
            int col = sheet.getColumns();
            int row = sheet.getRows();
            String[] colName = new String[col];
            boolean sel = this.FIRST_ROW_HEADER;
            if (sel != this.FIRST_ROW_HEADER) {
                for (i = 0; i < colName.length; ++i) {
                    colName[i] = "Column_" + (i + 1);
                }
            }
            if (sel == this.FIRST_ROW_HEADER) {
                for (i = 0; i < colName.length; ++i) {
                    Cell a1 = sheet.getCell(i, 0);
                    colName[i] = a1 == null || a1.getType() == CellType.EMPTY || a1.getType() == CellType.ERROR ? "Column_" + (i + 1) : a1.getContents();
                }
                index = 1;
            }
            this._rt = new ReportTableModel(colName, true, true);
            this._rt.addRows(0, row - index);
            for (i = index; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    Cell a1 = sheet.getCell(j, i);
                    if (a1 == null || a1.getType() == CellType.EMPTY || a1.getType() == CellType.ERROR) continue;
                    this._rt.setValueAt(a1.getContents(), i - index, j);
                }
            }
            workbook.close();
        }
        catch (JXLException e) {
            System.out.println("\n Exception:" + e.getMessage());
            return false;
        }
        catch (IOException e) {
            System.out.println("\n Exception:" + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean saveXlsFile(ReportTableModel rt, File file) {
        try {
            WritableWorkbook workbook = Workbook.createWorkbook((File)file);
            WritableSheet sheet = workbook.createSheet("Arrah Sheet", 0);
            int row = rt.getModel().getRowCount();
            int col = rt.getModel().getColumnCount();
            for (int j = 0; j < col; ++j) {
                Label label = new Label(j, 0, rt.getModel().getColumnName(j));
                sheet.addCell((WritableCell)label);
            }
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    Object obj = rt.getModel().getValueAt(i, j);
                    if (obj == null) continue;
                    Label label = new Label(j, i + 1, obj.toString());
                    sheet.addCell((WritableCell)label);
                }
            }
            workbook.write();
            workbook.close();
        }
        catch (Exception e) {
            System.out.println("\n Save Exception:" + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isFirstRowHeader() {
        return this.FIRST_ROW_HEADER;
    }

    public void setFirstRowHeader(boolean firstRowheader) {
        this.FIRST_ROW_HEADER = firstRowheader;
    }
}

