/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMValidator {
    private int errorCount = 0;
    private File errorFile = null;

    public static void main(String[] args) {
        DOMValidator domValidator = new DOMValidator();
        File file = new File(args[0]);
        domValidator.validate(file);
    }

    public void validate(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DomValidatorErrorHandler handler = new DomValidatorErrorHandler();
            handler.setErrorFile(this.errorFile);
            builder.setErrorHandler(handler);
            Document document = builder.parse(file);
            this.setErrorCount(handler.getErrorCount());
        }
        catch (ParserConfigurationException e) {
            System.out.println(e.toString());
        }
        catch (SAXException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    void setErrorCount(int count) {
        this.errorCount = count;
    }

    void setErrorFile(File errorFile) {
        this.errorFile = errorFile;
    }

    int getErrorCount() {
        return this.errorCount;
    }

    static class DomValidatorErrorHandler
    implements ErrorHandler {
        private int errorCount = 0;
        private PrintStream printStream = System.out;

        DomValidatorErrorHandler() {
        }

        @Override
        public void error(SAXParseException exc) throws SAXException {
            this.printStream.println("Error: ");
            this.printInfo(exc);
        }

        @Override
        public void fatalError(SAXParseException exc) throws SAXException {
            this.printStream.println("Error: ");
            this.printInfo(exc);
        }

        @Override
        public void warning(SAXParseException exc) throws SAXException {
            this.printStream.println("Warning: ");
            this.printInfo(exc);
        }

        private void printInfo(SAXParseException exc) {
            this.printStream.println("   Public ID: " + exc.getPublicId());
            this.printStream.println("   System ID: " + exc.getSystemId());
            this.printStream.println("   Line number: " + exc.getLineNumber());
            this.printStream.println("   Column number: " + exc.getColumnNumber());
            this.printStream.println("   Message: " + exc.getMessage());
            ++this.errorCount;
        }

        void setErrorFile(File errorFile) {
            if (errorFile != null) {
                try {
                    this.printStream = new PrintStream(new FileOutputStream(errorFile));
                }
                catch (FileNotFoundException exc) {
                    System.out.println(exc);
                }
            }
        }

        int getErrorCount() {
            return this.errorCount;
        }
    }
}

