/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import java.util.HashSet;
import java.util.Set;
import org.simmetrics.SetMetric;

public class CosineSimilarity<T>
implements SetMetric<T> {
    @Override
    public float compare(Set<T> a, Set<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        HashSet<T> all = new HashSet<T>();
        all.addAll(a);
        all.addAll(b);
        int commonTerms = a.size() + b.size() - all.size();
        return (float)((double)commonTerms / (Math.sqrt(a.size()) * Math.sqrt(b.size())));
    }

    public String toString() {
        return "CosineSimilarity";
    }
}

