/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.hadooputil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.arrah.framework.hadooputil.HDFSTransferProgressListener;

public class HDFSTransfer {
    private Configuration conf = null;
    private FileSystem fs = null;
    int progressctr = 0;
    private boolean success = false;
    private HDFSTransferProgressListener hdfsTransferProgressListener;

    public HDFSTransfer(HDFSTransferProgressListener hdfsTransferProgressListener, String fsDefaultName) {
        this.hdfsTransferProgressListener = hdfsTransferProgressListener;
        this.conf = new Configuration();
        this.conf.set("fs.default.name", fsDefaultName);
    }

    public HDFSTransfer(HDFSTransferProgressListener hdfsTransferProgressListener) {
        this.hdfsTransferProgressListener = hdfsTransferProgressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToHDFS(String sourcePath, String destPath) throws IOException {
        this.success = false;
        this.fs = FileSystem.get((Configuration)this.conf);
        File file = new File(sourcePath);
        FileInputStream readFile = new FileInputStream(file);
        if (destPath.endsWith("/")) {
            destPath = destPath + file.getName();
        }
        System.out.println("Going to write file: " + destPath);
        Path outFile = new Path(destPath);
        this.checkOutFile(outFile);
        FSDataOutputStream out = this.fs.create(outFile);
        long filesize = file.length();
        this.progressctr = 0;
        int progressfactor = 0;
        try {
            byte[] buffer;
            if (filesize > 25600L) {
                buffer = new byte[256];
                progressfactor = (int)(filesize / 25600L);
            } else if (filesize > 100L) {
                buffer = new byte[1];
                progressfactor = (int)(filesize / 100L);
            } else {
                buffer = new byte[1];
            }
            int bytesRead = 0;
            int bytectr = 0;
            while ((bytesRead = readFile.read(buffer)) > 0) {
                out.write(buffer, 0, bytesRead);
                ++bytectr;
                if (filesize > 100L) {
                    if (bytectr % progressfactor != 0 || this.progressctr > 100) continue;
                    ++this.progressctr;
                    this.hdfsTransferProgressListener.progressUpdate(this.progressctr);
                    continue;
                }
                if (filesize >= 100L) continue;
                if ((long)this.progressctr != filesize * (long)((int)(100L / filesize))) {
                    this.progressctr += (int)(100L / filesize);
                }
                if ((long)this.progressctr == filesize * (long)((int)(100L / filesize))) {
                    this.progressctr = 100;
                }
                this.hdfsTransferProgressListener.progressUpdate(this.progressctr);
            }
            this.success = true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.out.println("Error while copying file");
        }
        finally {
            try {
                readFile.close();
                out.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                System.out.println("Error while closing files");
            }
        }
        if (this.progressctr >= 100) {
            System.out.println("Copy Complete");
        }
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveFromHDFS(String sourcePath, String destPath) throws IOException {
        this.success = false;
        this.fs = FileSystem.get((Configuration)this.conf);
        Path inFile = new Path(sourcePath);
        FSDataInputStream readFile = this.fs.open(inFile);
        File file = new File(destPath);
        FileOutputStream out = new FileOutputStream(file);
        long filesize = this.fs.getFileStatus(inFile).getLen();
        this.progressctr = 0;
        int progressfactor = (int)(filesize / 100L);
        try {
            byte[] buffer;
            if (filesize > 25600L) {
                buffer = new byte[256];
                progressfactor = (int)(filesize / 25600L);
            } else if (filesize > 100L) {
                buffer = new byte[1];
                progressfactor = (int)(filesize / 100L);
            } else {
                buffer = new byte[1];
            }
            int bytesRead = 0;
            int bytectr = 0;
            while ((bytesRead = readFile.read(buffer)) > 0) {
                out.write(buffer, 0, bytesRead);
                ++bytectr;
                if (filesize > 100L) {
                    if (bytectr % progressfactor != 0 || this.progressctr > 100) continue;
                    ++this.progressctr;
                    this.hdfsTransferProgressListener.progressUpdate(this.progressctr);
                    continue;
                }
                if (filesize >= 100L) continue;
                if ((long)this.progressctr != filesize * (long)((int)(100L / filesize))) {
                    this.progressctr += (int)(100L / filesize);
                }
                if ((long)this.progressctr == filesize * (long)((int)(100L / filesize))) {
                    this.progressctr = 100;
                }
                this.hdfsTransferProgressListener.progressUpdate(this.progressctr);
            }
            this.success = true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.out.println("Error while copying file");
        }
        finally {
            try {
                out.close();
                readFile.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                System.out.println("Error while closing files");
            }
        }
        if (this.progressctr >= 100) {
            System.out.println("Copy Complete");
        }
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readFile(String filepath, String filesystem, String readtype, int limit) throws IOException {
        int bytectr;
        String filetext = "";
        int bytesRead = 0;
        int linesenctd = 0;
        if (filesystem.equalsIgnoreCase("hdfs")) {
            this.fs = FileSystem.get((Configuration)this.conf);
            Path inFile = new Path(filepath);
            try (FSDataInputStream readFile = this.fs.open(inFile);){
                if (readtype.equalsIgnoreCase("bybytes")) {
                    while ((bytesRead = readFile.read()) > 0 && limit > 0) {
                        filetext = filetext + (char)bytesRead;
                        --limit;
                    }
                    return filetext;
                }
                if (readtype.equalsIgnoreCase("byline")) {
                    while ((bytesRead = readFile.read()) > 0 && linesenctd < limit) {
                        filetext = filetext + (char)bytesRead;
                        if ((char)bytesRead != '\n') continue;
                        ++linesenctd;
                    }
                    return filetext;
                }
                if (!readtype.equalsIgnoreCase("bydelim")) return filetext;
                for (bytectr = 0; (bytesRead = readFile.read()) > 0 && bytectr < 65536; ++bytectr) {
                    filetext = filetext + (char)bytesRead;
                    if (bytesRead != limit || bytesRead == 10) continue;
                    filetext = filetext + '\n';
                }
                return filetext;
            }
        }
        if (!filesystem.equalsIgnoreCase("local")) return filetext;
        File file = new File(filepath);
        try (FileInputStream readFile = new FileInputStream(file);){
            if (readtype.equalsIgnoreCase("bybytes")) {
                while ((bytesRead = readFile.read()) > 0 && limit > 0) {
                    filetext = filetext + (char)bytesRead;
                    --limit;
                }
                return filetext;
            } else if (readtype.equalsIgnoreCase("byline")) {
                while ((bytesRead = readFile.read()) > 0 && linesenctd < limit) {
                    filetext = filetext + (char)bytesRead;
                    if ((char)bytesRead != '\n') continue;
                    ++linesenctd;
                }
                return filetext;
            } else {
                if (!readtype.equalsIgnoreCase("bydelim")) return filetext;
                while ((bytesRead = readFile.read()) > 0 && bytectr < 65536) {
                    filetext = filetext + (char)bytesRead;
                    ++bytectr;
                    if (bytesRead != limit || bytesRead == 10) continue;
                    filetext = filetext + '\n';
                }
            }
            return filetext;
        }
    }

    private void checkOutFile(Path outFile) throws IOException {
        if (this.fs.exists(outFile)) {
            System.out.println("File with same name already exists.. Will overwrite file");
            this.fs.delete(outFile, true);
        }
    }

    public static boolean testhdpath(String hdpath) {
        if (hdpath == null || "".equals(hdpath)) {
            return false;
        }
        Configuration conf = new Configuration();
        conf.set("fs.default.name", hdpath);
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.listStatus(new Path("/"));
            return true;
        }
        catch (IOException e) {
            System.out.println("File Validation error:" + e.getLocalizedMessage());
            return false;
        }
    }
}

