/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.profile;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.JDBCRowset;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;

public class InterTableInfo {
    public static String[] getMatchCount(String table1, String col1, String table2, String col2, byte multiple, int mX) {
        QueryBuilder qb = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), table1, col1, Rdbms_conn.getDBType());
        qb.setCTableCol(table2, col2);
        String q1 = qb.get_match_count(multiple, mX);
        String[] st = new String[6];
        try {
            String null_count;
            String row_count;
            Rdbms_conn.openConn();
            ResultSet rs = Rdbms_conn.runQuery(q1);
            while (rs.next()) {
                String row_sum;
                st[0] = row_count = rs.getString("row_count");
                st[3] = row_sum = rs.getString("row_sum");
            }
            rs.close();
            q1 = qb.get_nullCount_query_w("Null");
            rs = Rdbms_conn.runQuery(q1);
            while (rs.next()) {
                st[1] = null_count = rs.getString("equal_count");
            }
            rs.close();
            q1 = qb.count_query_w(true, "row_count");
            rs = Rdbms_conn.runQuery(q1);
            while (rs.next()) {
                st[2] = row_count = rs.getString("row_count");
            }
            rs.close();
            qb = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), table2, col2, Rdbms_conn.getDBType());
            q1 = qb.get_nullCount_query_w("Null");
            rs = Rdbms_conn.runQuery(q1);
            while (rs.next()) {
                st[4] = null_count = rs.getString("equal_count");
            }
            rs.close();
            q1 = qb.count_query_w(false, "row_count");
            rs = Rdbms_conn.runQuery(q1);
            while (rs.next()) {
                st[5] = row_count = rs.getString("row_count");
            }
            rs.close();
            Rdbms_conn.closeConn();
        }
        catch (SQLException e) {
            System.out.println("\n match count execution failed");
            System.out.println(e.getMessage());
        }
        return st;
    }

    public static void loadQuery(final String[] query, final ReportTableModel _rt, final Vector<String> unique_table_s, final Hashtable<String, Integer> _ht) throws Exception {
        final int count = _rt.getModel().getRowCount();
        if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0) {
            throw new Exception("\n Load Query is not supported for Hive Data Storage");
        }
        Thread[] tid = new Thread[query.length];
        int qIndex = 0;
        while (qIndex < query.length) {
            final int cIndex = qIndex++;
            tid[cIndex] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int fcount = 0;
                    String[] tbl = null;
                    String[] col = null;
                    boolean insertflag = false;
                    try {
                        JDBCRowset rs = new JDBCRowset(query[cIndex], 0, true);
                        tbl = rs.getTableName();
                        col = rs.getColName();
                        rs.moveToFirst();
                        for (int c = 0; c < count; ++c) {
                            Object[] obj = new Object[col.length];
                            for (int i = 0; i < col.length; ++i) {
                                Integer index = (Integer)_ht.get((String)unique_table_s.get(cIndex) + col[i]);
                                if (index == null) continue;
                                obj[i] = _rt.getModel().getValueAt(c, index);
                            }
                            try {
                                rs.insertRow(obj);
                                insertflag = true;
                                continue;
                            }
                            catch (SQLException sql_e) {
                                System.out.println("\n Row Id:" + (c + 1) + " Error-" + sql_e.getMessage() + " For Table: " + (String)unique_table_s.get(cIndex));
                                ++fcount;
                            }
                        }
                        rs.close();
                    }
                    catch (SQLException e) {
                        System.out.println("\n Error-" + e.getMessage() + " For Table: " + (String)unique_table_s.get(cIndex));
                    }
                    if (insertflag) {
                        System.out.println("\n " + (count - fcount) + " of Total " + count + " Rows Inserted Successfully in table :" + (String)unique_table_s.get(cIndex));
                    }
                }
            });
            tid[cIndex].start();
        }
        for (int i = 0; i < query.length; ++i) {
            try {
                tid[i].join();
                continue;
            }
            catch (Exception e) {
                System.out.println("\n Thread Error:" + e.getMessage());
            }
        }
    }

    public static void synchQuery(final String[] query, ReportTableModel _rt, final Vector<String> table_s, final Vector<String> column_s, final Hashtable<String, Integer> _ht, final String[] queryString) {
        int qindex;
        final int count = _rt.getModel().getRowCount();
        final Object[][] stored = new Object[query.length][count];
        final int[] cI = new int[query.length];
        Thread[] tid = new Thread[query.length];
        if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
            qindex = 0;
            while (qindex < query.length) {
                final int cIndex = qindex++;
                tid[cIndex] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String tbl = (String)table_s.get(cIndex);
                        String col = (String)column_s.get(cIndex);
                        String newQuery = query[cIndex];
                        Integer tab_index = (Integer)_ht.get(tbl + col);
                        if (tab_index == null) {
                            return;
                        }
                        if (queryString[tab_index] != null && !"".equals(queryString[tab_index])) {
                            newQuery = newQuery + " WHERE " + queryString[tab_index];
                        }
                        cI[cIndex] = tab_index;
                        try {
                            JDBCRowset rs = new JDBCRowset(newQuery, count, false);
                            for (int c = 0; c < count; ++c) {
                                stored[cIndex][c] = rs.getObject(c + 1, 1);
                            }
                            rs.close();
                        }
                        catch (SQLException e) {
                            System.out.println("\n Error-" + e.getMessage() + " For Query: " + newQuery);
                        }
                    }
                });
                tid[cIndex].start();
            }
            for (int i = 0; i < query.length; ++i) {
                try {
                    tid[i].join();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("\n Thread Error:" + e.getMessage());
                }
            }
        } else {
            for (qindex = 0; qindex < query.length; ++qindex) {
                int cIndex = qindex;
                String tbl = table_s.get(cIndex);
                String col = column_s.get(cIndex);
                String newQuery = query[cIndex];
                Integer tab_index = _ht.get(tbl + col);
                if (tab_index == null) {
                    return;
                }
                if (queryString[tab_index] != null && !"".equals(queryString[tab_index])) {
                    newQuery = newQuery + " WHERE " + queryString[tab_index];
                }
                cI[cIndex] = tab_index;
                try {
                    JDBCRowset rs = new JDBCRowset(newQuery, count, false);
                    for (int c = 0; c < count; ++c) {
                        stored[cIndex][c] = rs.getObject(c + 1, 1);
                    }
                    rs.close();
                    continue;
                }
                catch (SQLException e) {
                    System.out.println("\n Error-" + e.getMessage() + " For Query: " + newQuery);
                }
            }
        }
        for (int c = 0; c < count; ++c) {
            for (int j = 0; j < query.length; ++j) {
                _rt.getModel().setValueAt(stored[j][c], c, cI[j]);
            }
        }
    }
}

