/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.ModelNotInitializedException;
import net.sourceforge.openforecast.models.Utils;

public class MultipleLinearRegressionModel
extends AbstractForecastingModel {
    private double intercept = 0.0;
    private Hashtable<String, Double> coefficient;

    public MultipleLinearRegressionModel() {
        this.coefficient = null;
    }

    public MultipleLinearRegressionModel(String[] independentVariable) {
        this.setIndependentVariables(independentVariable);
    }

    @Override
    public void init(DataSet dataSet) {
        String[] varNames = dataSet.getIndependentVariables();
        if (this.coefficient == null) {
            this.setIndependentVariables(varNames);
        }
        int n = varNames.length;
        double[][] a = new double[n + 1][n + 2];
        for (DataPoint dp : dataSet) {
            for (int row = 0; row < n + 1; ++row) {
                double rowMult = 1.0;
                if (row != 0) {
                    String rowVarName = varNames[row - 1];
                    rowMult = dp.getIndependentValue(rowVarName);
                }
                int col = 0;
                while (col < n + 2) {
                    double colMult = 1.0;
                    if (col == n + 1) {
                        colMult = dp.getDependentValue();
                    } else if (col > 0) {
                        String colVarName = varNames[col - 1];
                        colMult = dp.getIndependentValue(colVarName);
                    }
                    double[] dArray = a[row];
                    int n2 = col++;
                    dArray[n2] = dArray[n2] + rowMult * colMult;
                }
            }
        }
        double[] coeff = Utils.GaussElimination(a);
        this.intercept = coeff[0];
        for (int i = 1; i < n + 1; ++i) {
            this.coefficient.put(varNames[i - 1], new Double(coeff[i]));
        }
        this.calculateAccuracyIndicators(dataSet);
    }

    public void init(double intercept, Hashtable<String, Double> coefficients) {
        if (this.coefficient == null) {
            Enumeration<String> keysEnum = coefficients.keys();
            String[] keys = new String[coefficients.size()];
            int k = 0;
            while (keysEnum.hasMoreElements()) {
                keys[k++] = keysEnum.nextElement();
            }
            this.setIndependentVariables(keys);
        }
        this.intercept = intercept;
        for (String name : this.coefficient.keySet()) {
            double coeff = ((Number)coefficients.get(name)).doubleValue();
            this.coefficient.put(name, new Double(coeff));
        }
        this.initialized = true;
    }

    public double getIntercept() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.intercept;
    }

    public Hashtable<String, Double> getCoefficients() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return new Hashtable<String, Double>(this.coefficient);
    }

    @Override
    public int getNumberOfPredictors() {
        return this.coefficient.size();
    }

    @Override
    public double forecast(DataPoint dataPoint) {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        double forecastValue = this.intercept;
        for (Map.Entry<String, Double> entry : this.coefficient.entrySet()) {
            double x = dataPoint.getIndependentValue(entry.getKey());
            double coeff = entry.getValue();
            forecastValue += coeff * x;
        }
        dataPoint.setDependentValue(forecastValue);
        return forecastValue;
    }

    private void setIndependentVariables(String[] independentVariable) {
        this.coefficient = new Hashtable(independentVariable.length);
        for (int v = 0; v < independentVariable.length; ++v) {
            this.coefficient.put(independentVariable[v], new Double(0.0));
        }
    }

    @Override
    public String getForecastType() {
        return "Multiple variable linear regression";
    }

    @Override
    public String toString() {
        String desc = "Multiple variable linear regression model with the following equation:\n  y=" + this.intercept;
        Set<Map.Entry<String, Double>> coeffSet = this.coefficient.entrySet();
        for (Map.Entry<String, Double> entry : coeffSet) {
            double coeff = entry.getValue();
            if (coeff < -TOLERANCE) {
                desc = desc + coeff + "*" + entry.getKey();
                continue;
            }
            if (!(coeff > TOLERANCE)) continue;
            desc = desc + "+" + coeff + "*" + entry.getKey();
        }
        return desc;
    }
}

