/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.EvaluationCriteria;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.AbstractTimeBasedModel;
import net.sourceforge.openforecast.models.DoubleExponentialSmoothingModel;
import net.sourceforge.openforecast.models.MovingAverageModel;
import net.sourceforge.openforecast.models.MultipleLinearRegressionModel;
import net.sourceforge.openforecast.models.PolynomialRegressionModel;
import net.sourceforge.openforecast.models.RegressionModel;
import net.sourceforge.openforecast.models.SimpleExponentialSmoothingModel;
import net.sourceforge.openforecast.models.TripleExponentialSmoothingModel;

public class Forecaster {
    private Forecaster() {
    }

    public static ForecastingModel getBestForecast(DataSet dataSet) {
        return Forecaster.getBestForecast(dataSet, EvaluationCriteria.BLEND);
    }

    public static ForecastingModel getBestForecast(DataSet dataSet, EvaluationCriteria evalMethod) {
        String[] independentVariable = dataSet.getIndependentVariables();
        AbstractForecastingModel bestModel = null;
        for (int i = 0; i < independentVariable.length; ++i) {
            AbstractForecastingModel model = new RegressionModel(independentVariable[i]);
            model.init(dataSet);
            if (Forecaster.betterThan(model, bestModel, evalMethod)) {
                bestModel = model;
            }
            int order = 10;
            if (dataSet.size() < order * order) {
                order = (int)Math.sqrt(dataSet.size()) - 1;
            }
            model = new PolynomialRegressionModel(independentVariable[i], order);
            model.init(dataSet);
            if (!Forecaster.betterThan(model, bestModel, evalMethod)) continue;
            bestModel = model;
        }
        ArrayList<String> availableVariables = new ArrayList<String>(independentVariable.length);
        for (int i = 0; i < independentVariable.length; ++i) {
            availableVariables.add(independentVariable[i]);
        }
        ArrayList<String> bestVariables = new ArrayList<String>(independentVariable.length);
        while (availableVariables.size() > 0) {
            int count = bestVariables.size();
            String[] workingList = new String[count + 1];
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    workingList[i] = (String)bestVariables.get(i);
                }
            }
            String bestAvailVariable = null;
            Iterator it = availableVariables.iterator();
            while (it.hasNext()) {
                String currentVar;
                workingList[count] = currentVar = (String)it.next();
                MultipleLinearRegressionModel model = new MultipleLinearRegressionModel(workingList);
                model.init(dataSet);
                if (Forecaster.betterThan(model, bestModel, evalMethod)) {
                    bestModel = model;
                    bestAvailVariable = currentVar;
                }
                workingList[count] = null;
            }
            if (bestAvailVariable == null) break;
            int bestVarIndex = availableVariables.indexOf(bestAvailVariable);
            availableVariables.remove(bestVarIndex);
            bestVariables.add(count, bestAvailVariable);
            ++count;
        }
        if (dataSet.getTimeVariable() != null) {
            AbstractTimeBasedModel model = new MovingAverageModel();
            model.init(dataSet);
            if (Forecaster.betterThan(model, bestModel, evalMethod)) {
                bestModel = model;
            }
            if (dataSet.getPeriodsPerYear() > 0) {
                model = new MovingAverageModel(dataSet.getPeriodsPerYear());
                model.init(dataSet);
                if (Forecaster.betterThan(model, bestModel, evalMethod)) {
                    bestModel = model;
                }
            }
            if (Forecaster.betterThan(model = SimpleExponentialSmoothingModel.getBestFitModel(dataSet), bestModel, evalMethod)) {
                bestModel = model;
            }
            if (Forecaster.betterThan(model = DoubleExponentialSmoothingModel.getBestFitModel(dataSet), bestModel, evalMethod)) {
                bestModel = model;
            }
            if (Forecaster.betterThan(model = TripleExponentialSmoothingModel.getBestFitModel(dataSet), bestModel, evalMethod)) {
                bestModel = model;
            }
        }
        return bestModel;
    }

    private static boolean betterThan(ForecastingModel model1, ForecastingModel model2, EvaluationCriteria evalMethod) {
        if (model2 == null) {
            return true;
        }
        double tolerance = 1.0E-8;
        if (evalMethod == EvaluationCriteria.BIAS) {
            return model1.getBias() <= model2.getBias();
        }
        if (evalMethod == EvaluationCriteria.MAD) {
            return model1.getMAD() <= model2.getMAD();
        }
        if (evalMethod == EvaluationCriteria.MAPE) {
            return model1.getMAPE() <= model2.getMAPE();
        }
        if (evalMethod == EvaluationCriteria.MSE) {
            return model1.getMSE() <= model2.getMSE();
        }
        if (evalMethod == EvaluationCriteria.SAE) {
            return model1.getSAE() <= model2.getSAE();
        }
        if (evalMethod == EvaluationCriteria.AIC) {
            return model1.getAIC() <= model2.getAIC();
        }
        int score = 0;
        if (model1.getAIC() - model2.getAIC() <= tolerance) {
            ++score;
        } else if (model1.getAIC() - model2.getAIC() >= tolerance) {
            --score;
        }
        if (model1.getBias() - model2.getBias() <= tolerance) {
            ++score;
        } else if (model1.getBias() - model2.getBias() >= tolerance) {
            --score;
        }
        if (model1.getMAD() - model2.getMAD() <= tolerance) {
            ++score;
        } else if (model1.getMAD() - model2.getMAD() >= tolerance) {
            --score;
        }
        if (model1.getMAPE() - model2.getMAPE() <= tolerance) {
            ++score;
        } else if (model1.getMAPE() - model2.getMAPE() >= tolerance) {
            --score;
        }
        if (model1.getMSE() - model2.getMSE() <= tolerance) {
            ++score;
        } else if (model1.getMSE() - model2.getMSE() >= tolerance) {
            --score;
        }
        if (model1.getSAE() - model2.getSAE() <= tolerance) {
            ++score;
        } else if (model1.getSAE() - model2.getSAE() >= tolerance) {
            --score;
        }
        if (score == 0) {
            double diff = model1.getAIC() - model2.getAIC() + model1.getBias() - model2.getBias() + model1.getMAD() - model2.getMAD() + model1.getMAPE() - model2.getMAPE() + model1.getMSE() - model2.getMSE() + model1.getSAE() - model2.getSAE();
            return diff < 0.0;
        }
        return score > 0;
    }
}

