/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.WeightedMovingAverageModel;

public class MovingAverageModel
extends WeightedMovingAverageModel {
    public MovingAverageModel() {
    }

    public MovingAverageModel(String independentVariable) {
        super(independentVariable);
    }

    public MovingAverageModel(int period) {
        double[] weights = new double[period];
        for (int p = 0; p < period; ++p) {
            weights[p] = 1.0 / (double)period;
        }
        this.setWeights(weights);
    }

    public MovingAverageModel(String independentVariable, int period) {
        super(independentVariable);
        double[] weights = new double[period];
        for (int p = 0; p < period; ++p) {
            weights[p] = 1.0 / (double)period;
        }
        this.setWeights(weights);
    }

    @Override
    public void init(DataSet dataSet) {
        if (this.getNumberOfPeriods() <= 0) {
            int period = this.getNumberOfPeriods();
            double[] weights = new double[period];
            for (int p = 0; p < period; ++p) {
                weights[p] = 1 / period;
            }
            this.setWeights(weights);
        }
        super.init(dataSet);
    }

    @Override
    public String getForecastType() {
        return "Moving average";
    }

    @Override
    public String toString() {
        return "Moving average model, spanning " + this.getNumberOfPeriods() + " periods and using an independent variable of " + this.getIndependentVariable() + ".";
    }
}

