/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.dataquality;

import java.util.Arrays;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;

public class FillCheck {
    public static int getEmptyNo(Object[] row) {
        int emptyNo = 0;
        if (row == null) {
            return emptyNo;
        }
        for (int i = 0; i < row.length; ++i) {
            if (row[i] != null && !"".equals(row[i].toString())) continue;
            ++emptyNo;
        }
        return emptyNo;
    }

    public static int getEmptyNo(Vector<Object> row) {
        int emptyNo = 0;
        if (row == null) {
            return emptyNo;
        }
        emptyNo = FillCheck.getEmptyNo(row.toArray());
        return emptyNo;
    }

    public static int[] getEmptyCount(Object[][] dataset) {
        if (dataset == null) {
            return null;
        }
        int[] emptyCount = new int[dataset[0].length + 1];
        Arrays.fill(emptyCount, 0);
        for (int i = 0; i < dataset.length; ++i) {
            int emptyNo = FillCheck.getEmptyNo(dataset[i]);
            emptyCount[emptyNo] = emptyCount[emptyNo] + 1;
        }
        return emptyCount;
    }

    public static int[] getEmptyCount(ReportTableModel rtm) {
        if (rtm == null) {
            return null;
        }
        int rowc = rtm.getModel().getRowCount();
        int colc = rtm.getModel().getColumnCount();
        int[] emptyCount = new int[colc + 1];
        Arrays.fill(emptyCount, 0);
        for (int i = 0; i < rowc; ++i) {
            Object[] row = rtm.getRow(i);
            int emptyNo = FillCheck.getEmptyNo(row);
            emptyCount[emptyNo] = emptyCount[emptyNo] + 1;
        }
        return emptyCount;
    }

    public static ReportTableModel getEmptyCount(ReportTableModel rtm, int emptyCount) {
        if (rtm == null || emptyCount >= rtm.getModel().getColumnCount()) {
            return rtm;
        }
        ReportTableModel newRTM = new ReportTableModel(rtm.getAllColName(), true, true);
        int rowc = rtm.getModel().getRowCount();
        for (int i = 0; i < rowc; ++i) {
            Object[] row = rtm.getRow(i);
            int emptyNo = FillCheck.getEmptyNo(row);
            if (emptyNo != emptyCount) continue;
            newRTM.addFillRow(row);
        }
        return newRTM;
    }
}

