/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.rdbms;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;
import org.arrah.framework.rdbms.SqlType;
import org.arrah.framework.rdbms.UpdatableJdbcRowsetImpl;

public class JDBCRowset {
    private UpdatableJdbcRowsetImpl rows;
    private String[] col_name;
    private String[] tbl_name;
    private int[] col_type;
    private int rowC = 0;
    private int numberOfColumns = 0;
    private int rowPPage = 100;

    public JDBCRowset(String query, int maxRow, boolean editable) throws SQLException {
        try {
            String protocol = Rdbms_conn.getProtocol();
            String url = Rdbms_conn.get_JDBC_URL();
            this.rows = url == null || "".equals(url) ? (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("oracle_native") == 0 ? new UpdatableJdbcRowsetImpl(protocol + ":@" + Rdbms_conn.getHValue("Database_DSN"), Rdbms_conn.getHValue("Database_User"), Rdbms_conn.getHValue("Database_Passwd")) : new UpdatableJdbcRowsetImpl(protocol + ":" + Rdbms_conn.getHValue("Database_DSN"), Rdbms_conn.getHValue("Database_User"), Rdbms_conn.getHValue("Database_Passwd"))) : new UpdatableJdbcRowsetImpl(url, Rdbms_conn.getHValue("Database_User"), Rdbms_conn.getHValue("Database_Passwd"));
            this.rows.setReadOnly(editable);
            this.rows.setCommand(query);
            if (maxRow > 1) {
                this.rows.setMaxRows(maxRow);
            }
            if (query.indexOf(" ?") != -1) {
                Vector<?>[] dateVar = QueryBuilder.getDateCondition();
                for (int i = 0; i < dateVar[0].size(); ++i) {
                    String s1 = (String)dateVar[1].get(i);
                    if (s1.compareToIgnoreCase("time") == 0) {
                        this.rows.setTime(i + 1, new Time(((java.util.Date)dateVar[0].get(i)).getTime()));
                    }
                    if (s1.compareToIgnoreCase("date") == 0) {
                        this.rows.setDate(i + 1, new Date(((java.util.Date)dateVar[0].get(i)).getTime()));
                    }
                    if (s1.compareToIgnoreCase("timestamp") != 0) continue;
                    this.rows.setTimestamp(i + 1, new Timestamp(((java.util.Date)dateVar[0].get(i)).getTime()));
                }
            }
            this.rows.execute();
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                if (this.rows.last()) {
                    this.rowC = this.rows.getRow();
                }
            } else {
                Rdbms_conn.openConn();
                String orgQuery = QueryBuilder.hive_count_query(query);
                ResultSet rs = Rdbms_conn.runQuery(orgQuery);
                while (rs.next()) {
                    this.rowC = rs.getInt("total_count");
                }
                rs.close();
                Rdbms_conn.closeConn();
            }
            this.createMD();
        }
        catch (SQLException e) {
            System.err.println("Error in JDBCRowset Constructor:" + e.getLocalizedMessage());
            throw e;
        }
        if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
            this.rows.setAutoCommit(true);
        }
    }

    public JDBCRowset(String query, boolean editable, Vector<Integer> vc_t, Vector<Object> vc_v) throws SQLException {
        try {
            String protocol = Rdbms_conn.getProtocol();
            String url = Rdbms_conn.get_JDBC_URL();
            this.rows = url == null || "".equals(url) ? (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("oracle_native") == 0 ? new UpdatableJdbcRowsetImpl(protocol + ":@" + Rdbms_conn.getHValue("Database_DSN"), Rdbms_conn.getHValue("Database_User"), Rdbms_conn.getHValue("Database_Passwd")) : new UpdatableJdbcRowsetImpl(protocol + ":" + Rdbms_conn.getHValue("Database_DSN"), Rdbms_conn.getHValue("Database_User"), Rdbms_conn.getHValue("Database_Passwd"))) : new UpdatableJdbcRowsetImpl(url, Rdbms_conn.getHValue("Database_User"), Rdbms_conn.getHValue("Database_Passwd"));
            this.rows.setReadOnly(editable);
            this.rows.setCommand(query);
            int fromIndex = 0;
            for (int i = 0; i < vc_t.size(); ++i) {
                if ((fromIndex = query.indexOf(" ?", fromIndex)) == -1) {
                    return;
                }
                fromIndex += 2;
                this.setQuery(i, vc_t.get(i), vc_v.get(i));
            }
            if (query.indexOf(" ?", fromIndex) != -1) {
                Vector<?>[] dateVar = QueryBuilder.getDateCondition();
                for (int i = vc_t.size(); i < vc_t.size() + dateVar[0].size(); ++i) {
                    String s1 = (String)dateVar[1].get(i - vc_t.size());
                    if (s1.compareToIgnoreCase("time") == 0) {
                        this.rows.setTime(i + 1, new Time(((java.util.Date)dateVar[0].get(i - vc_t.size())).getTime()));
                    }
                    if (s1.compareToIgnoreCase("date") == 0) {
                        this.rows.setDate(i + 1, new Date(((java.util.Date)dateVar[0].get(i - vc_t.size())).getTime()));
                    }
                    if (s1.compareToIgnoreCase("timestamp") != 0) continue;
                    this.rows.setTimestamp(i + 1, new Timestamp(((java.util.Date)dateVar[0].get(i - vc_t.size())).getTime()));
                }
            }
            this.rows.execute();
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                if (this.rows.last()) {
                    this.rowC = this.rows.getRow();
                }
            } else {
                Rdbms_conn.openConn();
                String orgQuery = QueryBuilder.hive_count_query(query);
                ResultSet rs = Rdbms_conn.runQuery(orgQuery);
                while (rs.next()) {
                    this.rowC = rs.getInt("total_count");
                }
                rs.close();
                Rdbms_conn.closeConn();
            }
        }
        catch (SQLException e) {
            System.err.println("Error in Prepared JDBCRowset Constructor:" + e.getLocalizedMessage());
            throw e;
        }
        if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
            this.rows.setAutoCommit(true);
        }
    }

    public Vector<Object>[] getRowCol(int fromIndex, int toIndex, Vector<Object>[] row_v) throws SQLException {
        this.rows.absolute(fromIndex);
        this.rows.previous();
        int counter = 0;
        if (toIndex >= fromIndex) {
            row_v = new Vector[toIndex - fromIndex + 1];
        }
        while (this.rows.next() && toIndex >= fromIndex + counter) {
            row_v[counter] = new Vector();
            block17: for (int i = 1; i < this.col_name.length + 1; ++i) {
                switch (this.col_type[i - 1]) {
                    case -6: 
                    case 4: 
                    case 5: {
                        row_v[counter].add(i - 1, new Integer(this.rows.getInt(i)));
                        continue block17;
                    }
                    case -5: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        row_v[counter].add(i - 1, new Double(this.rows.getDouble(i)));
                        continue block17;
                    }
                    case 6: {
                        row_v[counter].add(i - 1, new Float(this.rows.getFloat(i)));
                        continue block17;
                    }
                    case 2005: {
                        row_v[counter].add(i - 1, this.rows.getClob(i));
                        continue block17;
                    }
                    case 2004: {
                        row_v[counter].add(i - 1, this.rows.getBlob(i));
                        continue block17;
                    }
                    case -7: 
                    case 16: {
                        row_v[counter].add(i - 1, new Boolean(this.rows.getBoolean(i)));
                        continue block17;
                    }
                    case 91: {
                        row_v[counter].add(i - 1, this.rows.getDate(i));
                        continue block17;
                    }
                    case 92: {
                        row_v[counter].add(i - 1, this.rows.getTime(i));
                        continue block17;
                    }
                    case 93: {
                        row_v[counter].add(i - 1, this.rows.getTimestamp(i));
                        continue block17;
                    }
                    case 2003: {
                        row_v[counter].add(i - 1, this.rows.getArray(i));
                        continue block17;
                    }
                    case 2006: {
                        row_v[counter].add(i - 1, this.rows.getRef(i));
                        continue block17;
                    }
                    case -2: {
                        row_v[counter].add(i - 1, this.rows.getByte(i));
                        continue block17;
                    }
                    case -4: 
                    case -3: {
                        row_v[counter].add(i - 1, this.rows.getBytes(i));
                        continue block17;
                    }
                    case 0: 
                    case 70: 
                    case 1111: 
                    case 2000: 
                    case 2001: 
                    case 2002: {
                        row_v[counter].add(i - 1, this.rows.getObject(i));
                        continue block17;
                    }
                    default: {
                        row_v[counter].add(i - 1, this.rows.getString(i));
                    }
                }
            }
            ++counter;
        }
        return row_v;
    }

    public boolean updateCellVal(int row, int col, Object obj) throws SQLException {
        this.rows.absolute(row);
        boolean update = this.updateCell(col, obj);
        this.rows.updateRow();
        try {
            this.rows.refreshRow();
        }
        catch (Exception e) {
            System.out.println("WARNING :: ResultSet.refreshRow() is not Supported");
        }
        return update;
    }

    public boolean updateCell(int i, Object o) throws SQLException {
        boolean changeToNull = false;
        try {
            switch (this.col_type[i]) {
                case -6: 
                case 4: 
                case 5: {
                    this.rows.updateInt(i + 1, ((Number)o).intValue());
                    break;
                }
                case -5: 
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    this.rows.updateDouble(i + 1, ((Number)o).doubleValue());
                    break;
                }
                case 6: {
                    this.rows.updateFloat(i + 1, ((Number)o).floatValue());
                    break;
                }
                case 2005: {
                    this.rows.updateClob(i + 1, (Clob)o);
                    break;
                }
                case 2004: {
                    this.rows.updateBlob(i + 1, (Blob)o);
                    break;
                }
                case -7: 
                case 16: {
                    this.rows.updateBoolean(i + 1, (boolean)((Boolean)o));
                    break;
                }
                case 91: {
                    this.rows.updateDate(i + 1, new Date(((java.util.Date)o).getTime()));
                    break;
                }
                case 92: {
                    this.rows.updateTime(i + 1, new Time(((java.util.Date)o).getTime()));
                    break;
                }
                case 93: {
                    this.rows.updateTimestamp(i + 1, new Timestamp(((java.util.Date)o).getTime()));
                    break;
                }
                case 2003: {
                    this.rows.updateArray(i + 1, (Array)o);
                    break;
                }
                case 2006: {
                    this.rows.updateRef(i + 1, (Ref)o);
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 0: 
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: {
                    this.rows.updateObject(i + 1, o);
                    break;
                }
                default: {
                    if ("".equals(o.toString())) {
                        this.rows.updateString(i + 1, null);
                        changeToNull = true;
                        break;
                    }
                    this.rows.updateString(i + 1, o.toString());
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            try {
                this.rows.updateString(i + 1, o.toString());
            }
            catch (Exception exp) {
                this.rows.updateObject(i + 1, null);
                System.out.println("\n Update Casting exception");
            }
        }
        catch (NullPointerException e) {
            this.rows.updateObject(i + 1, o);
        }
        return changeToNull;
    }

    private void setQuery(int i, int type, Object o) throws SQLException {
        try {
            switch (type) {
                case -6: 
                case 4: 
                case 5: {
                    this.rows.setInt(i + 1, ((Number)o).intValue());
                    break;
                }
                case -5: 
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    this.rows.setDouble(i + 1, ((Number)o).doubleValue());
                    break;
                }
                case 6: {
                    this.rows.setFloat(i + 1, ((Number)o).floatValue());
                    break;
                }
                case 2005: {
                    this.rows.setClob(i + 1, (Clob)o);
                    break;
                }
                case 2004: {
                    this.rows.setBlob(i + 1, (Blob)o);
                    break;
                }
                case -7: 
                case 16: {
                    this.rows.setBoolean(i + 1, (boolean)((Boolean)o));
                    break;
                }
                case 91: {
                    this.rows.setDate(i + 1, new Date(((java.util.Date)o).getTime()));
                    break;
                }
                case 92: {
                    this.rows.setTime(i + 1, new Time(((java.util.Date)o).getTime()));
                    break;
                }
                case 93: {
                    this.rows.setTimestamp(i + 1, new Timestamp(((java.util.Date)o).getTime()));
                    break;
                }
                case 2003: {
                    this.rows.setArray(i + 1, (Array)o);
                    break;
                }
                case 2006: {
                    this.rows.setRef(i + 1, (Ref)o);
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 0: 
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: {
                    this.rows.setObject(i + 1, o);
                    break;
                }
                default: {
                    this.rows.setString(i + 1, o.toString());
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            try {
                this.rows.setString(i + 1, o.toString());
            }
            catch (Exception exp) {
                this.rows.setObject(i + 1, null);
                System.out.println("\n Set Casting exception");
            }
        }
        catch (NullPointerException e) {
            this.rows.setObject(i + 1, o);
        }
    }

    public int pageCount() {
        if (this.rowC == 0) {
            return 1;
        }
        if (this.rowC % this.rowPPage == 0) {
            return this.rowC / this.rowPPage;
        }
        return this.rowC / this.rowPPage + 1;
    }

    public void close() {
        try {
            if (this.rows != null) {
                this.rows.close();
            }
        }
        catch (SQLException e) {
            System.out.println("\n Message:" + e.getMessage());
            System.out.println("\n WARNING: Rowset Connection can not be closed.");
        }
    }

    private void createMD() throws SQLException {
        ResultSetMetaData rsmd = this.rows.getMetaData();
        this.numberOfColumns = rsmd.getColumnCount();
        this.col_name = new String[this.numberOfColumns];
        this.tbl_name = new String[this.numberOfColumns];
        this.col_type = new int[this.numberOfColumns];
        for (int i = 1; i < this.numberOfColumns + 1; ++i) {
            this.col_name[i - 1] = rsmd.getColumnName(i);
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                this.tbl_name[i - 1] = rsmd.getTableName(i);
            }
            this.col_type[i - 1] = rsmd.getColumnType(i);
        }
    }

    public String[] getColName() {
        return this.col_name;
    }

    public String[] getColType() {
        String[] colType = new String[this.col_type.length];
        for (int i = 0; i < this.col_type.length; ++i) {
            colType[i] = SqlType.getTypeName(this.col_type[i]);
        }
        return colType;
    }

    public String[] getTableName() {
        return this.tbl_name;
    }

    public void moveToFirst() throws SQLException {
        this.rows.first();
    }

    public synchronized void insertRow(Object[] obj) throws SQLException {
        this.rows.moveToInsertRow();
        for (int j = 0; j < obj.length; ++j) {
            this.updateCell(j, obj[j]);
        }
        this.rows.insertRow();
        this.rows.moveToCurrentRow();
    }

    public synchronized Object getObject(int row, int col) throws SQLException {
        if (row > this.rowC) {
            return null;
        }
        if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
            this.rows.absolute(row);
        } else if (!this.rows.next()) {
            return null;
        }
        Object obj = this.rows.getObject(col);
        if (obj == null) {
            try {
                String ret = this.rows.getString(col);
                return ret;
            }
            catch (Exception e) {
                System.out.println("Exeception:" + e.getLocalizedMessage());
                return null;
            }
        }
        return obj;
    }

    public synchronized Object getRowObject(int col) throws SQLException {
        Object obj = this.rows.getObject(col);
        if (obj == null) {
            try {
                String ret = this.rows.getString(col);
                return ret;
            }
            catch (Exception e) {
                System.out.println("Exeception:" + e.getLocalizedMessage());
                return null;
            }
        }
        return obj;
    }

    public int getRowCount() {
        return this.rowC;
    }

    public synchronized Object[] getRow(int rowId) throws SQLException {
        Object[] objA = new Object[this.numberOfColumns];
        if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0 && !this.rows.next()) {
            return null;
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            objA[i] = Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0 ? this.getObject(rowId, i + 1) : this.getRowObject(i + 1);
        }
        return objA;
    }

    public synchronized void deleteRow(int rowId) {
        try {
            this.rows.absolute(rowId);
            this.rows.deleteRow();
        }
        catch (Exception e) {
            System.out.println("\n RowSet Delete Error for RowID:" + rowId);
            System.out.println("\n Error Message:" + e.getMessage());
        }
    }

    public UpdatableJdbcRowsetImpl getRowset() {
        return this.rows;
    }

    public synchronized void setRowset(UpdatableJdbcRowsetImpl rowset) {
        this.rows = rowset;
    }

    public void setrowPPage(int rows) {
        this.rowPPage = rows;
    }

    public int getrowPPage() {
        return this.rowPPage;
    }
}

