/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.tokenizers;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simmetrics.tokenizers.AbstractTokenizer;

public class QGram
extends AbstractTokenizer {
    private final int q;

    public QGram(int q) {
        Preconditions.checkArgument((q > 0 ? 1 : 0) != 0, (Object)"q must be greater then 0");
        this.q = q;
    }

    public int getQ() {
        return this.q;
    }

    @Override
    public List<String> tokenizeToList(String input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        if (input.length() <= this.q) {
            return Collections.singletonList(input);
        }
        ArrayList<String> ret = new ArrayList<String>(input.length());
        for (int i = 0; i < input.length() - this.q + 1; ++i) {
            ret.add(input.substring(i, i + this.q));
        }
        return ret;
    }

    public String toString() {
        return "QGramTokenizer [q=" + this.q + "]";
    }
}

