/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.simmetrics.tokenizers.Tokenizer;
import org.simmetrics.utils.TokenizingTokenizer;

public class CachingTokenizer
implements TokenizingTokenizer {
    private Tokenizer tokenizer;
    private final LoadingCache<String, List<String>> arrayCache;
    private final LoadingCache<String, Set<String>> setCache;

    public CachingTokenizer(int initialCapacity, int maximumSize) {
        this.arrayCache = CacheBuilder.newBuilder().initialCapacity(initialCapacity).maximumSize((long)maximumSize).build((CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String key) throws Exception {
                return Collections.unmodifiableList(CachingTokenizer.this.getTokenizer().tokenizeToList(key));
            }
        });
        this.setCache = CacheBuilder.newBuilder().initialCapacity(initialCapacity).maximumSize((long)maximumSize).build((CacheLoader)new CacheLoader<String, Set<String>>(){

            public Set<String> load(String key) throws Exception {
                return Collections.unmodifiableSet(CachingTokenizer.this.getTokenizer().tokenizeToSet(key));
            }
        });
    }

    public CachingTokenizer(int initialCapacity, int maximumSize, Tokenizer tokenizer) {
        this(initialCapacity, maximumSize);
        this.tokenizer = tokenizer;
    }

    @Override
    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    @Override
    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<String> tokenizeToList(String input) {
        try {
            return (List)this.arrayCache.get((Object)input);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Set<String> tokenizeToSet(String input) {
        try {
            return (Set)this.setCache.get((Object)input);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "CachingTokenizer [" + this.tokenizer + "]";
    }
}

