/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.WritethroughManagedPropertyImpl;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.virtual.VFS;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminObject;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.CacheStatistics;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.WorkerPoolStatistics;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.PropertyDefinitionMetadata;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.adminapi.jboss.AdminObjectBuilder;
import org.teiid.adminapi.jboss.ManagedUtil;
import org.teiid.jboss.IntegrationPlugin;

public class Admin
implements org.teiid.adminapi.Admin,
Serializable {
    private static final String CONNECTOR_PREFIX = "connector-";
    private static final ProfileKey DEFAULT_PROFILE_KEY = new ProfileKey("default");
    private static final long serialVersionUID = 7081309086056911304L;
    private static ComponentType VDBTYPE = new ComponentType("teiid", "vdb");
    private static ComponentType DQPTYPE = new ComponentType("teiid", "dqp");
    private static String DQPNAME = "RuntimeEngineDeployer";
    private static ComponentType TRANSLATOR_TYPE = new ComponentType("teiid", "translator");
    private static final String[] DS_TYPES = new String[]{"XA", "NoTx", "LocalTx"};
    private static final String[] CF_TYPES = new String[]{"NoTx", "Tx"};
    private ManagementView view;
    private DeploymentManager deploymentMgr;

    public Admin(ManagementView view, DeploymentManager deployMgr) {
        this.view = view;
        this.view.load();
        this.deploymentMgr = deployMgr;
        try {
            this.deploymentMgr.loadProfile(DEFAULT_PROFILE_KEY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ManagementView getView() throws AdminProcessingException {
        if (this.view == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("admin_connection_closed"));
        }
        this.view.load();
        return this.view;
    }

    private DeploymentManager getDeploymentManager() throws AdminProcessingException {
        if (this.deploymentMgr == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("admin_connection_closed"));
        }
        return this.deploymentMgr;
    }

    public void close() {
        this.view = null;
        this.deploymentMgr = null;
    }

    public Collection<Translator> getTranslators() throws AdminException {
        ArrayList<Translator> factories = new ArrayList<Translator>();
        try {
            Set mcSet = this.getView().getComponentsForType(TRANSLATOR_TYPE);
            for (ManagedComponent mc : mcSet) {
                factories.add((Translator)AdminObjectBuilder.buildAO((ManagedCommon)mc, TranslatorMetaData.class));
            }
        }
        catch (Exception e) {
            throw new AdminComponentException((Throwable)e);
        }
        return factories;
    }

    public Translator getTranslator(String deployedName) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(deployedName, TRANSLATOR_TYPE);
            if (mc != null) {
                return (Translator)AdminObjectBuilder.buildAO((ManagedCommon)mc, TranslatorMetaData.class);
            }
            return null;
        }
        catch (Exception e) {
            throw new AdminProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    boolean matches(String regEx, String value) {
        regEx = regEx.replaceAll("\\*", ".*");
        regEx = regEx.replaceAll(AdminObject.ESCAPED_DELIMITER, "");
        return value.matches(regEx);
    }

    public void deployVDB(String fileName, InputStream vdb) throws AdminException {
        if (!fileName.endsWith(".vdb") && !fileName.endsWith("-vdb.xml")) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("bad_vdb_extension"));
        }
        ManagedUtil.deployArchive(this.getDeploymentManager(), fileName, vdb, false);
    }

    public void deleteVDB(String vdbName, int vdbVersion) throws AdminException {
        ManagedComponent mc = this.getVDBManagedComponent(vdbName, vdbVersion);
        if (mc != null) {
            ManagedUtil.removeArchive(this.getDeploymentManager(), mc.getDeployment().getName());
        }
    }

    public VDB getVDB(String vdbName, int vdbVersion) throws AdminException {
        ManagedComponent mc = this.getVDBManagedComponent(vdbName, vdbVersion);
        if (mc != null) {
            return (VDB)AdminObjectBuilder.buildAO((ManagedCommon)mc, VDBMetaData.class);
        }
        return null;
    }

    private ManagedComponent getVDBManagedComponent(String vdbName, int vdbVersion) throws AdminException {
        try {
            Set vdbComponents = this.getView().getComponentsForType(VDBTYPE);
            for (ManagedComponent mc : vdbComponents) {
                String name = ManagedUtil.getSimpleValue((ManagedCommon)mc, "name", String.class);
                int version = ManagedUtil.getSimpleValue((ManagedCommon)mc, "version", Integer.class);
                if (!name.equalsIgnoreCase(vdbName) || version != vdbVersion) continue;
                return mc;
            }
            return null;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Set<VDB> getVDBs() throws AdminException {
        try {
            HashSet<VDB> vdbs = new HashSet<VDB>();
            Set vdbComponents = this.getView().getComponentsForType(VDBTYPE);
            for (ManagedComponent mc : vdbComponents) {
                vdbs.add((VDB)AdminObjectBuilder.buildAO((ManagedCommon)mc, VDBMetaData.class));
            }
            return vdbs;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Session> getSessions() throws AdminException {
        try {
            MetaValue[] sessions;
            ArrayList<Session> sessionList = new ArrayList<Session>();
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getActiveSessions", new MetaValue[0]);
            for (MetaValue mv : sessions = ((CollectionValueSupport)value).getElements()) {
                sessionList.add((Session)((SessionMetadata)MetaValueFactory.getInstance().unwrap(mv, SessionMetadata.class)));
            }
            return sessionList;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void terminateSession(String sessionId) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            ManagedUtil.executeOperation((ManagedCommon)mc, "terminateSession", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)sessionId))});
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Request> getRequests() throws AdminException {
        try {
            MetaValue[] requests;
            ArrayList<Request> requestList = new ArrayList<Request>();
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getRequests", new MetaValue[0]);
            for (MetaValue mv : requests = ((CollectionValueSupport)value).getElements()) {
                requestList.add((Request)((RequestMetadata)MetaValueFactory.getInstance().unwrap(mv, RequestMetadata.class)));
            }
            return requestList;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Request> getRequestsForSession(String sessionId) throws AdminException {
        try {
            MetaValue[] requests;
            ArrayList<Request> requestList = new ArrayList<Request>();
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getRequestsForSession", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)sessionId))});
            for (MetaValue mv : requests = ((CollectionValueSupport)value).getElements()) {
                requestList.add((Request)((RequestMetadata)MetaValueFactory.getInstance().unwrap(mv, RequestMetadata.class)));
            }
            return requestList;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void cancelRequest(String sessionId, long executionId) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            ManagedUtil.executeOperation((ManagedCommon)mc, "cancelRequest", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)sessionId)), SimpleValueSupport.wrap((long)executionId)});
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<String> getCacheTypes() throws AdminException {
        try {
            MetaValue[] requests;
            ArrayList<String> requestList = new ArrayList<String>();
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getCacheTypes", new MetaValue[0]);
            for (MetaValue mv : requests = ((CollectionValueSupport)value).getElements()) {
                requestList.add(ManagedUtil.stringValue(mv));
            }
            return requestList;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void clearCache(String cacheType) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            ManagedUtil.executeOperation((ManagedCommon)mc, "clearCache", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)cacheType))});
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void clearCache(String cacheType, String vdbName, int version) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            ManagedUtil.executeOperation((ManagedCommon)mc, "clearCache", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)cacheType)), SimpleValueSupport.wrap((Serializable)((Object)vdbName)), SimpleValueSupport.wrap((int)version)});
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Transaction> getTransactions() throws AdminException {
        try {
            MetaValue[] requests;
            ArrayList<Transaction> txnList = new ArrayList<Transaction>();
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getTransactions", new MetaValue[0]);
            for (MetaValue mv : requests = ((CollectionValueSupport)value).getElements()) {
                txnList.add((Transaction)((TransactionMetadata)MetaValueFactory.getInstance().unwrap(mv, TransactionMetadata.class)));
            }
            return txnList;
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void terminateTransaction(String xid) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            ManagedUtil.executeOperation((ManagedCommon)mc, "terminateTransaction", MetaValueFactory.getInstance().create((Object)xid));
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public WorkerPoolStatistics getWorkerPoolStats() throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getWorkerPoolStatistics", new MetaValue[0]);
            return (WorkerPoolStatistics)MetaValueFactory.getInstance().unwrap(value, WorkerPoolStatisticsMetadata.class);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<PropertyDefinition> getTemplatePropertyDefinitions(String templateName) throws AdminException {
        DeploymentTemplateInfo info = null;
        try {
            try {
                info = this.getView().getTemplate(templateName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (info == null && !templateName.startsWith("translator-")) {
                info = this.getView().getTemplate("translator-" + templateName);
            }
            if (info == null) {
                throw new AdminProcessingException(IntegrationPlugin.Util.getString("template_not_found", new Object[]{templateName}));
            }
            ArrayList<PropertyDefinition> props = new ArrayList<PropertyDefinition>();
            Map propertyMap = info.getProperties();
            for (ManagedProperty mp : propertyMap.values()) {
                if (!this.includeInTemplate(mp)) continue;
                PropertyDefinitionMetadata p = new PropertyDefinitionMetadata();
                p.setName(mp.getName());
                p.setDescription(mp.getDescription());
                p.setDisplayName(mp.getMappedName());
                if (mp.getDefaultValue() != null) {
                    p.setDefaultValue(((SimpleValueSupport)mp.getDefaultValue()).getValue());
                }
                p.setPropertyTypeClassName(mp.getMetaType().getTypeName());
                p.setModifiable(!mp.isReadOnly());
                if (mp.getField("masked", Boolean.class) != null) {
                    p.setMasked(((Boolean)mp.getField("masked", Boolean.class)).booleanValue());
                } else {
                    p.setMasked(false);
                }
                if (mp.getField("advanced", Boolean.class) != null) {
                    p.setAdvanced(((Boolean)mp.getField("advanced", Boolean.class)).booleanValue());
                } else {
                    p.setAdvanced(true);
                }
                if (mp.getLegalValues() != null) {
                    HashSet<String> values = new HashSet<String>();
                    for (MetaValue value : mp.getLegalValues()) {
                        values.add(ManagedUtil.stringValue(value));
                    }
                    p.setAllowedValues(values);
                }
                p.setRequired(mp.isMandatory());
                props.add((PropertyDefinition)p);
            }
            return props;
        }
        catch (NoSuchDeploymentException e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean includeInTemplate(ManagedProperty mp) {
        Boolean teiidProperty = (Boolean)mp.getField("teiid-property", Boolean.class);
        if (teiidProperty != null && teiidProperty.booleanValue()) {
            return true;
        }
        return mp.isMandatory() && mp.getDefaultValue() == null;
    }

    public void changeVDBConnectionType(String vdbName, int vdbVersion, VDB.ConnectionType type) throws AdminException {
        ManagedComponent mc = this.getVDBManagedComponent(vdbName, vdbVersion);
        if (mc == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("vdb_not_found", new Object[]{vdbName, vdbVersion}));
        }
        ManagedProperty connectionTypeProperty = mc.getProperty("connectionType");
        if (connectionTypeProperty != null) {
            connectionTypeProperty.setValue((MetaValue)ManagedUtil.wrap(new EnumMetaType((Enum[])VDB.ConnectionType.values()), type != null ? type.name() : VDB.ConnectionType.BY_VERSION.name()));
        }
        try {
            this.getView().updateComponent(mc);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void assignToModel(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
        ManagedComponent mc = this.getVDBManagedComponent(vdbName, vdbVersion);
        if (mc == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("vdb_not_found", new Object[]{vdbName, vdbVersion}));
        }
        ManagedProperty mp = mc.getProperty("models");
        List models = (List)MetaValueFactory.getInstance().unwrap(mp.getValue());
        ManagedObject managedModel = null;
        if (models != null && !models.isEmpty()) {
            for (ManagedObject mo : models) {
                String name = ManagedUtil.getSimpleValue((ManagedCommon)mo, "name", String.class);
                if (!modelName.equals(name)) continue;
                managedModel = mo;
            }
        }
        if (managedModel == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("model_not_found", new Object[]{modelName, vdbName, vdbVersion}));
        }
        ManagedProperty sourceMappings = managedModel.getProperty("sourceMappings");
        if (sourceMappings != null) {
            List mappings = (List)MetaValueFactory.getInstance().unwrap(sourceMappings.getValue());
            for (ManagedObject mo : mappings) {
                String sName = ManagedUtil.getSimpleValue((ManagedCommon)mo, "name", String.class);
                if (!sName.equals(sourceName)) continue;
                ManagedProperty translatorProperty = mo.getProperty("translatorName");
                if (translatorProperty == null) {
                    translatorProperty = new WritethroughManagedPropertyImpl(mo, (Fields)new DefaultFieldsImpl("translatorName"));
                }
                translatorProperty.setValue((MetaValue)ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, translatorName));
                ManagedProperty jndiProperty = mo.getProperty("connectionJndiName");
                if (jndiProperty == null) {
                    jndiProperty = new WritethroughManagedPropertyImpl(mo, (Fields)new DefaultFieldsImpl("connectionJndiName"));
                }
                jndiProperty.setValue((MetaValue)ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, dsName));
            }
        } else {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("sourcename_not_found", new Object[]{sourceName, vdbName, vdbVersion, modelName}));
        }
        try {
            this.getView().updateComponent(mc);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    private void manageRoleToDataPolicy(String vdbName, int vdbVersion, String policyName, String role, boolean add) throws AdminException {
        ManagedComponent mc = this.getVDBManagedComponent(vdbName, vdbVersion);
        if (mc == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("vdb_not_found", new Object[]{vdbName, vdbVersion}));
        }
        ManagedProperty mp = mc.getProperty("dataPolicies");
        List policies = (List)MetaValueFactory.getInstance().unwrap(mp.getValue());
        ManagedObject managedPolicy = null;
        if (policies != null && !policies.isEmpty()) {
            for (ManagedObject mo : policies) {
                String name = ManagedUtil.getSimpleValue((ManagedCommon)mo, "name", String.class);
                if (!policyName.equals(name)) continue;
                managedPolicy = mo;
            }
        }
        if (managedPolicy == null) {
            throw new AdminProcessingException(IntegrationPlugin.Util.getString("policy_not_found", new Object[]{policyName, vdbName, vdbVersion}));
        }
        if (role != null) {
            ManagedProperty mappedRoleNames = managedPolicy.getProperty("mappedRoleNames");
            CollectionValueSupport roleCollection = (CollectionValueSupport)mappedRoleNames.getValue();
            ArrayList<Object> modifiedRoleNames = new ArrayList<Object>();
            if (roleCollection != null) {
                MetaValue[] roleNames;
                for (MetaValue mv : roleNames = roleCollection.getElements()) {
                    String existing = (String)((Object)((SimpleValueSupport)mv).getValue());
                    if (existing.equals(role)) continue;
                    modifiedRoleNames.add(mv);
                }
            } else {
                roleCollection = new CollectionValueSupport(new CollectionMetaType("java.util.List", (MetaType)SimpleMetaType.STRING));
                mappedRoleNames.setValue((MetaValue)roleCollection);
            }
            if (add) {
                modifiedRoleNames.add(ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, role));
            }
            roleCollection.setElements(modifiedRoleNames.toArray(new MetaValue[modifiedRoleNames.size()]));
        } else {
            ManagedProperty anyAuthenticated = managedPolicy.getProperty("anyAuthenticated");
            anyAuthenticated.setValue((MetaValue)SimpleValueSupport.wrap((boolean)add));
        }
        try {
            this.getView().updateComponent(mc);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void addDataRoleMapping(String vdbName, int vdbVersion, String policyName, String role) throws AdminException {
        this.manageRoleToDataPolicy(vdbName, vdbVersion, policyName, role, true);
    }

    public void removeDataRoleMapping(String vdbName, int vdbVersion, String policyName, String role) throws AdminException {
        this.manageRoleToDataPolicy(vdbName, vdbVersion, policyName, role, false);
    }

    public void setAnyAuthenticatedForDataRole(String vdbName, int vdbVersion, String dataRole, boolean anyAuthenticated) throws AdminException {
        this.manageRoleToDataPolicy(vdbName, vdbVersion, dataRole, null, anyAuthenticated);
    }

    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            ManagedUtil.executeOperation((ManagedCommon)mc, "mergeVDBs", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)sourceVDBName)), SimpleValueSupport.wrap((int)sourceVDBVersion), SimpleValueSupport.wrap((Serializable)((Object)targetVDBName)), SimpleValueSupport.wrap((int)targetVDBVersion)});
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    private ManagedComponent getDatasource(String deployedName) throws Exception {
        ComponentType ct;
        ManagedComponent mc = null;
        for (String type : DS_TYPES) {
            ct = new ComponentType("DataSource", type);
            mc = this.getView().getComponent(deployedName, ct);
            if (mc == null) continue;
            return mc;
        }
        for (String type : CF_TYPES) {
            ct = new ComponentType("ConnectionFactory", type);
            mc = this.getView().getComponent(deployedName, ct);
            if (mc == null) continue;
            return mc;
        }
        return mc;
    }

    public void createDataSource(String deploymentName, String templateName, Properties properties) throws AdminException {
        try {
            ManagedComponent mc = this.getDatasource(deploymentName);
            if (mc != null) {
                throw new AdminProcessingException(IntegrationPlugin.Util.getString("datasource_exists", new Object[]{deploymentName}));
            }
            DeploymentTemplateInfo info = this.getView().getTemplate(templateName);
            if (info == null) {
                throw new AdminProcessingException(IntegrationPlugin.Util.getString("datasource_template_not_found", new Object[]{templateName}));
            }
            Map propertyMap = info.getProperties();
            for (String key : properties.stringPropertyNames()) {
                ManagedProperty mp = (ManagedProperty)propertyMap.get(key);
                if (mp == null) continue;
                String value = properties.getProperty(key);
                if (ManagedUtil.sameValue(mp.getDefaultValue(), value)) continue;
                mp.setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)value)));
            }
            ((ManagedProperty)info.getProperties().get("jndi-name")).setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)deploymentName)));
            this.getView().applyTemplate(deploymentName, info);
        }
        catch (NoSuchDeploymentException e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDataSource(String deployedName) throws AdminException {
        try {
            ManagedComponent mc = this.getDatasource(deployedName);
            if (mc != null) {
                ManagedUtil.removeArchive(this.getDeploymentManager(), mc.getDeployment().getName());
            }
        }
        catch (Exception e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public Collection<String> getDataSourceNames() throws AdminException {
        ArrayList<String> names = new ArrayList<String>();
        try {
            Set mcs;
            ComponentType ct;
            for (String type : DS_TYPES) {
                ct = new ComponentType("DataSource", type);
                mcs = this.getView().getComponentsForType(ct);
                for (ManagedComponent mc : mcs) {
                    names.add(((SimpleValue)mc.getProperty("jndi-name").getValue()).getValue().toString());
                }
            }
            for (String type : CF_TYPES) {
                ct = new ComponentType("ConnectionFactory", type);
                mcs = this.getView().getComponentsForType(ct);
                for (ManagedComponent mc : mcs) {
                    names.add(((SimpleValue)mc.getProperty("jndi-name").getValue()).getValue().toString());
                }
            }
        }
        catch (Exception e) {
            throw new AdminComponentException((Throwable)e);
        }
        return names;
    }

    public Set<String> getDataSourceTemplateNames() throws AdminException {
        Set names = this.getView().getTemplateNames();
        HashSet<String> matched = new HashSet<String>();
        for (String name : names) {
            if (!name.startsWith(CONNECTOR_PREFIX)) continue;
            matched.add(name);
        }
        return matched;
    }

    public CacheStatistics getCacheStats(String cacheType) throws AdminException {
        try {
            ManagedComponent mc = this.getView().getComponent(DQPNAME, DQPTYPE);
            MetaValue value = ManagedUtil.executeOperation((ManagedCommon)mc, "getCacheStatistics", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)cacheType))});
            return (CacheStatistics)MetaValueFactory.getInstance().unwrap(value, CacheStatisticsMetadata.class);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        VFS.init();
    }
}

