/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.Serializable;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SubjectInfo;
import org.teiid.core.util.Assertion;
import org.teiid.jboss.SecurityActions;
import org.teiid.security.SecurityHelper;

public class JBossSecurityHelper
implements SecurityHelper,
Serializable {
    private static final long serialVersionUID = 3598997061994110254L;

    public boolean assosiateSecurityContext(String securityDomain, Object newContext) {
        SecurityContext context = SecurityActions.getSecurityContext();
        if (context == null || !context.getSecurityDomain().equals(securityDomain) && newContext != null) {
            SecurityActions.setSecurityContext((SecurityContext)newContext);
            return true;
        }
        return false;
    }

    public void clearSecurityContext(String securityDomain) {
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null && sc.getSecurityDomain().equals(securityDomain)) {
            SecurityActions.clearSecurityContext();
        }
    }

    public Object getSecurityContext(String securityDomain) {
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null && sc.getSecurityDomain().equals(securityDomain)) {
            return sc;
        }
        return null;
    }

    public Object createSecurityContext(String securityDomain, Principal p, Object credentials, Subject subject) {
        SecurityActions.pushSecurityContext(p, credentials, subject, securityDomain);
        return this.getSecurityContext(securityDomain);
    }

    public Subject getSubjectInContext(String securityDomain) {
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null && sc.getSecurityDomain().equals(securityDomain)) {
            SubjectInfo si = sc.getSubjectInfo();
            Subject subject = si.getAuthenticatedSubject();
            return subject;
        }
        return null;
    }

    public boolean sameSubject(String securityDomain, Object context, Subject subject) {
        Subject currentUser;
        Assertion.isNotNull((Object)context);
        SecurityContext previousContext = (SecurityContext)context;
        Subject previousUser = previousContext.getSubjectInfo().getAuthenticatedSubject();
        SecurityContext currentContext = SecurityActions.getSecurityContext();
        return currentContext != null && currentContext.getSecurityDomain().equals(securityDomain) && previousUser.equals(currentUser = currentContext.getSubjectInfo().getAuthenticatedSubject());
    }
}

