/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.deployers;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.security.auth.login.LoginException;
import javax.transaction.TransactionManager;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.util.naming.Util;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.DQPManagement;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.adminapi.jboss.AdminProvider;
import org.teiid.cache.CacheFactory;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.TransactionServerImpl;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.Log4jListener;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

@ManagementObject(name="RuntimeEngineDeployer", isRuntime=true, componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class RuntimeEngineDeployer
extends DQPConfiguration
implements DQPManagement,
Serializable,
ClientServiceRegistry {
    private static final long serialVersionUID = -4676205340262775388L;
    private transient SocketConfiguration jdbcSocketConfiguration;
    private transient SocketConfiguration adminSocketConfiguration;
    private transient SocketConfiguration odbcSocketConfiguration;
    private transient SocketListener jdbcSocket;
    private transient SocketListener adminSocket;
    private transient SocketListener odbcSocket;
    private transient TransactionServerImpl transactionServerImpl = new TransactionServerImpl();
    private transient DQPCore dqpCore = new DQPCore();
    private transient SessionService sessionService;
    private transient ILogon logon;
    private transient Admin admin;
    private transient ClientServiceRegistryImpl csr = new ClientServiceRegistryImpl();
    private transient VDBRepository vdbRepository;
    private transient ProfileService profileService;
    private transient String jndiName;

    public RuntimeEngineDeployer() {
        LogManager.setLogListener((Logger)new Log4jListener());
    }

    public <T> T getClientService(Class<T> iface) throws ComponentNotFoundException {
        return (T)this.csr.getClientService(iface);
    }

    public SecurityHelper getSecurityHelper() {
        return this.csr.getSecurityHelper();
    }

    public void start() {
        this.dqpCore.setTransactionService((TransactionService)LogManager.createLoggingProxy((String)"org.teiid.TXN_LOG", (Object)this.transactionServerImpl, (Class[])new Class[]{TransactionService.class}, (int)5));
        this.createClientServices();
        int offset = 0;
        String portBinding = System.getProperty("jboss.service.binding.set");
        if (portBinding != null && portBinding.startsWith("ports-")) {
            if (portBinding.equals("ports-default")) {
                offset = 0;
            } else {
                try {
                    offset = Integer.parseInt(portBinding.substring(portBinding.length() - 2)) * 100;
                }
                catch (NumberFormatException e) {
                    offset = 0;
                }
            }
        }
        this.csr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        DQP dqpProxy = (DQP)this.proxyService(DQP.class, this.dqpCore, "org.teiid.PROCESSOR");
        this.csr.registerClientService(DQP.class, (Object)dqpProxy, "org.teiid.PROCESSOR");
        Admin adminProxy = this.proxyService(Admin.class, this.admin, "org.teiid.ADMIN_API");
        this.csr.registerClientService(Admin.class, (Object)adminProxy, "org.teiid.ADMIN_API");
        ClientServiceRegistryImpl jdbcCsr = new ClientServiceRegistryImpl();
        jdbcCsr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        jdbcCsr.registerClientService(DQP.class, (Object)dqpProxy, "org.teiid.PROCESSOR");
        if (this.jdbcSocketConfiguration.getEnabled()) {
            this.jdbcSocket = new SocketListener(this.jdbcSocketConfiguration, jdbcCsr, (StorageManager)this.dqpCore.getBufferManager(), offset);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_enabled", new Object[]{"Teiid JDBC = ", (this.jdbcSocketConfiguration.getSSLConfiguration().isSslEnabled() ? "mms://" : "mm://") + this.jdbcSocketConfiguration.getHostAddress().getHostName() + ":" + (this.jdbcSocketConfiguration.getPortNumber() + offset)}));
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_not_enabled", new Object[]{"jdbc connections"}));
        }
        ClientServiceRegistryImpl adminCsr = new ClientServiceRegistryImpl(ClientServiceRegistry.Type.Admin);
        adminCsr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        adminCsr.registerClientService(Admin.class, (Object)adminProxy, "org.teiid.ADMIN_API");
        if (this.adminSocketConfiguration.getEnabled()) {
            this.adminSocket = new SocketListener(this.adminSocketConfiguration, adminCsr, (StorageManager)this.dqpCore.getBufferManager(), offset);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_enabled", new Object[]{"Teiid Admin", (this.adminSocketConfiguration.getSSLConfiguration().isSslEnabled() ? "mms://" : "mm://") + this.adminSocketConfiguration.getHostAddress().getHostName() + ":" + (this.adminSocketConfiguration.getPortNumber() + offset)}));
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_not_enabled", new Object[]{"admin connections"}));
        }
        if (this.odbcSocketConfiguration.getEnabled()) {
            this.vdbRepository.odbcEnabled();
            this.odbcSocket = new ODBCSocketListener(this.odbcSocketConfiguration, (StorageManager)this.dqpCore.getBufferManager(), offset);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("odbc_enabled", new Object[]{"Teiid ODBC - SSL=", (this.odbcSocketConfiguration.getSSLConfiguration().isSslEnabled() ? "ON" : "OFF") + " Host = " + this.odbcSocketConfiguration.getHostAddress().getHostName() + " Port = " + (this.odbcSocketConfiguration.getPortNumber() + offset)}));
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("odbc_not_enabled"));
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("engine_started", new Object[]{this.getRuntimeVersion(), new Date(System.currentTimeMillis()).toString()}));
        if (this.jndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Util.bind((Context)ic, (String)this.jndiName, (Object)this);
            }
            catch (NamingException ne) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)ne, (String)IntegrationPlugin.Util.getString("jndi_failed", new Object[]{new Date(System.currentTimeMillis()).toString()}));
            }
        }
        this.vdbRepository.addListener(new VDBLifeCycleListener(){

            public void removed(String name, int version) {
            }

            public void added(String name, int version) {
                try {
                    Collection sessions = RuntimeEngineDeployer.this.sessionService.getActiveSessions();
                    for (SessionMetadata session : sessions) {
                        if (!name.equalsIgnoreCase(session.getVDBName()) || version != session.getVDBVersion()) continue;
                        RuntimeEngineDeployer.this.sessionService.terminateSession(session.getSessionId(), null);
                    }
                }
                catch (SessionServiceException sessionServiceException) {
                    // empty catch block
                }
                RuntimeEngineDeployer.this.dqpCore.clearCache(Admin.Cache.PREPARED_PLAN_CACHE.toString(), name, version);
                RuntimeEngineDeployer.this.dqpCore.clearCache(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString(), name, version);
            }
        });
    }

    public void stop() {
        if (this.jndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Util.unbind((Context)ic, (String)this.jndiName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        try {
            this.dqpCore.stop();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        if (this.jdbcSocket != null) {
            this.jdbcSocket.stop();
            this.jdbcSocket = null;
        }
        if (this.adminSocket != null) {
            this.adminSocket.stop();
            this.adminSocket = null;
        }
        if (this.odbcSocket != null) {
            this.odbcSocket.stop();
            this.odbcSocket = null;
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("engine_stopped", new Object[]{new Date(System.currentTimeMillis()).toString()}));
    }

    private void createClientServices() {
        this.dqpCore.start((DQPConfiguration)this);
        this.logon = new LogonImpl(this.sessionService, "teiid-cluster");
        if (this.profileService != null) {
            this.admin = AdminProvider.getLocal(this.profileService);
        } else {
            try {
                this.admin = AdminProvider.getLocal();
            }
            catch (AdminComponentException e) {
                throw new TeiidRuntimeException(e.getCause());
            }
        }
    }

    private <T> T proxyService(Class<T> iface, T instance, String context) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new LogManager.LoggingProxy(instance, context, 6){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Throwable exception = null;
                try {
                    RuntimeEngineDeployer.this.sessionService.validateSession(DQPWorkContext.getWorkContext().getSessionId());
                    return super.invoke(proxy, method, args);
                }
                catch (InvocationTargetException e) {
                    exception = e.getTargetException();
                }
                catch (Throwable t) {
                    exception = t;
                }
                throw ExceptionUtil.convertException((Method)method, (Throwable)exception);
            }
        }));
    }

    public void setJdbcSocketConfiguration(SocketConfiguration socketConfig) {
        this.jdbcSocketConfiguration = socketConfig;
    }

    public void setAdminSocketConfiguration(SocketConfiguration socketConfig) {
        this.adminSocketConfiguration = socketConfig;
    }

    public void setOdbcSocketConfiguration(SocketConfiguration socketConfig) {
        this.odbcSocketConfiguration = socketConfig;
    }

    public void setXATerminator(XATerminator xaTerminator) {
        this.transactionServerImpl.setXaTerminator(xaTerminator);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionServerImpl.setTransactionManager(transactionManager);
    }

    public void setWorkManager(WorkManager mgr) {
        this.transactionServerImpl.setWorkManager(mgr);
    }

    public void setSessionService(SessionService service) {
        this.sessionService = service;
        service.setDqp(this.dqpCore);
    }

    public void setBufferService(BufferService service) {
        this.dqpCore.setBufferService(service);
    }

    public void setSecurityHelper(SecurityHelper helper) {
        this.csr.setSecurityHelper(helper);
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @ManagementOperation(description="Requests for perticular session", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="sessionId", description="The session Identifier")})
    public List<RequestMetadata> getRequestsForSession(String sessionId) {
        return this.dqpCore.getRequestsForSession(sessionId);
    }

    @ManagementOperation(description="Requests using a certain VDB", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="vdbName", description="VDB Name"), @ManagementParameter(name="vdbVersion", description="VDB Version")})
    public List<RequestMetadata> getRequestsUsingVDB(String vdbName, int vdbVersion) throws AdminException {
        ArrayList<RequestMetadata> requests = new ArrayList<RequestMetadata>();
        try {
            Collection sessions = this.sessionService.getActiveSessions();
            for (SessionMetadata session : sessions) {
                if (!session.getVDBName().equals(vdbName) || session.getVDBVersion() != vdbVersion) continue;
                requests.addAll(this.dqpCore.getRequestsForSession(session.getSessionId()));
            }
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return requests;
    }

    @ManagementOperation(description="Active requests", impact=ManagedOperation.Impact.ReadOnly)
    public List<RequestMetadata> getRequests() {
        return this.dqpCore.getRequests();
    }

    @ManagementOperation(description="Long running requests", impact=ManagedOperation.Impact.ReadOnly)
    public List<RequestMetadata> getLongRunningRequests() {
        return this.dqpCore.getLongRunningRequests();
    }

    @ManagementOperation(description="Get thread statistics worker pool", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="identifier", description="Get thread statistics worker pool")})
    public WorkerPoolStatisticsMetadata getWorkerPoolStatistics() {
        return this.dqpCore.getWorkerPoolStatistics();
    }

    @ManagementOperation(description="Terminate a Session", params={@ManagementParameter(name="terminateeId", description="The session to be terminated")})
    public void terminateSession(String terminateeId) {
        this.sessionService.terminateSession(terminateeId, DQPWorkContext.getWorkContext().getSessionId());
    }

    @ManagementOperation(description="Cancel a Request", params={@ManagementParameter(name="sessionId", description="The session Identifier"), @ManagementParameter(name="executionId", description="The Execution Identifier")})
    public boolean cancelRequest(String sessionId, long executionId) throws AdminException {
        try {
            return this.dqpCore.cancelRequest(sessionId, executionId);
        }
        catch (TeiidComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @ManagementOperation(description="Get Cache types in the system", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<String> getCacheTypes() {
        return this.dqpCore.getCacheTypes();
    }

    @ManagementOperation(description="Clear the caches in the system", impact=ManagedOperation.Impact.ReadOnly)
    public void clearCache(String cacheType) {
        this.dqpCore.clearCache(cacheType);
    }

    @ManagementOperation(description="Clear the caches in the system for a VDB", params={@ManagementParameter(name="cacheType", description="Type of Cache"), @ManagementParameter(name="vdbName", description="VDB Name"), @ManagementParameter(name="version", description="VDB Version")}, impact=ManagedOperation.Impact.ReadOnly)
    public void clearCache(String cacheType, String vdbName, int version) {
        this.dqpCore.clearCache(cacheType, vdbName, version);
    }

    @ManagementOperation(description="Get the cache statistics", impact=ManagedOperation.Impact.ReadOnly)
    public CacheStatisticsMetadata getCacheStatistics(String cacheType) {
        return this.dqpCore.getCacheStatistics(cacheType);
    }

    @ManagementOperation(description="Active sessions", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<SessionMetadata> getActiveSessions() throws AdminException {
        try {
            return this.sessionService.getActiveSessions();
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @ManagementProperty(description="Active session count", use={ViewUse.STATISTIC}, readOnly=true)
    public int getActiveSessionsCount() throws AdminException {
        try {
            return this.sessionService.getActiveSessionsCount();
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @ManagementOperation(description="Active Transactions", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<Transaction> getTransactions() {
        return this.dqpCore.getTransactions();
    }

    @ManagementOperation(description="Terminate the transaction", impact=ManagedOperation.Impact.ReadOnly)
    public void terminateTransaction(String xid) throws AdminException {
        this.dqpCore.terminateTransaction(xid);
    }

    @ManagementOperation(description="Merge Two VDBs", params={@ManagementParameter(name="sourceVDBName"), @ManagementParameter(name="sourceVDBName"), @ManagementParameter(name="targetVDBName"), @ManagementParameter(name="targetVDBVersion")})
    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        this.vdbRepository.mergeVDBs(sourceVDBName, sourceVDBVersion, targetVDBName, targetVDBVersion);
    }

    public void setCacheFactory(CacheFactory factory) {
        this.dqpCore.setCacheFactory(factory);
    }

    @ManagementOperation(description="Execute a sql query", params={@ManagementParameter(name="vdbName"), @ManagementParameter(name="vdbVersion"), @ManagementParameter(name="command"), @ManagementParameter(name="timoutInMilli")})
    public List<List> executeQuery(String vdbName, int version, final String command, final long timoutInMilli) throws AdminException {
        Properties properties = new Properties();
        properties.setProperty("VirtualDatabaseName", vdbName);
        properties.setProperty("VirtualDatabaseVersion", String.valueOf(version));
        String user = "JOPR ADMIN";
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{IntegrationPlugin.Util.getString("admin_executing", new Object[]{user, command})});
        SessionMetadata session = null;
        try {
            session = this.sessionService.createSession(user, null, "JOPR", properties, false, false);
        }
        catch (SessionServiceException e1) {
            throw new AdminProcessingException((Throwable)e1);
        }
        catch (LoginException e1) {
            throw new AdminProcessingException((Throwable)e1);
        }
        long requestID = 0L;
        DQPWorkContext context = new DQPWorkContext();
        context.setSession(session);
        try {
            List list = (List)context.runInContext((Callable)new Callable<List<List>>(){

                @Override
                public List<List> call() throws Exception {
                    long elapsed;
                    ArrayList<List> results = new ArrayList<List>();
                    long start = System.currentTimeMillis();
                    RequestMessage request = new RequestMessage(command);
                    request.setExecutionId(0L);
                    request.setRowLimit(RuntimeEngineDeployer.this.getMaxRowsFetchSize());
                    ResultsFuture message = RuntimeEngineDeployer.this.dqpCore.executeRequest(0L, request);
                    ResultsMessage rm = (ResultsMessage)message.get(timoutInMilli, TimeUnit.MILLISECONDS);
                    if (rm.getException() != null) {
                        throw new AdminProcessingException((Throwable)rm.getException());
                    }
                    if (rm.isUpdateResult()) {
                        results.addAll(new ArrayList<String>(Arrays.asList("update count")));
                        results.addAll(Arrays.asList(rm.getResults()));
                    } else {
                        results.addAll(new ArrayList<String>(Arrays.asList(rm.getColumnNames())));
                        results.addAll(Arrays.asList(RuntimeEngineDeployer.this.fixResults(rm.getResults())));
                        while (rm.getFinalRow() == -1 || rm.getLastRow() < rm.getFinalRow()) {
                            elapsed = System.currentTimeMillis() - start;
                            message = RuntimeEngineDeployer.this.dqpCore.processCursorRequest(0L, rm.getLastRow() + 1, 1024);
                            rm = (ResultsMessage)message.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                            results.addAll(Arrays.asList(RuntimeEngineDeployer.this.fixResults(rm.getResults())));
                        }
                    }
                    elapsed = System.currentTimeMillis() - start;
                    ResultsFuture response = RuntimeEngineDeployer.this.dqpCore.closeRequest(0L);
                    response.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                    return results;
                }
            });
            return list;
        }
        catch (Throwable t) {
            throw new AdminProcessingException(t);
        }
        finally {
            try {
                this.sessionService.closeSession(session.getSessionId());
            }
            catch (InvalidSessionException e) {}
        }
    }

    List[] fixResults(List[] rows) throws SQLException {
        List[] newResults = new List[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            List row = rows[i];
            ArrayList<String> newRow = new ArrayList<String>();
            for (Object col : row) {
                if (col == null) {
                    newRow.add("null");
                    continue;
                }
                if (col instanceof Number || col instanceof String || col instanceof Character) {
                    newRow.add((String)col);
                    continue;
                }
                if (col instanceof Blob) {
                    newRow.add("blob");
                    continue;
                }
                if (col instanceof Clob) {
                    newRow.add("clob");
                    continue;
                }
                if (col instanceof SQLXML) {
                    SQLXML xml = (SQLXML)col;
                    newRow.add(xml.getString());
                    continue;
                }
                newRow.add(col.toString());
            }
            newResults[i] = newRow;
        }
        return newResults;
    }
}

