/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.cci.ConnectionFactory;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.virtual.VirtualFile;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.jboss.ManagedUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.templates.connector.ConnectorTemplateInfo;
import org.teiid.templates.connector.RaXmlPropertyConverter;

public class ConnectorDeploymentTemplate
implements DeploymentTemplate {
    private DeploymentTemplateInfo info;
    private DeploymentTemplate targetTemplate;
    private static final String FILE_SUFFIX = "-ds.xml";

    public String getDeploymentName(String deploymentBaseName) {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null base name.");
        }
        if (!deploymentBaseName.endsWith(FILE_SUFFIX)) {
            deploymentBaseName = deploymentBaseName + FILE_SUFFIX;
        }
        return deploymentBaseName;
    }

    public VirtualFile applyTemplate(DeploymentTemplateInfo sourceInfo) throws Exception {
        try {
            DeploymentTemplateInfo targetInfo = this.targetTemplate.getInfo();
            ((ManagedProperty)targetInfo.getProperties().get("connection-definition")).setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)ConnectionFactory.class.getName())));
            ((ManagedProperty)targetInfo.getProperties().get("rar-name")).setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)((ConnectorTemplateInfo)this.getInfo()).getRarName())));
            List<String> connectorPropNames = RaXmlPropertyConverter.getPropertyNames(((ConnectorTemplateInfo)this.getInfo()).getRarName());
            Map<String, String> configProps = ConnectorDeploymentTemplate.propertiesAsMap(sourceInfo, connectorPropNames.toArray(new String[connectorPropNames.size()]), this.info.getName());
            configProps.put("template-name", this.getInfo().getName());
            Map propertyMap = targetInfo.getProperties();
            for (String key : sourceInfo.getProperties().keySet()) {
                ManagedProperty mp = (ManagedProperty)propertyMap.get(key);
                if (mp != null) {
                    MetaValue value = ((ManagedProperty)sourceInfo.getProperties().get(key)).getValue();
                    if (ManagedUtil.sameValue(mp.getDefaultValue(), value) || value == null) continue;
                    mp.setValue(value);
                    continue;
                }
                mp = (ManagedProperty)sourceInfo.getProperties().get(key);
                if (ManagedUtil.sameValue(mp.getDefaultValue(), mp.getValue()) || mp.getValue() == null) continue;
                configProps.put(key, ManagedUtil.stringValue(mp.getValue()));
                configProps.put(key + ".type", mp.getValue().getMetaType().getClassName());
            }
            if (configProps.size() > 0) {
                MapCompositeValueSupport metaValue = ManagedUtil.compositeValueMap(configProps);
                ((ManagedProperty)targetInfo.getProperties().get("config-property")).setValue((MetaValue)metaValue);
            }
            return this.targetTemplate.applyTemplate(targetInfo);
        }
        catch (NoSuchDeploymentException e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new AdminComponentException(e.getMessage(), (Throwable)e);
        }
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    public void setTargetTemplate(DeploymentTemplate target) {
        this.targetTemplate = target;
    }

    static Map<String, String> propertiesAsMap(DeploymentTemplateInfo values, String[] names, String templateName) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        Map sourceProperties = values.getProperties();
        for (String name : names) {
            ManagedProperty mp = (ManagedProperty)sourceProperties.remove(name);
            if (mp == null) continue;
            if (mp.getValue() != null) {
                props.put(name, ManagedUtil.stringValue(mp.getValue()));
                continue;
            }
            if (!mp.isMandatory()) continue;
            if (mp.getDefaultValue() != null) {
                props.put(name, ManagedUtil.stringValue(mp.getDefaultValue()));
                continue;
            }
            throw new AdminComponentException(IntegrationPlugin.Util.getString("property_required_not_found", new Object[]{mp.getName(), templateName}));
        }
        return props;
    }
}

