/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.resource.deployers.management.DsDataSourceTemplateInfo;
import org.teiid.adminapi.jboss.ExtendedPropertyInfo;
import org.teiid.adminapi.jboss.ManagedUtil;
import org.teiid.deployers.ManagedPropertyUtil;
import org.teiid.templates.connector.ConnectorTemplateInfo;

public class LocalJdbcConnectorTemplateInfo
extends DsDataSourceTemplateInfo
implements ExtendedPropertyInfo {
    private static final long serialVersionUID = 7618814758011974868L;
    static final String ADDITIONAL_CONNECTION_PROPS = "addtional-connection-properties";

    public LocalJdbcConnectorTemplateInfo(String name, String description, Map<String, ManagedProperty> properties) {
        super(name, description, properties);
    }

    public void start() {
        this.populate();
    }

    public LocalJdbcConnectorTemplateInfo copy() {
        LocalJdbcConnectorTemplateInfo copy = new LocalJdbcConnectorTemplateInfo(this.getName(), this.getDescription(), this.getProperties());
        super.copy((BasicDeploymentTemplateInfo)copy);
        copy.populate();
        return copy;
    }

    private void populate() {
        super.start();
        ManagedProperty mp = (ManagedProperty)this.getProperties().get("connection-definition");
        mp.setValue((MetaValue)ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, "javax.sql.DataSource"));
        mp = (ManagedProperty)this.getProperties().get("dsType");
        mp.setValue((MetaValue)ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, "local-tx-datasource"));
        ManagedPropertyImpl dsTypeMP = LocalJdbcConnectorTemplateInfo.buildConfigProperty();
        this.addProperty((ManagedProperty)dsTypeMP);
        this.addProperty(ConnectorTemplateInfo.buildTemplateProperty(this.getName()));
        ManagedPropertyUtil.markAsTeiidProperty((ManagedProperty)((ManagedProperty)this.getProperties().get("user-name")));
        ManagedPropertyUtil.markAsTeiidProperty((ManagedProperty)((ManagedProperty)this.getProperties().get("password")));
        ManagedPropertyUtil.markAsTeiidProperty((ManagedProperty)((ManagedProperty)this.getProperties().get("driver-class")));
        ManagedPropertyUtil.markAsTeiidProperty((ManagedProperty)((ManagedProperty)this.getProperties().get("connection-url")));
        this.addProperty(ManagedPropertyUtil.createProperty((String)ADDITIONAL_CONNECTION_PROPS, (MetaType)SimpleMetaType.STRING, (String)"Addtional Connection Properties", (String)"Addtional Connection properties. (comma separated name value pairs)", (boolean)false, (boolean)false, null));
    }

    static ManagedPropertyImpl buildConfigProperty() {
        DefaultFieldsImpl fields = new DefaultFieldsImpl("config-property");
        fields.setDescription("The config-property type");
        fields.setMetaType((MetaType)new MapCompositeMetaType((MetaType)SimpleMetaType.STRING));
        ManagedPropertyImpl dsTypeMP = new ManagedPropertyImpl((Fields)fields);
        return dsTypeMP;
    }

    @Override
    public void updateProperty(String name, String value, ManagedComponent main) {
        if (name.equals(ADDITIONAL_CONNECTION_PROPS)) {
            HashMap<String, String> map = new HashMap<String, String>();
            LocalJdbcConnectorTemplateInfo.parseProperties(value, map);
            MapCompositeValueSupport previousValues = (MapCompositeValueSupport)main.getProperty("connection-properties").getValue();
            if (previousValues != null) {
                for (String key : map.keySet()) {
                    previousValues.put(key, (MetaValue)SimpleValueSupport.wrap((Serializable)((Serializable)map.get(key))));
                }
            }
        }
    }

    static void parseProperties(String str, Map<String, String> props) {
        str = str.trim();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String property = st.nextToken();
            int index = property.indexOf(61);
            if (index == -1 || property.length() <= index + 1) continue;
            props.put(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
    }
}

