/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.spi.DeploymentOption;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.jboss.IntegrationPlugin;

public class ManagedUtil {
    public static boolean sameValue(MetaValue v1, String v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        MetaType type = v1.getMetaType();
        if (v1 instanceof SimpleValue && type instanceof SimpleMetaType) {
            SimpleMetaType st = (SimpleMetaType)type;
            SimpleValue sv = ManagedUtil.wrap((MetaType)st, v2);
            return sv.compareTo((Object)((SimpleValue)v1)) == 0;
        }
        return false;
    }

    public static boolean sameValue(MetaValue v1, MetaValue v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1 instanceof SimpleValue && v2 instanceof SimpleValue) {
            return ((SimpleValue)v1).compareTo((Object)((SimpleValue)v2)) == 0;
        }
        return false;
    }

    public static MapCompositeValueSupport compositeValueMap(Map<String, String> map) {
        MapCompositeValueSupport metaValue = new MapCompositeValueSupport((MetaType)SimpleMetaType.STRING);
        for (String key : map.keySet()) {
            SimpleValue value = SimpleValueSupport.wrap((Serializable)((Serializable)((Object)map.get(key))));
            metaValue.put(key, (MetaValue)value);
        }
        return metaValue;
    }

    public static String stringValue(MetaValue v1) {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return simple.getValue().toString();
            }
            throw new TeiidRuntimeException("Failed to convert value to string value");
        }
        return null;
    }

    public static <T> T getSimpleValue(ManagedCommon mc, String prop, Class<T> expectedType) {
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null) {
            MetaType metaType = mp.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)mp.getValue();
                return expectedType.cast(simpleValue != null ? simpleValue.getValue() : null);
            }
            if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)mp.getValue();
                return expectedType.cast(enumValue != null ? enumValue.getValue() : null);
            }
            throw new IllegalArgumentException(prop + " is not a simple type");
        }
        return null;
    }

    public static Properties getPropertiesValue(ManagedCommon mc, String prop) {
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null) {
            MetaType metaType = mp.getMetaType();
            if (metaType.isProperties()) {
                return (PropertiesMetaValue)mp.getValue();
            }
            if (metaType.isComposite()) {
                Properties props = new Properties();
                MapCompositeValueSupport map = (MapCompositeValueSupport)mp.getValue();
                MapCompositeMetaType type = map.getMetaType();
                for (String key : type.keySet()) {
                    MetaValue value = map.get(key);
                    props.setProperty(key, ManagedUtil.stringValue(value));
                }
                return props;
            }
            throw new IllegalArgumentException(prop + " is not a properties type");
        }
        return null;
    }

    public static <T> void getCollectionValue(ManagedCommon mc, String prop, Collection<T> list, Class<T> expectedType) {
        MetaType metaType;
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null && (metaType = mp.getMetaType()).isCollection()) {
            CollectionValue collectionValue = (CollectionValue)mp.getValue();
            for (MetaValue value : collectionValue.getElements()) {
                if (!value.getMetaType().isSimple()) {
                    throw new IllegalArgumentException(prop + " is not a simple type");
                }
                SimpleValue simpleValue = (SimpleValue)value;
                list.add(expectedType.cast(simpleValue.getValue()));
            }
        }
    }

    public static EnumValue wrap(EnumMetaType type, String value) {
        return new EnumValueSupport(type, value);
    }

    public static SimpleValue wrap(MetaType type, String value) {
        if (type instanceof SimpleMetaType) {
            SimpleMetaType st = (SimpleMetaType)type;
            if (SimpleMetaType.BIGDECIMAL.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new BigDecimal(value));
            }
            if (SimpleMetaType.BIGINTEGER.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new BigInteger(value));
            }
            if (SimpleMetaType.BOOLEAN.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Boolean.valueOf(value));
            }
            if (SimpleMetaType.BOOLEAN_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Boolean.valueOf(value));
            }
            if (SimpleMetaType.BYTE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new Byte(value.getBytes()[0]));
            }
            if (SimpleMetaType.BYTE_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Byte.valueOf(value.getBytes()[0]));
            }
            if (SimpleMetaType.CHARACTER.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new Character(value.charAt(0)));
            }
            if (SimpleMetaType.CHARACTER_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Character.valueOf(value.charAt(0)));
            }
            if (SimpleMetaType.DATE.equals((Object)st)) {
                try {
                    return new SimpleValueSupport(st, (Serializable)SimpleDateFormat.getInstance().parse(value));
                }
                catch (ParseException e) {
                    throw new TeiidRuntimeException((Throwable)e, IntegrationPlugin.Util.getString("failed_to_convert", new Object[]{type.getClassName()}));
                }
            }
            if (SimpleMetaType.DOUBLE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Double.valueOf(value));
            }
            if (SimpleMetaType.DOUBLE_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Double.valueOf(Double.parseDouble(value)));
            }
            if (SimpleMetaType.FLOAT.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Float.valueOf(Float.parseFloat(value)));
            }
            if (SimpleMetaType.FLOAT_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Float.valueOf(value));
            }
            if (SimpleMetaType.INTEGER.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Integer.valueOf(value));
            }
            if (SimpleMetaType.INTEGER_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Integer.valueOf(Integer.parseInt(value)));
            }
            if (SimpleMetaType.LONG.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Long.valueOf(value));
            }
            if (SimpleMetaType.LONG_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Long.valueOf(Long.parseLong(value)));
            }
            if (SimpleMetaType.SHORT.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Short.valueOf(value));
            }
            if (SimpleMetaType.SHORT_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Short.valueOf(Short.parseShort(value)));
            }
            if (SimpleMetaType.STRING.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)((Object)value));
            }
        }
        throw new TeiidRuntimeException(IntegrationPlugin.Util.getString("failed_to_convert", new Object[]{type.getClassName()}));
    }

    public static void deployArchive(DeploymentManager deploymentManager, String fileName, InputStream resource, boolean deployExploded) throws AdminProcessingException {
        ManagedUtil.deployArchive(deploymentManager, fileName, ManagedUtil.getTempURL(resource), deployExploded);
    }

    public static void deployArchive(DeploymentManager deploymentManager, String fileName, URL resourceURL, boolean deployExploded) throws AdminProcessingException {
        ArrayList<DeploymentOption> deploymentOptions = new ArrayList<DeploymentOption>();
        if (deployExploded) {
            deploymentOptions.add(DeploymentOption.Explode);
        }
        DeploymentProgress progress = null;
        try {
            progress = deploymentManager.distribute(fileName, resourceURL, deploymentOptions.toArray(new DeploymentOption[deploymentOptions.size()]));
            ManagedUtil.execute(progress, IntegrationPlugin.Util.getString("distribute_failed", new Object[]{fileName}));
        }
        catch (Exception e) {
            ManagedUtil.handleException(e);
        }
        String[] deploymentNames = progress.getDeploymentID().getRepositoryNames();
        try {
            progress = deploymentManager.start(deploymentNames);
            ManagedUtil.execute(progress, IntegrationPlugin.Util.getString("deployment_start_failed", new Object[]{fileName}));
        }
        catch (Exception e) {
            try {
                ManagedUtil.execute(deploymentManager.remove(deploymentNames), IntegrationPlugin.Util.getString("failed_to_remove"));
            }
            catch (Exception e1) {
                ManagedUtil.handleException(e1);
            }
            ManagedUtil.handleException(e);
        }
    }

    static URL getTempURL(final InputStream resource) {
        try {
            return new URL(null, "temp:#temp", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return resource;
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e2) {
            throw new TeiidRuntimeException((Throwable)e2);
        }
    }

    public static void handleException(Exception e) throws AdminProcessingException {
        if (e instanceof AdminProcessingException) {
            throw (AdminProcessingException)e;
        }
        throw new AdminProcessingException(e.getMessage(), (Throwable)e);
    }

    public static void execute(DeploymentProgress progress, String errorMessage) throws AdminProcessingException {
        progress.run();
        DeploymentStatus status = progress.getDeploymentStatus();
        if (status.isFailed()) {
            if (status.getFailure() != null) {
                throw new AdminProcessingException(status.getFailure().getMessage(), (Throwable)status.getFailure());
            }
            throw new AdminProcessingException(errorMessage);
        }
    }

    public static void removeArchive(DeploymentManager deploymentManager, String ... deploymentNames) throws AdminProcessingException {
        try {
            ManagedUtil.execute(deploymentManager.stop(deploymentNames), IntegrationPlugin.Util.getString("failed_to_remove"));
            ManagedUtil.execute(deploymentManager.remove(deploymentNames), IntegrationPlugin.Util.getString("failed_to_remove"));
        }
        catch (Exception e) {
            ManagedUtil.handleException(e);
        }
    }

    public static MetaValue executeOperation(ManagedCommon mc, String operation, MetaValue ... args) {
        for (ManagedOperation mo : mc.getOperations()) {
            if (!mo.getName().equals(operation)) continue;
            return mo.invoke(args);
        }
        throw new TeiidRuntimeException(IntegrationPlugin.Util.getString("no_operation", new Object[]{operation}));
    }
}

