/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.teiid.deployers.ContainerLifeCycleListener;

public class JBossLifeCycleListener
extends ServiceMBeanSupport
implements NotificationListener,
ContainerLifeCycleListener {
    public final String START_NOTIFICATION_TYPE = "org.jboss.system.server.started";
    public final String STOP_NOTIFICATION_TYPE = "org.jboss.system.server.stopped";
    private boolean shutdownInProgress = false;
    private List<ContainerLifeCycleListener.LifeCycleEventListener> listeners = Collections.synchronizedList(new ArrayList());

    public JBossLifeCycleListener() {
        try {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName on = new ObjectName("jboss.system:type=Server");
            server.addNotificationListener(on, this, null, null);
        }
        catch (MalformedObjectNameException e) {
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            for (ContainerLifeCycleListener.LifeCycleEventListener l : this.listeners) {
                l.onStartupFinish();
            }
        }
        if (type.equals("org.jboss.system.server.stopped")) {
            this.shutdownInProgress = true;
            for (ContainerLifeCycleListener.LifeCycleEventListener l : this.listeners) {
                l.onShutdownStart();
            }
        }
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void addListener(ContainerLifeCycleListener.LifeCycleEventListener listener) {
        this.listeners.add(listener);
    }
}

