/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.deployers;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.security.auth.login.LoginException;
import javax.transaction.TransactionManager;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.util.naming.Util;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.DQPManagement;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.adminapi.jboss.AdminProvider;
import org.teiid.cache.CacheFactory;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.LRUCache;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.TransactionServerImpl;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.Log4jListener;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.DdlPlan;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.vdb.runtime.VDBKey;

@ManagementObject(name="RuntimeEngineDeployer", isRuntime=true, componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class RuntimeEngineDeployer
extends DQPConfiguration
implements DQPManagement,
Serializable,
ClientServiceRegistry,
EventDistributor,
EventDistributorFactory {
    private static final long serialVersionUID = -4676205340262775388L;
    private transient SocketConfiguration jdbcSocketConfiguration;
    private transient SocketConfiguration adminSocketConfiguration;
    private transient SocketConfiguration odbcSocketConfiguration;
    private transient SocketListener jdbcSocket;
    private transient SocketListener adminSocket;
    private transient SocketListener odbcSocket;
    private transient TransactionServerImpl transactionServerImpl = new TransactionServerImpl();
    private transient DQPCore dqpCore = new DQPCore();
    private transient SessionService sessionService;
    private transient ILogon logon;
    private transient Admin admin;
    private transient ClientServiceRegistryImpl csr = new ClientServiceRegistryImpl();
    private transient VDBRepository vdbRepository;
    private transient VDBStatusChecker vdbStatusChecker;
    private transient ProfileService profileService;
    private transient String jndiName;
    private String eventDistributorName;
    private transient EventDistributor eventDistributor;
    private transient EventDistributor eventDistributorProxy;
    private transient ContainerLifeCycleListener lifecycleListener;

    public RuntimeEngineDeployer() {
        LogManager.setLogListener((Logger)new Log4jListener());
    }

    public <T> T getClientService(Class<T> iface) throws ComponentNotFoundException {
        return (T)this.csr.getClientService(iface);
    }

    public SecurityHelper getSecurityHelper() {
        return this.csr.getSecurityHelper();
    }

    public void start() {
        this.dqpCore.setTransactionService((TransactionService)LogManager.createLoggingProxy((String)"org.teiid.TXN_LOG", (Object)this.transactionServerImpl, (Class[])new Class[]{TransactionService.class}, (int)5));
        if (this.eventDistributorName != null) {
            try {
                InitialContext ic = new InitialContext();
                this.eventDistributor = (EventDistributor)ic.lookup(this.eventDistributorName);
            }
            catch (NamingException ne) {
                LogManager.logDetail((String)"org.teiid.RUNTIME", (Throwable)ne, (Object[])new Object[]{IntegrationPlugin.Util.getString("jndi_failed", new Object[]{new Date(System.currentTimeMillis()).toString()})});
            }
        }
        this.dqpCore.setMetadataRepository(this.vdbRepository.getMetadataRepository());
        this.dqpCore.setEventDistributor(this.eventDistributor);
        this.dqpCore.start((DQPConfiguration)this);
        this.eventDistributorProxy = (EventDistributor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EventDistributor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                method.invoke((Object)RuntimeEngineDeployer.this, args);
                if (RuntimeEngineDeployer.this.eventDistributor != null) {
                    method.invoke((Object)RuntimeEngineDeployer.this.eventDistributor, args);
                }
                return null;
            }
        });
        this.createClientServices();
        int offset = 0;
        String portBinding = System.getProperty("jboss.service.binding.set");
        if (portBinding != null && portBinding.startsWith("ports-")) {
            if (portBinding.equals("ports-default")) {
                offset = 0;
            } else {
                try {
                    offset = Integer.parseInt(portBinding.substring(portBinding.length() - 2)) * 100;
                }
                catch (NumberFormatException e) {
                    offset = 0;
                }
            }
        }
        this.csr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        DQP dqpProxy = (DQP)this.proxyService(DQP.class, this.dqpCore, "org.teiid.PROCESSOR");
        this.csr.registerClientService(DQP.class, (Object)dqpProxy, "org.teiid.PROCESSOR");
        Admin adminProxy = this.proxyService(Admin.class, this.admin, "org.teiid.ADMIN_API");
        this.csr.registerClientService(Admin.class, (Object)adminProxy, "org.teiid.ADMIN_API");
        ClientServiceRegistryImpl jdbcCsr = new ClientServiceRegistryImpl();
        jdbcCsr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        jdbcCsr.registerClientService(DQP.class, (Object)dqpProxy, "org.teiid.PROCESSOR");
        if (this.jdbcSocketConfiguration.getEnabled()) {
            this.jdbcSocket = new SocketListener(this.jdbcSocketConfiguration, jdbcCsr, (StorageManager)this.dqpCore.getBufferManager(), offset);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_enabled", new Object[]{"Teiid JDBC = ", (this.jdbcSocketConfiguration.getSSLConfiguration().isSslEnabled() ? "mms://" : "mm://") + this.jdbcSocketConfiguration.getHostAddress().getHostName() + ":" + (this.jdbcSocketConfiguration.getPortNumber() + offset)}));
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_not_enabled", new Object[]{"jdbc connections"}));
        }
        ClientServiceRegistryImpl adminCsr = new ClientServiceRegistryImpl(ClientServiceRegistry.Type.Admin);
        adminCsr.registerClientService(ILogon.class, (Object)this.logon, "org.teiid.SECURITY");
        adminCsr.registerClientService(Admin.class, (Object)adminProxy, "org.teiid.ADMIN_API");
        if (this.adminSocketConfiguration.getEnabled()) {
            this.adminSocket = new SocketListener(this.adminSocketConfiguration, adminCsr, (StorageManager)this.dqpCore.getBufferManager(), offset);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_enabled", new Object[]{"Teiid Admin", (this.adminSocketConfiguration.getSSLConfiguration().isSslEnabled() ? "mms://" : "mm://") + this.adminSocketConfiguration.getHostAddress().getHostName() + ":" + (this.adminSocketConfiguration.getPortNumber() + offset)}));
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("socket_not_enabled", new Object[]{"admin connections"}));
        }
        if (this.odbcSocketConfiguration.getEnabled()) {
            this.vdbRepository.odbcEnabled();
            ODBCSocketListener odbc = new ODBCSocketListener(this.odbcSocketConfiguration, (StorageManager)this.dqpCore.getBufferManager(), offset, this.getMaxODBCLobSizeAllowed(), this.logon);
            odbc.setAuthenticationType(this.sessionService.getAuthType());
            this.odbcSocket = odbc;
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("odbc_enabled", new Object[]{"Teiid ODBC - SSL=", (this.odbcSocketConfiguration.getSSLConfiguration().isSslEnabled() ? "ON" : "OFF") + " Host = " + this.odbcSocketConfiguration.getHostAddress().getHostName() + " Port = " + (this.odbcSocketConfiguration.getPortNumber() + offset)}));
        } else {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("odbc_not_enabled"));
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("engine_started", new Object[]{this.getRuntimeVersion(), new Date(System.currentTimeMillis()).toString()}));
        if (this.jndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Util.bind((Context)ic, (String)this.jndiName, (Object)this);
            }
            catch (NamingException ne) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)ne, (String)IntegrationPlugin.Util.getString("jndi_failed", new Object[]{new Date(System.currentTimeMillis()).toString()}));
            }
        }
        this.vdbRepository.addListener(new VDBLifeCycleListener(){
            private Set<VDBKey> recentlyRemoved = Collections.newSetFromMap(new LRUCache(10000));

            public void removed(String name, int version) {
                this.recentlyRemoved.add(new VDBKey(name, version));
            }

            public void added(String name, int version) {
                if (!this.recentlyRemoved.remove(new VDBKey(name, version))) {
                    return;
                }
                try {
                    Collection sessions = RuntimeEngineDeployer.this.sessionService.getActiveSessions();
                    for (SessionMetadata session : sessions) {
                        if (!name.equalsIgnoreCase(session.getVDBName()) || version != session.getVDBVersion()) continue;
                        RuntimeEngineDeployer.this.sessionService.terminateSession(session.getSessionId(), null);
                    }
                }
                catch (SessionServiceException sessionServiceException) {
                    // empty catch block
                }
                RuntimeEngineDeployer.this.dqpCore.clearCache(Admin.Cache.PREPARED_PLAN_CACHE.toString(), name, version);
                RuntimeEngineDeployer.this.dqpCore.clearCache(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString(), name, version);
            }
        });
        this.synchronizeMaterializeViews();
    }

    public void stop() {
        if (this.jndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Util.unbind((Context)ic, (String)this.jndiName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        try {
            this.dqpCore.stop();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        if (this.jdbcSocket != null) {
            this.jdbcSocket.stop();
            this.jdbcSocket = null;
        }
        if (this.adminSocket != null) {
            this.adminSocket.stop();
            this.adminSocket = null;
        }
        if (this.odbcSocket != null) {
            this.odbcSocket.stop();
            this.odbcSocket = null;
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)IntegrationPlugin.Util.getString("engine_stopped", new Object[]{new Date(System.currentTimeMillis()).toString()}));
    }

    private void createClientServices() {
        this.logon = new LogonImpl(this.sessionService, "teiid-cluster");
        if (this.profileService != null) {
            this.admin = AdminProvider.getLocal(this.profileService, this.vdbStatusChecker);
        } else {
            try {
                this.admin = AdminProvider.getLocal(this.vdbStatusChecker);
            }
            catch (AdminComponentException e) {
                throw new TeiidRuntimeException(e.getCause());
            }
        }
    }

    private <T> T proxyService(Class<T> iface, T instance, String context) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new LogManager.LoggingProxy(instance, context, 6){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Throwable exception = null;
                try {
                    RuntimeEngineDeployer.this.sessionService.validateSession(DQPWorkContext.getWorkContext().getSessionId());
                    return super.invoke(proxy, method, args);
                }
                catch (InvocationTargetException e) {
                    exception = e.getTargetException();
                }
                catch (Throwable t) {
                    exception = t;
                }
                throw ExceptionUtil.convertException((Method)method, (Throwable)exception);
            }
        }));
    }

    public void setJdbcSocketConfiguration(SocketConfiguration socketConfig) {
        this.jdbcSocketConfiguration = socketConfig;
    }

    public void setAdminSocketConfiguration(SocketConfiguration socketConfig) {
        this.adminSocketConfiguration = socketConfig;
    }

    public void setOdbcSocketConfiguration(SocketConfiguration socketConfig) {
        this.odbcSocketConfiguration = socketConfig;
    }

    public void setXATerminator(XATerminator xaTerminator) {
        this.transactionServerImpl.setXaTerminator(xaTerminator);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionServerImpl.setTransactionManager(transactionManager);
    }

    public void setWorkManager(WorkManager mgr) {
        this.transactionServerImpl.setWorkManager(mgr);
    }

    public void setSessionService(SessionService service) {
        this.sessionService = service;
        service.setDqp(this.dqpCore);
    }

    public void setBufferService(BufferService service) {
        this.dqpCore.setBufferService(service);
    }

    public void setSecurityHelper(SecurityHelper helper) {
        this.csr.setSecurityHelper(helper);
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void setVDBStatusChecker(VDBStatusChecker vdbStatusChecker) {
        this.vdbStatusChecker = vdbStatusChecker;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @ManagementOperation(description="Requests for perticular session", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="sessionId", description="The session Identifier")})
    public List<RequestMetadata> getRequestsForSession(String sessionId) {
        return this.dqpCore.getRequestsForSession(sessionId);
    }

    @ManagementOperation(description="Requests using a certain VDB", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="vdbName", description="VDB Name"), @ManagementParameter(name="vdbVersion", description="VDB Version")})
    public List<RequestMetadata> getRequestsUsingVDB(String vdbName, int vdbVersion) throws AdminException {
        ArrayList<RequestMetadata> requests = new ArrayList<RequestMetadata>();
        try {
            Collection sessions = this.sessionService.getActiveSessions();
            for (SessionMetadata session : sessions) {
                if (!session.getVDBName().equals(vdbName) || session.getVDBVersion() != vdbVersion) continue;
                requests.addAll(this.dqpCore.getRequestsForSession(session.getSessionId()));
            }
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return requests;
    }

    @ManagementOperation(description="Active requests", impact=ManagedOperation.Impact.ReadOnly)
    public List<RequestMetadata> getRequests() {
        return this.dqpCore.getRequests();
    }

    @ManagementOperation(description="Long running requests", impact=ManagedOperation.Impact.ReadOnly)
    public List<RequestMetadata> getLongRunningRequests() {
        return this.dqpCore.getLongRunningRequests();
    }

    @ManagementOperation(description="Get thread statistics worker pool", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="identifier", description="Get thread statistics worker pool")})
    public WorkerPoolStatisticsMetadata getWorkerPoolStatistics() {
        return this.dqpCore.getWorkerPoolStatistics();
    }

    @ManagementOperation(description="Terminate a Session", params={@ManagementParameter(name="terminateeId", description="The session to be terminated")})
    public void terminateSession(String terminateeId) {
        this.sessionService.terminateSession(terminateeId, DQPWorkContext.getWorkContext().getSessionId());
    }

    @ManagementOperation(description="Cancel a Request", params={@ManagementParameter(name="sessionId", description="The session Identifier"), @ManagementParameter(name="executionId", description="The Execution Identifier")})
    public boolean cancelRequest(String sessionId, long executionId) throws AdminException {
        try {
            return this.dqpCore.cancelRequest(sessionId, executionId);
        }
        catch (TeiidComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @ManagementOperation(description="Get Cache types in the system", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<String> getCacheTypes() {
        return this.dqpCore.getCacheTypes();
    }

    @ManagementOperation(description="Clear the caches in the system", impact=ManagedOperation.Impact.ReadOnly)
    public void clearCache(String cacheType) {
        this.dqpCore.clearCache(cacheType);
    }

    @ManagementOperation(description="Clear the caches in the system for a VDB", params={@ManagementParameter(name="cacheType", description="Type of Cache"), @ManagementParameter(name="vdbName", description="VDB Name"), @ManagementParameter(name="version", description="VDB Version")}, impact=ManagedOperation.Impact.ReadOnly)
    public void clearCache(String cacheType, String vdbName, int version) {
        this.dqpCore.clearCache(cacheType, vdbName, version);
    }

    @ManagementOperation(description="Get the cache statistics", impact=ManagedOperation.Impact.ReadOnly)
    public CacheStatisticsMetadata getCacheStatistics(String cacheType) {
        return this.dqpCore.getCacheStatistics(cacheType);
    }

    @ManagementOperation(description="Active sessions", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<SessionMetadata> getActiveSessions() throws AdminException {
        try {
            return this.sessionService.getActiveSessions();
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @ManagementProperty(description="Active session count", use={ViewUse.STATISTIC}, readOnly=true)
    public int getActiveSessionsCount() throws AdminException {
        try {
            return this.sessionService.getActiveSessionsCount();
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    @ManagementOperation(description="Active Transactions", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<Transaction> getTransactions() {
        return this.dqpCore.getTransactions();
    }

    @ManagementOperation(description="Terminate the transaction", impact=ManagedOperation.Impact.ReadOnly)
    public void terminateTransaction(String xid) throws AdminException {
        this.dqpCore.terminateTransaction(xid);
    }

    @ManagementOperation(description="Merge Two VDBs", params={@ManagementParameter(name="sourceVDBName"), @ManagementParameter(name="sourceVDBName"), @ManagementParameter(name="targetVDBName"), @ManagementParameter(name="targetVDBVersion")})
    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        this.vdbRepository.mergeVDBs(sourceVDBName, sourceVDBVersion, targetVDBName, targetVDBVersion);
    }

    public void setCacheFactory(CacheFactory factory) {
        this.dqpCore.setCacheFactory(factory);
    }

    @ManagementOperation(description="Execute a sql query", params={@ManagementParameter(name="vdbName"), @ManagementParameter(name="vdbVersion"), @ManagementParameter(name="command"), @ManagementParameter(name="timoutInMilli")})
    public List<List> executeQuery(String vdbName, int version, final String command, final long timoutInMilli) throws AdminException {
        String user = "JOPR ADMIN";
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{IntegrationPlugin.Util.getString("admin_executing", new Object[]{user, command})});
        SessionMetadata session = this.createTemporarySession(vdbName, version, user);
        long requestID = 0L;
        DQPWorkContext context = new DQPWorkContext();
        context.setSession(session);
        try {
            List list = (List)context.runInContext((Callable)new Callable<List<List>>(){

                @Override
                public List<List> call() throws Exception {
                    long elapsed;
                    ArrayList<List> results = new ArrayList<List>();
                    long start = System.currentTimeMillis();
                    RequestMessage request = new RequestMessage(command);
                    request.setExecutionId(0L);
                    request.setRowLimit(RuntimeEngineDeployer.this.getMaxRowsFetchSize());
                    ResultsFuture message = RuntimeEngineDeployer.this.dqpCore.executeRequest(0L, request);
                    ResultsMessage rm = null;
                    rm = timoutInMilli < 0L ? (ResultsMessage)message.get() : (ResultsMessage)message.get(timoutInMilli, TimeUnit.MILLISECONDS);
                    if (rm.getException() != null) {
                        throw new AdminProcessingException((Throwable)rm.getException());
                    }
                    if (rm.isUpdateResult()) {
                        results.addAll(new ArrayList<String>(Arrays.asList("update count")));
                        results.addAll(Arrays.asList(rm.getResults()));
                    } else {
                        results.addAll(new ArrayList<String>(Arrays.asList(rm.getColumnNames())));
                        results.addAll(Arrays.asList(RuntimeEngineDeployer.this.fixResults(rm.getResults())));
                        while (rm.getFinalRow() == -1 || rm.getLastRow() < rm.getFinalRow()) {
                            elapsed = System.currentTimeMillis() - start;
                            message = RuntimeEngineDeployer.this.dqpCore.processCursorRequest(0L, rm.getLastRow() + 1, 1024);
                            rm = (ResultsMessage)message.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                            results.addAll(Arrays.asList(RuntimeEngineDeployer.this.fixResults(rm.getResults())));
                        }
                    }
                    elapsed = System.currentTimeMillis() - start;
                    ResultsFuture response = RuntimeEngineDeployer.this.dqpCore.closeRequest(0L);
                    response.get(timoutInMilli - elapsed, TimeUnit.MILLISECONDS);
                    return results;
                }
            });
            return list;
        }
        catch (Throwable t) {
            throw new AdminProcessingException(t);
        }
        finally {
            try {
                this.sessionService.closeSession(session.getSessionId());
            }
            catch (InvalidSessionException e) {}
        }
    }

    private SessionMetadata createTemporarySession(String vdbName, int version, String user) throws AdminProcessingException {
        Properties properties = new Properties();
        properties.setProperty("VirtualDatabaseName", vdbName);
        properties.setProperty("VirtualDatabaseVersion", String.valueOf(version));
        SessionMetadata session = null;
        try {
            session = this.sessionService.createSession(user, null, "JOPR", properties, false, false);
        }
        catch (SessionServiceException e1) {
            throw new AdminProcessingException((Throwable)e1);
        }
        catch (LoginException e1) {
            throw new AdminProcessingException((Throwable)e1);
        }
        return session;
    }

    List[] fixResults(List[] rows) throws SQLException {
        List[] newResults = new List[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            List row = rows[i];
            ArrayList<String> newRow = new ArrayList<String>();
            for (Object col : row) {
                if (col == null) {
                    newRow.add("null");
                    continue;
                }
                if (col instanceof Number || col instanceof String || col instanceof Character) {
                    newRow.add((String)col);
                    continue;
                }
                if (col instanceof Blob) {
                    newRow.add("blob");
                    continue;
                }
                if (col instanceof Clob) {
                    newRow.add("clob");
                    continue;
                }
                if (col instanceof SQLXML) {
                    SQLXML xml = (SQLXML)col;
                    newRow.add(xml.getString());
                    continue;
                }
                newRow.add(col.toString());
            }
            newResults[i] = newRow;
        }
        return newResults;
    }

    public String getEventDistributorName() {
        return this.eventDistributorName;
    }

    public void setEventDistributorName(String eventDistributorName) {
        this.eventDistributorName = eventDistributorName;
    }

    public void updateMatViewRow(String vdbName, int vdbVersion, String schema, String viewName, List<?> tuple, boolean delete) {
        this.dqpCore.updateMatViewRow(this.getcontextProvider(), vdbName, vdbVersion, schema, viewName, tuple, delete);
    }

    public void refreshMatView(String vdbName, int vdbVersion, String viewName) {
        this.dqpCore.refreshMatView(this.getcontextProvider(), vdbName, vdbVersion, viewName);
    }

    public void dataModification(String vdbName, int vdbVersion, String schema, String ... tableNames) {
        this.updateModified(true, vdbName, vdbVersion, schema, tableNames);
    }

    private void updateModified(boolean data, String vdbName, int vdbVersion, String schema, String ... objectNames) {
        Schema s = this.getSchema(vdbName, vdbVersion, schema);
        if (s == null) {
            return;
        }
        long ts = System.currentTimeMillis();
        for (String name : objectNames) {
            Table table = (Table)s.getTables().get(name.toUpperCase());
            if (table == null) continue;
            if (data) {
                table.setLastDataModification(ts);
                continue;
            }
            table.setLastModified(ts);
        }
    }

    public void setColumnStats(String vdbName, int vdbVersion, String schemaName, String tableName, String columnName, ColumnStats stats) {
        Table t = this.getTable(vdbName, vdbVersion, schemaName, tableName);
        if (t == null) {
            return;
        }
        for (Column c : t.getColumns()) {
            if (!c.getName().equalsIgnoreCase(columnName)) continue;
            c.setColumnStats(stats);
            t.setLastModified(System.currentTimeMillis());
            break;
        }
    }

    public void setTableStats(String vdbName, int vdbVersion, String schemaName, String tableName, TableStats stats) {
        Table t = this.getTable(vdbName, vdbVersion, schemaName, tableName);
        if (t == null) {
            return;
        }
        t.setTableStats(stats);
        t.setLastModified(System.currentTimeMillis());
    }

    private Table getTable(String vdbName, int vdbVersion, String schemaName, String tableName) {
        Schema s = this.getSchema(vdbName, vdbVersion, schemaName);
        if (s == null) {
            return null;
        }
        return (Table)s.getTables().get(tableName.toUpperCase());
    }

    private Schema getSchema(String vdbName, int vdbVersion, String schemaName) {
        VDBMetaData vdb = this.vdbRepository.getVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return null;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return null;
        }
        return (Schema)tm.getMetadataStore().getSchemas().get(schemaName.toUpperCase());
    }

    public void setInsteadOfTriggerDefinition(String vdbName, int vdbVersion, String schema, String viewName, Table.TriggerEvent triggerEvent, String triggerDefinition, Boolean enabled) {
        Table t = this.getTable(vdbName, vdbVersion, schema, viewName);
        if (t == null) {
            return;
        }
        DdlPlan.alterInsteadOfTrigger((VDBMetaData)this.vdbRepository.getVDB(vdbName, vdbVersion), (Table)t, (String)triggerDefinition, (Boolean)enabled, (Table.TriggerEvent)triggerEvent);
    }

    public void setProcedureDefinition(String vdbName, int vdbVersion, String schema, String procName, String definition) {
        Schema s = this.getSchema(vdbName, vdbVersion, schema);
        if (s == null) {
            return;
        }
        Procedure p = (Procedure)s.getProcedures().get(procName.toUpperCase());
        if (p == null) {
            return;
        }
        DdlPlan.alterProcedureDefinition((VDBMetaData)this.vdbRepository.getVDB(vdbName, vdbVersion), (Procedure)p, (String)definition);
    }

    public void setViewDefinition(String vdbName, int vdbVersion, String schema, String viewName, String definition) {
        Table t = this.getTable(vdbName, vdbVersion, schema, viewName);
        if (t == null) {
            return;
        }
        DdlPlan.alterView((VDBMetaData)this.vdbRepository.getVDB(vdbName, vdbVersion), (Table)t, (String)definition);
    }

    public void setProperty(String vdbName, int vdbVersion, String uuid, String name, String value) {
        VDBMetaData vdb = this.vdbRepository.getVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return;
        }
        AbstractMetadataRecord record = DataTierManagerImpl.getByUuid((CompositeMetadataStore)tm.getMetadataStore(), (String)uuid);
        if (record != null) {
            record.setProperty(name, value);
        }
    }

    public EventDistributor getEventDistributor() {
        return this.eventDistributorProxy;
    }

    private void synchronizeMaterializeViews() {
        this.lifecycleListener.addListener(new ContainerLifeCycleListener.LifeCycleEventListener(){

            public void onStartupFinish() {
                RuntimeEngineDeployer.this.dqpCore.synchronizeInternalMaterializedViews(RuntimeEngineDeployer.this.getcontextProvider());
            }

            public void onShutdownStart() {
            }
        });
    }

    private DQPCore.ContextProvider getcontextProvider() {
        return new DQPCore.ContextProvider(){

            public DQPWorkContext getContext(final String vdbName, final int vdbVersion) {
                return new DQPWorkContext(){

                    public VDBMetaData getVDB() {
                        return RuntimeEngineDeployer.this.vdbRepository.getVDB(vdbName, vdbVersion);
                    }

                    public String getVdbName() {
                        return vdbName;
                    }

                    public int getVdbVersion() {
                        return vdbVersion;
                    }
                };
            }
        };
    }

    public void setContainerLifeCycleListener(ContainerLifeCycleListener listener) {
        this.lifecycleListener = listener;
    }
}

