/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.VDBOperations;

class ChangeVDBConnectionType
extends VDBOperations {
    public ChangeVDBConnectionType() {
        super("change-vdb-connection-type");
    }

    @Override
    protected void executeOperation(OperationContext context, VDBMetaData vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("connection-type")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("connection-type.missing")));
        }
        String connectionType = operation.get("connection-type").asString();
        try {
            vdb.setConnectionType(connectionType);
            this.save(vdb);
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        super.describeParameters(operationNode, bundle);
        operationNode.get(new String[]{"request-properties", "connection-type", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "connection-type", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "connection-type", "description"}).set(this.getParameterDescription(bundle, "connection-type"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

