/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.LRUCache;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TransactionServerImpl;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;
import org.teiid.logging.LogManager;
import org.teiid.vdb.runtime.VDBKey;

public class DQPCoreService
extends DQPConfiguration
implements Serializable,
Service<DQPCore> {
    private static final long serialVersionUID = -4676205340262775388L;
    private transient TransactionServerImpl transactionServerImpl = new TransactionServerImpl();
    private transient DQPCore dqpCore = new DQPCore();
    private final InjectedValue<WorkManager> workManagerInjector = new InjectedValue();
    private final InjectedValue<XATerminator> xaTerminatorInjector = new InjectedValue();
    private final InjectedValue<TransactionManager> txnManagerInjector = new InjectedValue();
    private final InjectedValue<BufferManager> bufferManagerInjector = new InjectedValue();
    private final InjectedValue<TranslatorRepository> translatorRepositoryInjector = new InjectedValue();
    private final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    private final InjectedValue<AuthorizationValidator> authorizationValidatorInjector = new InjectedValue();
    private final InjectedValue<SessionAwareCache> preparedPlanCacheInjector = new InjectedValue();
    private final InjectedValue<SessionAwareCache> resultSetCacheInjector = new InjectedValue();
    private final InjectedValue<EventDistributorFactory> eventDistributorFactoryInjector = new InjectedValue();

    public void start(final StartContext context) {
        this.transactionServerImpl.setWorkManager((WorkManager)this.getWorkManagerInjector().getValue());
        this.transactionServerImpl.setXaTerminator((XATerminator)this.getXaTerminatorInjector().getValue());
        this.transactionServerImpl.setTransactionManager((TransactionManager)this.getTxnManagerInjector().getValue());
        this.setAuthorizationValidator((AuthorizationValidator)this.authorizationValidatorInjector.getValue());
        this.dqpCore.setBufferManager((BufferManager)this.bufferManagerInjector.getValue());
        this.dqpCore.setTransactionService((TransactionService)LogManager.createLoggingProxy((String)"org.teiid.TXN_LOG", (Object)this.transactionServerImpl, (Class[])new Class[]{TransactionService.class}, (int)5, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        this.dqpCore.setEventDistributor(((EventDistributorFactory)this.getEventDistributorFactoryInjector().getValue()).getEventDistributor());
        this.dqpCore.setResultsetCache((SessionAwareCache)this.getResultSetCacheInjector().getValue());
        this.dqpCore.setPreparedPlanCache((SessionAwareCache)this.getPreparedPlanCacheInjector().getValue());
        this.dqpCore.start((DQPConfiguration)this);
        this.getVdbRepository().addListener(new VDBLifeCycleListener(){
            private Set<VDBKey> recentlyRemoved = Collections.newSetFromMap(new LRUCache(10000));

            public void removed(String name, int version, CompositeVDB vdb) {
                this.recentlyRemoved.add(new VDBKey(name, version));
            }

            public void added(String name, int version, CompositeVDB vdb) {
                if (!this.recentlyRemoved.remove(new VDBKey(name, version))) {
                    return;
                }
                List services = context.getController().getServiceContainer().getServiceNames();
                for (ServiceName service : services) {
                    ServiceController transport;
                    if (!TeiidServiceNames.TRANSPORT_BASE.isParentOf(service) || (transport = context.getController().getServiceContainer().getService(service)) == null) continue;
                    TransportService t = (TransportService)TransportService.class.cast(transport.getValue());
                    Collection<SessionMetadata> sessions = t.getActiveSessions();
                    for (SessionMetadata session : sessions) {
                        if (!name.equalsIgnoreCase(session.getVDBName()) || version != session.getVDBVersion()) continue;
                        t.terminateSession(session.getSessionId());
                    }
                }
                if (DQPCoreService.this.getResultSetCacheInjector().getValue() != null) {
                    ((SessionAwareCache)DQPCoreService.this.getResultSetCacheInjector().getValue()).clearForVDB(name, version);
                }
                if (DQPCoreService.this.getPreparedPlanCacheInjector().getValue() != null) {
                    ((SessionAwareCache)DQPCoreService.this.getPreparedPlanCacheInjector().getValue()).clearForVDB(name, version);
                }
            }

            public void finishedDeployment(String name, int version, CompositeVDB vdb) {
            }
        });
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50001, new Object[]{this.dqpCore.getRuntimeVersion(), new Date(System.currentTimeMillis()).toString()}));
    }

    public DQPCore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.dqpCore;
    }

    public void stop(StopContext context) {
        try {
            this.dqpCore.stop();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50002, new Object[]{new Date(System.currentTimeMillis()).toString()}));
    }

    public InjectedValue<SessionAwareCache> getResultSetCacheInjector() {
        return this.resultSetCacheInjector;
    }

    public InjectedValue<SessionAwareCache> getPreparedPlanCacheInjector() {
        return this.preparedPlanCacheInjector;
    }

    public InjectedValue<TranslatorRepository> getTranslatorRepositoryInjector() {
        return this.translatorRepositoryInjector;
    }

    public InjectedValue<VDBRepository> getVdbRepositoryInjector() {
        return this.vdbRepositoryInjector;
    }

    private VDBRepository getVdbRepository() {
        return (VDBRepository)this.vdbRepositoryInjector.getValue();
    }

    public InjectedValue<AuthorizationValidator> getAuthorizationValidatorInjector() {
        return this.authorizationValidatorInjector;
    }

    public InjectedValue<BufferManager> getBufferManagerInjector() {
        return this.bufferManagerInjector;
    }

    public InjectedValue<TransactionManager> getTxnManagerInjector() {
        return this.txnManagerInjector;
    }

    public InjectedValue<XATerminator> getXaTerminatorInjector() {
        return this.xaTerminatorInjector;
    }

    public InjectedValue<WorkManager> getWorkManagerInjector() {
        return this.workManagerInjector;
    }

    public InjectedValue<EventDistributorFactory> getEventDistributorFactoryInjector() {
        return this.eventDistributorFactoryInjector;
    }
}

