/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidOperationHandler;

class ListRequestsPerSession
extends TeiidOperationHandler {
    protected ListRequestsPerSession() {
        super("list-requests-per-session");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("session")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("session.missing")));
        }
        ModelNode result = context.getResult();
        List requests = engine.getRequestsForSession(operation.get("session").asString());
        for (RequestMetadata request : requests) {
            VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, result.add());
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "session", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "session", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "session", "description"}).set(this.getParameterDescription(bundle, "session"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        VDBMetadataMapper.RequestMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

