/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Collection;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TransportService;

class ListSessions
extends TeiidOperationHandler {
    protected ListSessions() {
        super("list-sessions");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        for (TransportService t : this.transports) {
            Collection<SessionMetadata> sessions = t.getActiveSessions();
            for (SessionMetadata session : sessions) {
                VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, result.add());
            }
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        VDBMetadataMapper.SessionMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

