/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.VDBOperations;

class RemoveAnyAuthenticatedDataRole
extends VDBOperations {
    public RemoveAnyAuthenticatedDataRole() {
        super("remove-anyauthenticated-role");
    }

    @Override
    protected void executeOperation(OperationContext context, VDBMetaData vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("data-role")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("data-role.missing")));
        }
        String policyName = operation.get("data-role").asString();
        try {
            DataPolicyMetadata policy = vdb.getDataPolicy(policyName);
            if (policy == null) {
                throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50053, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50053, new Object[]{policyName, vdb.getName(), vdb.getVersion()}));
            }
            policy.setAnyAuthenticated(false);
            this.save(vdb);
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        super.describeParameters(operationNode, bundle);
        operationNode.get(new String[]{"request-properties", "data-role", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "data-role", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "data-role", "description"}).set(this.getParameterDescription(bundle, "data-role"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

