/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static SecurityContext clearSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    static void pushSecurityContext(final Principal p, final Object cred, final Subject subject, final String securityDomain) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc;
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)securityDomain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SecurityActions.setSecurityContext(sc);
                return null;
            }
        });
    }

    static void addCredentials(Subject subject, PasswordCredential cred) {
        AddCredentialsAction action = new AddCredentialsAction(subject, cred);
        AccessController.doPrivileged(action);
    }

    static class AddCredentialsAction
    implements PrivilegedAction {
        Subject subject;
        PasswordCredential cred;

        AddCredentialsAction(Subject subject, PasswordCredential cred) {
            this.subject = subject;
            this.cred = cred;
        }

        public Object run() {
            this.subject.getPrivateCredentials().add(this.cred);
            return null;
        }
    }
}

