/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.teiid.PolicyDecider;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.SystemVDBDeployer;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DataRolePolicyDecider;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.CacheFactoryService;
import org.teiid.jboss.CacheService;
import org.teiid.jboss.DQPCoreService;
import org.teiid.jboss.DynamicVDBRootMountDeployer;
import org.teiid.jboss.Element;
import org.teiid.jboss.EventDistributorFactoryService;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.JGroupsObjectReplicatorService;
import org.teiid.jboss.ObjectsSerializerService;
import org.teiid.jboss.PreparedPlanCacheService;
import org.teiid.jboss.ReferenceFactoryService;
import org.teiid.jboss.SystemVDBService;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TranslatorDependencyDeployer;
import org.teiid.jboss.TranslatorDeployer;
import org.teiid.jboss.TranslatorStructureDeployer;
import org.teiid.jboss.TupleBufferCacheService;
import org.teiid.jboss.VDBDependencyDeployer;
import org.teiid.jboss.VDBDeployer;
import org.teiid.jboss.VDBParserDeployer;
import org.teiid.jboss.VDBRepositoryService;
import org.teiid.jboss.VDBStructureDeployer;
import org.teiid.logging.LogManager;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;

class TeiidAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static Element[] attributes = new Element[]{Element.ALLOW_ENV_FUNCTION_ELEMENT, Element.ASYNC_THREAD_POOL_ELEMENT, Element.MAX_THREADS_ELEMENT, Element.MAX_ACTIVE_PLANS_ELEMENT, Element.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT, Element.TIME_SLICE_IN_MILLI_ELEMENT, Element.MAX_ROWS_FETCH_SIZE_ELEMENT, Element.LOB_CHUNK_SIZE_IN_KB_ELEMENT, Element.QUERY_THRESHOLD_IN_SECS_ELEMENT, Element.MAX_SOURCE_ROWS_ELEMENT, Element.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT, Element.DETECTING_CHANGE_EVENTS_ELEMENT, Element.QUERY_TIMEOUT, Element.WORKMANAGER, Element.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT, Element.POLICY_DECIDER_MODULE_ELEMENT, Element.DC_STACK_ATTRIBUTE, Element.USE_DISK_ATTRIBUTE, Element.INLINE_LOBS, Element.PROCESSOR_BATCH_SIZE_ATTRIBUTE, Element.CONNECTOR_BATCH_SIZE_ATTRIBUTE, Element.MAX_PROCESSING_KB_ATTRIBUTE, Element.MAX_RESERVED_KB_ATTRIBUTE, Element.MAX_FILE_SIZE_ATTRIBUTE, Element.MAX_BUFFER_SPACE_ATTRIBUTE, Element.MAX_OPEN_FILES_ATTRIBUTE, Element.MEMORY_BUFFER_SPACE_ATTRIBUTE, Element.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE, Element.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE, Element.PPC_MAX_ENTRIES_ATTRIBUTE, Element.PPC_MAX_AGE_IN_SECS_ATTRIBUTE, Element.RSC_NAME_ELEMENT, Element.RSC_CONTAINER_NAME_ELEMENT, Element.RSC_MAX_STALENESS_ELEMENT, Element.RSC_ENABLE_ATTRIBUTE};

    TeiidAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = IntegrationPlugin.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("teiid.add"));
        TeiidAdd.describeTeiid(node, "request-properties", bundle);
        return node;
    }

    static void describeTeiid(ModelNode node, String type, ResourceBundle bundle) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].describe(node, type, bundle);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        TeiidAdd.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) {
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i].populate(operation, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                classloader = Module.getCallerModule().getClassLoader();
            }
            catch (Throwable t) {
                // empty catch block
            }
            Thread.currentThread().setContextClassLoader(classloader);
            this.initilaizeTeiidEngine(context, operation, newControllers);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private void initilaizeTeiidEngine(OperationContext context, ModelNode operation, List<ServiceController<?>> newControllers) throws OperationFailedException {
        AuthorizationValidator authValidator;
        PolicyDecider policyDecider;
        ServiceTarget target = context.getServiceTarget();
        JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();
        final String asyncThreadPoolName = Element.ASYNC_THREAD_POOL_ELEMENT.asString(operation);
        final TranslatorRepository translatorRepo = new TranslatorRepository();
        ValueService translatorService = new ValueService((Value)new Value<TranslatorRepository>(){

            public TranslatorRepository getValue() throws IllegalStateException, IllegalArgumentException {
                return translatorRepo;
            }
        });
        ServiceController service = target.addService(TeiidServiceNames.TRANSLATOR_REPO, (Service)translatorService).install();
        newControllers.add(service);
        SystemFunctionManager systemFunctionManager = new SystemFunctionManager();
        if (Element.ALLOW_ENV_FUNCTION_ELEMENT.isDefined(operation)) {
            systemFunctionManager.setAllowEnvFunction(Element.ALLOW_ENV_FUNCTION_ELEMENT.asBoolean(operation));
        } else {
            systemFunctionManager.setAllowEnvFunction(false);
        }
        systemFunctionManager.setClassloader(Thread.currentThread().getContextClassLoader());
        VDBRepository vdbRepository = new VDBRepository();
        vdbRepository.setSystemFunctionManager(systemFunctionManager);
        VDBRepositoryService vdbRepositoryService = new VDBRepositoryService(vdbRepository);
        newControllers.add(target.addService(TeiidServiceNames.VDB_REPO, (Service)vdbRepositoryService).install());
        final VDBStatusCheckerExecutorService statusChecker = new VDBStatusCheckerExecutorService(vdbRepository);
        statusChecker.setTranslatorRepository(translatorRepo);
        ValueService statusService = new ValueService((Value)new Value<VDBStatusChecker>(){

            public VDBStatusChecker getValue() throws IllegalStateException, IllegalArgumentException {
                return statusChecker;
            }
        });
        ServiceBuilder statusBuilder = target.addService(TeiidServiceNames.VDB_STATUS_CHECKER, (Service)statusService);
        statusBuilder.addDependency(TeiidServiceNames.executorServiceName(asyncThreadPoolName), Executor.class, statusChecker.executorInjector);
        newControllers.add(statusBuilder.install());
        SystemVDBDeployer systemVDB = new SystemVDBDeployer();
        systemVDB.setVDBRepository(vdbRepository);
        SystemVDBService systemVDBService = new SystemVDBService(systemVDB);
        newControllers.add(target.addService(TeiidServiceNames.SYSTEM_VDB, (Service)systemVDBService).install());
        newControllers.add(RelativePathService.addService((ServiceName)TeiidServiceNames.DATA_DIR, (String)"teiid-data", (String)"jboss.server.data.dir", (ServiceTarget)target));
        ObjectsSerializerService serializer = new ObjectsSerializerService();
        ServiceBuilder objectSerializerService = target.addService(TeiidServiceNames.OBJECT_SERIALIZER, (Service)serializer);
        objectSerializerService.addDependency(TeiidServiceNames.DATA_DIR, String.class, serializer.getPathInjector());
        newControllers.add(objectSerializerService.install());
        boolean replicatorAvailable = false;
        if (Element.DC_STACK_ATTRIBUTE.isDefined(operation)) {
            String stack = Element.DC_STACK_ATTRIBUTE.asString(operation);
            replicatorAvailable = true;
            JGroupsObjectReplicatorService replicatorService = new JGroupsObjectReplicatorService();
            ServiceBuilder serviceBuilder = target.addService(TeiidServiceNames.OBJECT_REPLICATOR, (Service)replicatorService);
            serviceBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"jgroups", "stack", stack}), ChannelFactory.class, replicatorService.channelFactoryInjector);
            newControllers.add(serviceBuilder.install());
        }
        newControllers.add(RelativePathService.addService((ServiceName)TeiidServiceNames.BUFFER_DIR, (String)"teiid-buffer", (String)"jboss.server.temp.dir", (ServiceTarget)target));
        BufferManagerService bufferService = this.buildBufferManager(operation);
        ServiceBuilder bufferServiceBuilder = target.addService(TeiidServiceNames.BUFFER_MGR, (Service)bufferService);
        bufferServiceBuilder.addDependency(TeiidServiceNames.BUFFER_DIR, String.class, bufferService.pathInjector);
        newControllers.add(bufferServiceBuilder.install());
        TupleBufferCacheService tupleBufferService = new TupleBufferCacheService();
        ServiceBuilder tupleBufferBuilder = target.addService(TeiidServiceNames.TUPLE_BUFFER, (Service)tupleBufferService);
        tupleBufferBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, tupleBufferService.bufferMgrInjector);
        tupleBufferBuilder.addDependency(replicatorAvailable ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, tupleBufferService.replicatorInjector);
        newControllers.add(tupleBufferBuilder.install());
        EventDistributorFactoryService edfs = new EventDistributorFactoryService();
        ServiceBuilder edfsServiceBuilder = target.addService(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, (Service)edfs);
        edfsServiceBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, edfs.vdbRepositoryInjector);
        edfsServiceBuilder.addDependency(replicatorAvailable ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.OBJECT_REPLICATOR, ObjectReplicator.class, edfs.objectReplicatorInjector);
        newControllers.add(edfsServiceBuilder.install());
        if (Element.POLICY_DECIDER_MODULE_ELEMENT.isDefined(operation)) {
            policyDecider = this.buildService(PolicyDecider.class, Element.POLICY_DECIDER_MODULE_ELEMENT.asString(operation));
        } else {
            DataRolePolicyDecider drpd = new DataRolePolicyDecider();
            drpd.setAllowCreateTemporaryTablesByDefault(true);
            drpd.setAllowFunctionCallsByDefault(true);
            policyDecider = drpd;
        }
        if (Element.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT.isDefined(operation)) {
            authValidator = this.buildService(AuthorizationValidator.class, Element.AUTHORIZATION_VALIDATOR_MODULE_ELEMENT.asString(operation));
            authValidator.setEnabled(true);
        } else {
            DefaultAuthorizationValidator dap = new DefaultAuthorizationValidator();
            dap.setPolicyDecider(policyDecider);
            dap.setEnabled(true);
            authValidator = dap;
        }
        ValueService authValidatorService = new ValueService((Value)new Value<AuthorizationValidator>(){

            public AuthorizationValidator getValue() throws IllegalStateException, IllegalArgumentException {
                return authValidator;
            }
        });
        newControllers.add(target.addService(TeiidServiceNames.AUTHORIZATION_VALIDATOR, (Service)authValidatorService).install());
        boolean rsCache = true;
        if (Element.RSC_ENABLE_ATTRIBUTE.isDefined(operation) && !Element.RSC_ENABLE_ATTRIBUTE.asBoolean(operation)) {
            rsCache = false;
        }
        String infinispanCacheContainer = null;
        if (Element.RSC_CONTAINER_NAME_ELEMENT.isDefined(operation)) {
            infinispanCacheContainer = Element.RSC_CONTAINER_NAME_ELEMENT.asString(operation);
        }
        String cacheName = null;
        if (Element.RSC_NAME_ELEMENT.isDefined(operation)) {
            cacheName = Element.RSC_NAME_ELEMENT.asString(operation);
        }
        if (rsCache) {
            ServiceName cfName = ServiceName.JBOSS.append(new String[]{"teiid", "infinispan-cache-factory"});
            CacheFactoryService cfs = new CacheFactoryService(cacheName);
            ServiceBuilder cacheFactoryBuilder = target.addService(cfName, (Service)cfs);
            if (infinispanCacheContainer != null) {
                cacheFactoryBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", infinispanCacheContainer}), CacheContainer.class, cfs.cacheContainerInjector);
            }
            newControllers.add(cacheFactoryBuilder.install());
            CacheService resultSetService = new CacheService(SessionAwareCache.Type.RESULTSET, this.buildCacheConfig(operation));
            ServiceBuilder resultsCacheBuilder = target.addService(TeiidServiceNames.CACHE_RESULTSET, resultSetService);
            resultsCacheBuilder.addDependency(TeiidServiceNames.TUPLE_BUFFER, TupleBufferCache.class, resultSetService.tupleBufferCacheInjector);
            resultsCacheBuilder.addDependency(cfName, CacheFactory.class, resultSetService.cacheFactoryInjector);
            newControllers.add(resultsCacheBuilder.install());
        }
        PreparedPlanCacheService preparedPlanService = new PreparedPlanCacheService(SessionAwareCache.Type.PREPAREDPLAN, this.buildPreparedPlanCacheConfig(operation));
        ServiceBuilder preparedPlanCacheBuilder = target.addService(TeiidServiceNames.CACHE_PREPAREDPLAN, (Service)preparedPlanService);
        preparedPlanCacheBuilder.addDependency(TeiidServiceNames.TUPLE_BUFFER, TupleBufferCache.class, preparedPlanService.tupleBufferCacheInjector);
        newControllers.add(preparedPlanCacheBuilder.install());
        DQPCoreService engine = this.buildQueryEngine(operation);
        String workManager = "default";
        if (Element.WORKMANAGER.isDefined(operation)) {
            workManager = Element.WORKMANAGER.asString(operation);
        }
        ServiceBuilder engineBuilder = target.addService(TeiidServiceNames.ENGINE, (Service)engine);
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"connector", "workmanager", workManager}), WorkManager.class, engine.getWorkManagerInjector());
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "XATerminator"}), XATerminator.class, engine.getXaTerminatorInjector());
        engineBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"}), TransactionManager.class, engine.getTxnManagerInjector());
        engineBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, engine.getBufferManagerInjector());
        engineBuilder.addDependency(TeiidServiceNames.SYSTEM_VDB, SystemVDBDeployer.class, (Injector)new InjectedValue());
        engineBuilder.addDependency(TeiidServiceNames.TRANSLATOR_REPO, TranslatorRepository.class, engine.getTranslatorRepositoryInjector());
        engineBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, engine.getVdbRepositoryInjector());
        engineBuilder.addDependency(TeiidServiceNames.AUTHORIZATION_VALIDATOR, AuthorizationValidator.class, engine.getAuthorizationValidatorInjector());
        engineBuilder.addDependency(rsCache ? ServiceBuilder.DependencyType.REQUIRED : ServiceBuilder.DependencyType.OPTIONAL, TeiidServiceNames.CACHE_RESULTSET, SessionAwareCache.class, engine.getResultSetCacheInjector());
        engineBuilder.addDependency(TeiidServiceNames.CACHE_PREPAREDPLAN, SessionAwareCache.class, engine.getPreparedPlanCacheInjector());
        engineBuilder.addDependency(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, EventDistributorFactory.class, engine.getEventDistributorFactoryInjector());
        engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = engineBuilder.install();
        newControllers.add(controller);
        ServiceContainer container = controller.getServiceContainer();
        container.addTerminateListener((ServiceContainer.TerminateListener)shutdownListener);
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(TeiidServiceNames.EVENT_DISTRIBUTOR_FACTORY, EventDistributorFactory.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        String jndiName = "teiid/event-distributor-factory";
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector());
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(referenceBuilder.install());
        newControllers.add(binderBuilder.install());
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{IntegrationPlugin.Util.getString("event_distributor_bound", new Object[]{jndiName})});
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 2048, (DeploymentUnitProcessor)new DynamicVDBRootMountDeployer());
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 2049, (DeploymentUnitProcessor)new VDBStructureDeployer());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 2817, (DeploymentUnitProcessor)new VDBParserDeployer());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 1537, (DeploymentUnitProcessor)new VDBDependencyDeployer());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 7424, (DeploymentUnitProcessor)new VDBDeployer(translatorRepo, asyncThreadPoolName, statusChecker));
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 1281, (DeploymentUnitProcessor)new TranslatorStructureDeployer());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 257, (DeploymentUnitProcessor)new TranslatorDependencyDeployer());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 6145, (DeploymentUnitProcessor)new TranslatorDeployer());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private <T> T buildService(Class<T> type, String moduleName) throws OperationFailedException {
        Module module;
        try {
            ModuleIdentifier moduleId = ModuleIdentifier.create((String)moduleName);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50069, new Object[]{moduleName})));
        }
        ServiceLoader services = module.loadService(type);
        return (T)services.iterator().next();
    }

    private BufferManagerService buildBufferManager(ModelNode node) {
        BufferManagerService bufferManger = new BufferManagerService();
        if (node == null) {
            return bufferManger;
        }
        if (Element.USE_DISK_ATTRIBUTE.isDefined(node)) {
            bufferManger.setUseDisk(Element.USE_DISK_ATTRIBUTE.asBoolean(node));
        }
        if (Element.PROCESSOR_BATCH_SIZE_ATTRIBUTE.isDefined(node)) {
            bufferManger.setProcessorBatchSize(Element.PROCESSOR_BATCH_SIZE_ATTRIBUTE.asInt(node));
        }
        if (Element.CONNECTOR_BATCH_SIZE_ATTRIBUTE.isDefined(node)) {
            bufferManger.setConnectorBatchSize(Element.CONNECTOR_BATCH_SIZE_ATTRIBUTE.asInt(node));
        }
        if (Element.MAX_PROCESSING_KB_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMaxProcessingKb(Element.MAX_PROCESSING_KB_ATTRIBUTE.asInt(node));
        }
        if (Element.MAX_RESERVED_KB_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMaxReserveKb(Element.MAX_RESERVED_KB_ATTRIBUTE.asInt(node));
        }
        if (Element.MAX_FILE_SIZE_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMaxFileSize(Element.MAX_FILE_SIZE_ATTRIBUTE.asLong(node));
        }
        if (Element.MAX_BUFFER_SPACE_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMaxBufferSpace(Element.MAX_BUFFER_SPACE_ATTRIBUTE.asLong(node));
        }
        if (Element.MAX_OPEN_FILES_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMaxOpenFiles(Element.MAX_OPEN_FILES_ATTRIBUTE.asInt(node));
        }
        if (Element.MEMORY_BUFFER_SPACE_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMemoryBufferSpace(Element.MEMORY_BUFFER_SPACE_ATTRIBUTE.asInt(node));
        }
        if (Element.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMemoryBufferOffHeap(Element.MEMORY_BUFFER_OFFHEAP_ATTRIBUTE.asBoolean(node));
        }
        if (Element.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE.isDefined(node)) {
            bufferManger.setMaxStorageObjectSize(Element.MAX_STORAGE_OBJECT_SIZE_ATTRIBUTE.asInt(node));
        }
        if (Element.INLINE_LOBS.isDefined(node)) {
            bufferManger.setInlineLobs(Element.INLINE_LOBS.asBoolean(node));
        }
        return bufferManger;
    }

    private CacheConfiguration buildCacheConfig(ModelNode node) {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setMaxEntries(1024);
        cacheConfig.setMaxAgeInSeconds(7200);
        cacheConfig.setType(CacheConfiguration.Policy.EXPIRATION.name());
        cacheConfig.setLocation("resultset");
        cacheConfig.setMaxStaleness(60);
        if (Element.RSC_MAX_STALENESS_ELEMENT.isDefined(node)) {
            cacheConfig.setMaxStaleness(Element.RSC_MAX_STALENESS_ELEMENT.asInt(node));
        }
        return cacheConfig;
    }

    private CacheConfiguration buildPreparedPlanCacheConfig(ModelNode node) {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        if (Element.PPC_MAX_ENTRIES_ATTRIBUTE.isDefined(node)) {
            cacheConfig.setMaxEntries(Element.PPC_MAX_ENTRIES_ATTRIBUTE.asInt(node));
        } else {
            cacheConfig.setMaxEntries(512);
        }
        if (Element.PPC_MAX_AGE_IN_SECS_ATTRIBUTE.isDefined(node)) {
            cacheConfig.setMaxAgeInSeconds(Element.PPC_MAX_AGE_IN_SECS_ATTRIBUTE.asInt(node));
        } else {
            cacheConfig.setMaxAgeInSeconds(28800);
        }
        cacheConfig.setType(CacheConfiguration.Policy.LRU.name());
        cacheConfig.setLocation("prepared");
        return cacheConfig;
    }

    private DQPCoreService buildQueryEngine(ModelNode node) {
        DQPCoreService engine = new DQPCoreService();
        if (Element.MAX_THREADS_ELEMENT.isDefined(node)) {
            engine.setMaxThreads(Element.MAX_THREADS_ELEMENT.asInt(node));
        }
        if (Element.MAX_ACTIVE_PLANS_ELEMENT.isDefined(node)) {
            engine.setMaxActivePlans(Element.MAX_ACTIVE_PLANS_ELEMENT.asInt(node));
        }
        if (Element.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT.isDefined(node)) {
            engine.setUserRequestSourceConcurrency(Element.USER_REQUEST_SOURCE_CONCURRENCY_ELEMENT.asInt(node));
        }
        if (Element.TIME_SLICE_IN_MILLI_ELEMENT.isDefined(node)) {
            engine.setTimeSliceInMilli(Element.TIME_SLICE_IN_MILLI_ELEMENT.asInt(node));
        }
        if (Element.MAX_ROWS_FETCH_SIZE_ELEMENT.isDefined(node)) {
            engine.setMaxRowsFetchSize(Element.MAX_ROWS_FETCH_SIZE_ELEMENT.asInt(node));
        }
        if (Element.LOB_CHUNK_SIZE_IN_KB_ELEMENT.isDefined(node)) {
            engine.setLobChunkSizeInKB(Element.LOB_CHUNK_SIZE_IN_KB_ELEMENT.asInt(node));
        }
        if (Element.QUERY_THRESHOLD_IN_SECS_ELEMENT.isDefined(node)) {
            engine.setQueryThresholdInSecs(Element.QUERY_THRESHOLD_IN_SECS_ELEMENT.asInt(node));
        }
        if (Element.MAX_SOURCE_ROWS_ELEMENT.isDefined(node)) {
            engine.setMaxSourceRows(Element.MAX_SOURCE_ROWS_ELEMENT.asInt(node));
        }
        if (Element.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT.isDefined(node)) {
            engine.setExceptionOnMaxSourceRows(Element.EXCEPTION_ON_MAX_SOURCE_ROWS_ELEMENT.asBoolean(node));
        }
        if (Element.DETECTING_CHANGE_EVENTS_ELEMENT.isDefined(node)) {
            engine.setDetectingChangeEvents(Element.DETECTING_CHANGE_EVENTS_ELEMENT.asBoolean(node));
        }
        if (Element.QUERY_TIMEOUT.isDefined(node)) {
            engine.setQueryTimeout(Element.QUERY_TIMEOUT.asLong(node));
        }
        return engine;
    }

    static class VDBStatusCheckerExecutorService
    extends VDBStatusChecker {
        final InjectedValue<Executor> executorInjector = new InjectedValue();

        public VDBStatusCheckerExecutorService(VDBRepository vdbRepository) {
            super(vdbRepository);
        }

        public Executor getExecutor() {
            return (Executor)this.executorInjector.getValue();
        }
    }
}

