/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.stream.XMLStreamException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.DelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

class VDBService
implements Service<VDBMetaData> {
    private VDBMetaData vdb;
    private final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    private final InjectedValue<TranslatorRepository> translatorRepositoryInjector = new InjectedValue();
    private final InjectedValue<Executor> executorInjector = new InjectedValue();
    private final InjectedValue<ObjectSerializer> serializerInjector = new InjectedValue();
    private final InjectedValue<BufferManager> bufferManagerInjector = new InjectedValue();
    private final InjectedValue<ObjectReplicator> objectReplicatorInjector = new InjectedValue();
    private VDBLifeCycleListener vdbListener;

    public VDBService(VDBMetaData metadata) {
        this.vdb = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        TranslatorRepository repo = new TranslatorRepository();
        this.vdb.addAttchment(TranslatorRepository.class, (Object)repo);
        UDFMetaData udf = (UDFMetaData)this.vdb.getAttachment(UDFMetaData.class);
        for (Translator t : this.vdb.getOverrideTranslators()) {
            VDBTranslatorMetaData data = (VDBTranslatorMetaData)t;
            String type = data.getType();
            VDBTranslatorMetaData parent = this.getTranslatorRepository().getTranslatorMetaData(type);
            data.setModuleName(parent.getModuleName());
            Set<String> keys = parent.getProperties().stringPropertyNames();
            for (String key : keys) {
                if (data.getPropertyValue(key) != null || parent.getPropertyValue(key) == null) continue;
                data.addProperty(key, parent.getPropertyValue(key));
            }
            repo.addTranslatorMetadata(data.getName(), data);
        }
        this.createConnectorManagers(cmr, repo, this.vdb);
        this.vdbListener = new VDBLifeCycleListener(){

            public void added(String name, int version, CompositeVDB vdb) {
            }

            public void removed(String name, int version, CompositeVDB vdb) {
            }

            public void finishedDeployment(String name, int version, CompositeVDB vdb) {
                if (!name.equals(VDBService.this.vdb.getName()) || version != VDBService.this.vdb.getVersion()) {
                    return;
                }
                GlobalTableStoreImpl gts = new GlobalTableStoreImpl(VDBService.this.getBuffermanager(), (QueryMetadataInterface)vdb.getVDB().getAttachment(TransformationMetadata.class));
                if (VDBService.this.getObjectReplicatorInjector().getValue() != null) {
                    try {
                        gts = (GlobalTableStore)((ObjectReplicator)VDBService.this.getObjectReplicatorInjector().getValue()).replicate(name + version, GlobalTableStore.class, (Object)gts, 300000L);
                        vdb.getVDB().addAttchment(GlobalTableStore.class, (Object)gts);
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50023, new Object[]{gts}));
                    }
                }
            }
        };
        this.getVDBRepository().addListener(this.vdbListener);
        boolean preview = this.vdb.isPreview();
        MetadataStore store = new MetadataStore();
        try {
            this.getVDBRepository().addVDB(this.vdb, store, udf, cmr);
        }
        catch (VirtualDatabaseException e) {
            throw new StartException(IntegrationPlugin.Event.TEIID50032.name(), (Throwable)e);
        }
        this.vdb.removeAttachment(UDFMetaData.class);
        for (ModelMetaData model : this.vdb.getModelMetaDatas().values()) {
            MetadataRepository metadataRepository = (MetadataRepository)model.getAttachment(MetadataRepository.class);
            if (metadataRepository == null) {
                throw new StartException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50086, new Object[]{model.getName(), this.vdb.getName(), this.vdb.getVersion()}));
            }
            model.addAttchment(MetadataRepository.class, (Object)metadataRepository);
            this.loadMetadata(this.vdb, model, cmr, metadataRepository, store);
            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", this.vdb.getName(), " was being loaded from its repository in separate thread"});
        }
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            if (preview) {
                this.vdb.setStatus(VDB.Status.ACTIVE);
            }
        }
    }

    public void stop(StopContext context) {
        if (this.getObjectReplicatorInjector().getValue() != null) {
            GlobalTableStore gts = (GlobalTableStore)this.vdb.getAttachment(GlobalTableStore.class);
            ((ObjectReplicator)this.getObjectReplicatorInjector().getValue()).stop((Object)gts);
        }
        this.getVDBRepository().removeListener(this.vdbListener);
        this.getVDBRepository().removeVDB(this.vdb.getName(), this.vdb.getVersion());
        this.vdb.setRemoved(true);
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50026, new Object[]{this.vdb}));
    }

    public VDBMetaData getValue() throws IllegalStateException, IllegalArgumentException {
        return this.vdb;
    }

    private void createConnectorManagers(ConnectorManagerRepository cmr, TranslatorRepository repo, VDBMetaData deployment) throws StartException {
        IdentityHashMap<Translator, ExecutionFactory<Object, Object>> map = new IdentityHashMap<Translator, ExecutionFactory<Object, Object>>();
        for (Model model : deployment.getModels()) {
            List sourceNames = model.getSourceNames();
            if (sourceNames.size() != new HashSet(sourceNames).size()) {
                throw new StartException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50033, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            for (String source : sourceNames) {
                ConnectorManager cm = cmr.getConnectorManager(source);
                String name = model.getSourceTranslatorName(source);
                String connection = model.getSourceConnectionJndiName(source);
                if (cm != null) {
                    if (cm.getTranslatorName().equals(name) && cm.getConnectionName().equals(connection)) continue;
                    throw new StartException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50034, new Object[]{source, deployment.getName(), deployment.getVersion()}));
                }
                cm = new ConnectorManager(name, connection);
                try {
                    ExecutionFactory<Object, Object> ef = VDBService.getExecutionFactory(name, repo, this.getTranslatorRepository(), deployment, map, new HashSet<String>());
                    cm.setExecutionFactory(ef);
                    cmr.addConnectorManager(source, cm);
                }
                catch (TranslatorNotFoundException e) {
                    if (e.getCause() != null) {
                        throw new StartException(IntegrationPlugin.Event.TEIID50035.name(), e.getCause());
                    }
                    throw new StartException(IntegrationPlugin.Event.TEIID50035.name() + " " + e.getMessage());
                }
            }
        }
    }

    static ExecutionFactory<Object, Object> getExecutionFactory(String name, TranslatorRepository vdbRepo, TranslatorRepository repo, VDBMetaData deployment, IdentityHashMap<Translator, ExecutionFactory<Object, Object>> map, HashSet<String> building) throws TranslatorNotFoundException {
        if (!building.add(name)) {
            throw new TranslatorNotFoundException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50076, new Object[]{deployment.getName(), deployment.getVersion(), building}));
        }
        VDBTranslatorMetaData translator = vdbRepo.getTranslatorMetaData(name);
        if (translator == null) {
            translator = repo.getTranslatorMetaData(name);
        }
        if (translator == null) {
            throw new TranslatorNotFoundException(RuntimePlugin.Util.getString("translator_not_found", new Object[]{deployment.getName(), deployment.getVersion(), name}));
        }
        try {
            ExecutionFactory ef = map.get(translator);
            if (ef == null) {
                DelegatingExecutionFactory delegator;
                String delegateName;
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                if (translator.getModuleName() != null) {
                    try {
                        ModuleIdentifier moduleId = ModuleIdentifier.create((String)translator.getModuleName());
                        Module module = Module.getCallerModuleLoader().loadModule(moduleId);
                        classloader = module.getClassLoader();
                    }
                    catch (ModuleLoadException e) {
                        throw new TeiidException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50057, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50057, new Object[]{translator.getModuleName(), translator.getName()}));
                    }
                }
                if ((ef = TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)translator, (ClassLoader)classloader)) instanceof DelegatingExecutionFactory && (delegateName = (delegator = (DelegatingExecutionFactory)ef).getDelegateName()) != null) {
                    ExecutionFactory<Object, Object> delegate = VDBService.getExecutionFactory(delegateName, vdbRepo, repo, deployment, map, building);
                    ((DelegatingExecutionFactory)ef).setDelegate(delegate);
                }
                map.put((Translator)translator, (ExecutionFactory<Object, Object>)ef);
            }
            return ef;
        }
        catch (TeiidException e) {
            throw new TranslatorNotFoundException(e);
        }
    }

    private boolean loadMetadata(final VDBMetaData vdb, final ModelMetaData model, final ConnectorManagerRepository cmr, final MetadataRepository metadataRepo, final MetadataStore vdbMetadataStore) {
        String msg = IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50029, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())});
        model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), msg);
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
        boolean asynch = false;
        Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean metadataLoaded = false;
                boolean cached = false;
                ArrayList<String> errorMessages = new ArrayList<String>();
                File cachedFile = VDBService.this.getSerializer().buildModelFile(vdb, model.getName());
                MetadataFactory factory = VDBService.this.getSerializer().loadSafe(cachedFile, MetadataFactory.class);
                if (factory != null) {
                    metadataLoaded = true;
                    cached = true;
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " was loaded from cached metadata"});
                }
                if (!metadataLoaded) {
                    boolean indexStore = metadataRepo instanceof IndexMetadataRepository;
                    Map datatypes = indexStore ? VDBService.this.getVDBRepository().getSystemStore().getDatatypes() : VDBService.this.getVDBRepository().getBuiltinDatatypes();
                    factory = new MetadataFactory(vdb.getName(), vdb.getVersion(), model.getName(), datatypes, model.getProperties(), model.getSchemaText());
                    ExecutionFactory ef = null;
                    Object cf = null;
                    try {
                        ConnectorManager cm = VDBService.this.getConnectorManager(model, cmr);
                        ef = cm == null ? null : cm.getExecutionFactory();
                        cf = cm == null ? null : cm.getConnectionFactory();
                    }
                    catch (TranslatorException e1) {
                        // empty catch block
                    }
                    try {
                        metadataRepo.loadMetadata(factory, ef, cf);
                        model.setSchemaText(null);
                        metadataLoaded = true;
                        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50030, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())}));
                    }
                    catch (TranslatorException e) {
                        errorMessages.add(e.getMessage());
                        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50036, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), e.getMessage()}));
                    }
                }
                VDBMetaData vDBMetaData = vdb;
                synchronized (vDBMetaData) {
                    if (metadataLoaded) {
                        if (!cached) {
                            VDBService.this.cacheMetadataStore(vdb, factory);
                        }
                        factory.mergeInto(vdbMetadataStore);
                        model.clearErrors();
                        if (vdb.isValid()) {
                            VDBService.this.getVDBRepository().finishDeployment(vdb.getName(), vdb.getVersion());
                        }
                    } else {
                        for (String errorMsg : errorMessages) {
                            model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), errorMsg);
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)errorMsg);
                        }
                    }
                }
                if (!metadataLoaded) {
                    model.addAttchment(Runnable.class, (Object)this);
                }
            }
        };
        Executor executor = this.getExecutor();
        if (executor == null) {
            job.run();
        } else {
            asynch = true;
            executor.execute(job);
        }
        return asynch;
    }

    private ConnectorManager getConnectorManager(ModelMetaData model, ConnectorManagerRepository cmr) {
        List mappings;
        Iterator i$;
        if (model.isSource() && (i$ = (mappings = model.getSourceMappings()).iterator()).hasNext()) {
            SourceMappingMetadata mapping = (SourceMappingMetadata)i$.next();
            return cmr.getConnectorManager(mapping.getName());
        }
        return null;
    }

    private void cacheMetadataStore(VDBMetaData vdb, MetadataFactory schema) {
        boolean cache;
        boolean bl = cache = !vdb.isDynamic();
        if (!vdb.isDynamic()) {
            cache = "cached".equalsIgnoreCase(vdb.getPropertyValue("UseConnectorMetadata"));
        }
        if (cache) {
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                File cachedFile = this.getSerializer().buildModelFile(vdb, model.getName());
                try {
                    this.getSerializer().saveAttachment(cachedFile, schema, false);
                }
                catch (IOException e) {
                    LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50044, new Object[]{vdb.getName(), vdb.getVersion(), model.getName()}));
                }
            }
        }
    }

    public InjectedValue<VDBRepository> getVDBRepositoryInjector() {
        return this.vdbRepositoryInjector;
    }

    private VDBRepository getVDBRepository() {
        return (VDBRepository)this.vdbRepositoryInjector.getValue();
    }

    public InjectedValue<TranslatorRepository> getTranslatorRepositoryInjector() {
        return this.translatorRepositoryInjector;
    }

    private TranslatorRepository getTranslatorRepository() {
        return (TranslatorRepository)this.translatorRepositoryInjector.getValue();
    }

    public InjectedValue<Executor> getExecutorInjector() {
        return this.executorInjector;
    }

    private Executor getExecutor() {
        return (Executor)this.executorInjector.getValue();
    }

    public InjectedValue<ObjectSerializer> getSerializerInjector() {
        return this.serializerInjector;
    }

    private ObjectSerializer getSerializer() {
        return (ObjectSerializer)this.serializerInjector.getValue();
    }

    public InjectedValue<BufferManager> getBufferManagerInjector() {
        return this.bufferManagerInjector;
    }

    private BufferManager getBuffermanager() {
        return (BufferManager)this.getBufferManagerInjector().getValue();
    }

    public InjectedValue<ObjectReplicator> getObjectReplicatorInjector() {
        return this.objectReplicatorInjector;
    }

    public void addDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        DataPolicyMetadata policy = this.vdb.getDataPolicy(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50058, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50058, new Object[]{policyName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        policy.addMappedRoleName(mappedRole);
        this.save();
    }

    public void remoteDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        DataPolicyMetadata policy = this.vdb.getDataPolicy(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50059, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50059, new Object[]{policyName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        policy.removeMappedRoleName(mappedRole);
        this.save();
    }

    public void addAnyAuthenticated(String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = this.vdb.getDataPolicy(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50060, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50060, new Object[]{policyName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        policy.setAnyAuthenticated(true);
        this.save();
    }

    public void removeAnyAuthenticated(String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = this.vdb.getDataPolicy(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50061, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50061, new Object[]{policyName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        policy.setAnyAuthenticated(false);
        this.save();
    }

    public void changeConnectionType(VDB.ConnectionType type) throws AdminProcessingException {
        this.vdb.setConnectionType(type);
        this.save();
    }

    public void assignDatasource(String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        ModelMetaData model = this.vdb.getModel(modelName);
        if (model == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50062, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50062, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        SourceMappingMetadata source = model.getSourceMapping(sourceName);
        if (source == null) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50063, IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50063, new Object[]{sourceName, modelName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        source.setTranslatorName(translatorName);
        source.setConnectionJndiName(dsName);
        this.save();
    }

    private void save() throws AdminProcessingException {
        try {
            ObjectSerializer os = this.getSerializer();
            VDBMetadataParser.marshell((VDBMetaData)this.vdb, (OutputStream)os.getVdbXmlOutputStream(this.vdb));
        }
        catch (IOException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50064, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50065, (Throwable)e);
        }
    }

    static class TranslatorNotFoundException
    extends TeiidException {
        public TranslatorNotFoundException(String msg) {
            super(msg);
        }

        public TranslatorNotFoundException(Throwable t) {
            super(t);
        }
    }
}

