/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Assert;
import org.jboss.as.cli.Util;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidAdd;
import org.teiid.jboss.TeiidExtension;
import org.teiid.jboss.TransportAdd;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestTeiidConfiguration
extends AbstractSubsystemTest {
    public TestTeiidConfiguration() {
        super("teiid", (Extension)new TeiidExtension());
    }

    @Test
    public void testDescribeHandler() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-sample-config.xml"));
        KernelServices servicesA = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode modelA = servicesA.readWholeModel();
        String marshalled = servicesA.getPersistedSubsystemXml();
        ModelNode describeOp = new ModelNode();
        describeOp.get("operation").set("describe");
        describeOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"teiid")}).toModelNode());
        List operations = AbstractSubsystemTest.checkResultAndGetContents((ModelNode)servicesA.executeOperation(describeOp)).asList();
        KernelServices servicesB = super.installInController(operations);
        ModelNode modelB = servicesB.readWholeModel();
        super.compare(modelA, modelB);
    }

    @Test
    public void testMinimumConfiguration() throws Exception {
        String subsystemXml = "<subsystem xmlns=\"urn:jboss:domain:teiid:1.0\">\n    <async-thread-pool>teiid-async</async-thread-pool></subsystem>";
        KernelServices services = super.installInController(subsystemXml);
        services.readWholeModel();
    }

    @Test
    public void testOutputPerisitence() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-sample-config.xml"));
        String json = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-model-json.txt"));
        ModelNode testModel = ModelNode.fromJSONString((String)json);
        String triggered = this.outputModel(testModel);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        Assert.assertEquals((String)marshalled, (String)triggered);
        Assert.assertEquals((String)this.normalizeXML(marshalled), (String)this.normalizeXML(triggered));
    }

    @Test
    public void testOutputModel() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-sample-config.xml"));
        String json = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-model-json.txt"));
        ModelNode testModel = ModelNode.fromJSONString((String)json);
        String triggered = this.outputModel(testModel);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        Assert.assertEquals((String)marshalled, (String)triggered);
        Assert.assertEquals((String)this.normalizeXML(marshalled), (String)this.normalizeXML(triggered));
    }

    @Test
    public void testSchema() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-sample-config.xml"));
        this.validate(subsystemXml);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        this.validate(marshalled);
    }

    private void validate(String marshalled) throws SAXException, IOException {
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource("schema/jboss-teiid.xsd");
        System.out.println(marshalled);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsdURL);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(marshalled.getBytes()));
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                if (!exception.getMessage().contains("cvc-enumeration-valid") && !exception.getMessage().contains("cvc-type")) {
                    Assert.fail((String)exception.getMessage());
                }
            }
        });
        validator.validate(source);
    }

    @Test
    public void testSubSystemDescription() throws IOException {
        ModelNode node = new ModelNode();
        TeiidAdd.describeTeiid((ModelNode)node, (String)"attributes", (ResourceBundle)IntegrationPlugin.getResourceBundle(null));
        Assert.assertEquals((String)ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-model-config.txt")), (String)node.toString());
    }

    @Test
    public void testtransportDescription() throws IOException {
        ModelNode node = new ModelNode();
        TransportAdd.describeTransport((ModelNode)node, (String)"attributes", (ResourceBundle)IntegrationPlugin.getResourceBundle(null));
        Assert.assertEquals((String)ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-transport-config.txt")), (String)node.toString());
    }

    @Test
    public void testParseSubsystem() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-sample-config.xml"));
        List operations = super.parse(subsystemXml);
        Assert.assertEquals((int)5, (int)operations.size());
        ModelNode addSubsystem = (ModelNode)operations.get(0);
        Assert.assertEquals((String)"add", (String)addSubsystem.get("operation").asString());
        PathAddress addr = PathAddress.pathAddress((ModelNode)addSubsystem.get("address"));
        Assert.assertEquals((int)1, (int)addr.size());
        PathElement element = addr.getElement(0);
        Assert.assertEquals((String)"subsystem", (String)element.getKey());
        Assert.assertEquals((String)"teiid", (String)element.getValue());
    }

    @Test
    public void testQueryOperations() throws Exception {
        KernelServices services = this.buildSubsystem();
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"teiid")});
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("read-operation-names");
        addOp.get("address").set(addr.toModelNode());
        ModelNode result = services.executeOperation(addOp);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        List<String> opNames = TestTeiidConfiguration.getList(result);
        Assert.assertEquals((int)39, (int)opNames.size());
        String[] ops = new String[]{"add", "add-anyauthenticated-role", "add-data-role", "assign-datasource", "cache-statistics", "cache-types", "cancel-request", "change-vdb-connection-type", "clear-cache", "describe", "execute-query", "get-plan", "get-translator", "get-vdb", "list-long-running-requests", "list-requests", "list-requests-per-session", "list-requests-per-vdb", "list-sessions", "list-transactions", "list-translators", "list-vdbs", "mark-datasource-available", "merge-vdbs", "read-attribute", "read-children-names", "read-children-resources", "read-children-types", "read-operation-description", "read-operation-names", "read-rar-description", "read-resource", "read-resource-description", "remove-anyauthenticated-role", "remove-data-role", "terminate-session", "terminate-transaction", "workerpool-statistics", "write-attribute"};
        Assert.assertEquals(Arrays.asList(ops), opNames);
    }

    @Test
    public void testAddRemoveTransport() throws Exception {
        KernelServices services = this.buildSubsystem();
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"teiid")});
        ModelNode read = new ModelNode();
        read.get("operation").set("read-children-names");
        read.get("address").set(addr.toModelNode());
        read.get("child-type").set("transport");
        ModelNode result = services.executeOperation(read);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        List<String> opNames = TestTeiidConfiguration.getList(result);
        Assert.assertEquals((int)2, (int)opNames.size());
        String[] ops = new String[]{"jdbc", "odbc"};
        Assert.assertEquals(Arrays.asList(ops), opNames);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(addr.toModelNode().add("transport", "newbie"));
        addOp.get("protocol").set("pg");
        addOp.get("socket-binding").set("socket");
        addOp.get("authentication-security-domain").set("teiid-security");
        result = services.executeOperation(addOp);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        result = services.executeOperation(read);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        opNames = TestTeiidConfiguration.getList(result);
        Assert.assertEquals((int)3, (int)opNames.size());
        String[] ops2 = new String[]{"jdbc", "newbie", "odbc"};
        Assert.assertEquals(Arrays.asList(ops2), opNames);
        ModelNode remove = new ModelNode();
        remove.get("operation").set("remove");
        remove.get("address").set(addr.toModelNode().add("transport", "jdbc"));
        result = services.executeOperation(remove);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        result = services.executeOperation(read);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        opNames = TestTeiidConfiguration.getList(result);
        Assert.assertEquals((int)2, (int)opNames.size());
        String[] ops3 = new String[]{"newbie", "odbc"};
        Assert.assertEquals(Arrays.asList(ops3), opNames);
    }

    private KernelServices buildSubsystem() throws IOException, FileNotFoundException, Exception {
        String subsystemXml = ObjectConverterUtil.convertToString((Reader)new FileReader("src/test/resources/teiid-sample-config.xml"));
        KernelServices services = super.installInController(subsystemXml);
        return services;
    }

    private static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    @Test
    public void testTranslator() throws Exception {
        KernelServices services = this.buildSubsystem();
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"teiid")});
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(addr.toModelNode().add("translator", "oracle"));
        ModelNode result = services.executeOperation(addOp);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        ModelNode read = new ModelNode();
        read.get("operation").set("read-children-names");
        read.get("address").set(addr.toModelNode());
        read.get("child-type").set("translator");
        result = services.executeOperation(read);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        List translators = Util.getList((ModelNode)result);
        Assert.assertTrue((boolean)translators.contains("oracle"));
        ModelNode resourceRead = new ModelNode();
        resourceRead.get("operation").set("read-resource");
        resourceRead.get("address").set(addr.toModelNode());
        resourceRead.get("translator").set("oracle");
        result = services.executeOperation(resourceRead);
        Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
    }
}

