/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.jboss.BaseCachehandler;
import org.teiid.jboss.IntegrationPlugin;

class CacheStatistics
extends BaseCachehandler {
    protected CacheStatistics() {
        super("cache-statistics");
    }

    @Override
    protected void executeOperation(OperationContext context, SessionAwareCache cache, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("cache-type")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("cache-type.missing")));
        }
        String cacheType = operation.get("cache-type").asString();
        if (cache == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50071, new Object[]{cacheType})));
        }
        ModelNode result = context.getResult();
        CacheStatisticsMetadata stats = this.buildCacheStats(cacheType, cache);
        VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE.wrap(stats, result.add());
    }

    private CacheStatisticsMetadata buildCacheStats(String name, SessionAwareCache cache) {
        CacheStatisticsMetadata stats = new CacheStatisticsMetadata();
        stats.setName(name);
        stats.setHitRatio(cache.getRequestCount() == 0 ? 0.0 : (double)cache.getCacheHitCount() / (double)cache.getRequestCount() * 100.0);
        stats.setTotalEntries(cache.getTotalCacheEntries());
        stats.setRequestCount(cache.getRequestCount());
        return stats;
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "cache-type", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "cache-type", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "cache-type", "description"}).set(this.getParameterDescription(bundle, "cache-type"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.LIST);
        VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

