/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SimplePrincipal;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;
import org.teiid.security.Credentials;
import org.teiid.services.SessionServiceImpl;
import org.teiid.services.TeiidLoginContext;

public class JBossSessionService
extends SessionServiceImpl {
    private Map<String, SecurityDomainContext> securityDomainMap;

    public JBossSessionService(Map<String, SecurityDomainContext> securityDomainMap) {
        this.securityDomainMap = securityDomainMap;
    }

    protected TeiidLoginContext authenticate(String userName, Credentials credentials, String applicationName, List<String> domains, boolean onlyallowPassthrough) throws LoginException {
        return this.authenticateUser(userName, credentials, applicationName, domains, this.securityDomainMap, onlyallowPassthrough);
    }

    private TeiidLoginContext authenticateUser(String username, Credentials credential, String applicationName, List<String> domains, Map<String, SecurityDomainContext> securityDomainMap, boolean onlyallowPassthrough) throws LoginException {
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"authenticateUser", username, applicationName});
        String baseUsername = JBossSessionService.getBaseUsername((String)username);
        if (onlyallowPassthrough) {
            for (String domain : this.getDomainsForUser(domains, username)) {
                Subject existing = this.securityHelper.getSubjectInContext(domain);
                if (existing == null) continue;
                return new TeiidLoginContext(this.getUserName(existing) + "@" + domain, existing, domain, this.securityHelper.getSecurityContext(domain));
            }
            throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50073, new Object[0]));
        }
        for (String domain : this.getDomainsForUser(domains, username)) {
            Subject subject;
            SimplePrincipal userPrincipal;
            boolean isValid;
            AuthenticationManager authManager;
            SecurityDomainContext securityDomainContext = securityDomainMap.get(domain);
            if (securityDomainContext == null || (authManager = securityDomainContext.getAuthenticationManager()) == null || !(isValid = authManager.isValid((Principal)(userPrincipal = new SimplePrincipal(username)), (Object)(credential == null ? null : new String(credential.getCredentialsAsCharArray())), subject = new Subject()))) continue;
            String userName = baseUsername + "@" + domain;
            Object securityContext = this.securityHelper.createSecurityContext(domain, (Principal)userPrincipal, (Object)(credential == null ? null : new String(credential.getCredentialsAsCharArray())), subject);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful for \"", username, "\""});
            return new TeiidLoginContext(userName, subject, domain, securityContext);
        }
        throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50072, new Object[]{username}));
    }

    private String getUserName(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        for (Principal p : principals) {
            if (p instanceof Group) continue;
            return p.getName();
        }
        return null;
    }
}

